/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.PopupParameter;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.ProfileHandler;
import com.ibm.lpex.core.StatusLineListener;
import com.ibm.lpex.core.View;

public final class Utilities {
    private Utilities() {
    }

    public static boolean updateText(LpexView lpexView, int line, int position, int deleteToLine, int deleteToPosition, String text) {
        return lpexView._view.updateText(line, position, deleteToLine, deleteToPosition, text);
    }

    public static void resetText(LpexView lpexView, String text, boolean keepEnvironment) {
        if (keepEnvironment) {
            lpexView._view.resetText(text);
        } else {
            lpexView.setText(text);
        }
    }

    public static void addStatusLineListener(LpexWindow lpexWindow, StatusLineListener listener) {
        if (lpexWindow != null) {
            lpexWindow.statusLineManager().addListener(listener);
        }
    }

    public static void removeStatusLineListener(LpexWindow lpexWindow, StatusLineListener listener) {
        if (lpexWindow != null) {
            lpexWindow.statusLineManager().removeListener(listener);
        }
    }

    public static int textToFullTextPosition(LpexView lpexView, int element, int position) {
        if (lpexView == null || lpexView._view == null) {
            return position;
        }
        ElementList elementList = lpexView._view.document().elementList();
        return elementList.textToFullTextPosition(elementList.elementAt(element), position);
    }

    public static int fullTextToTextPosition(LpexView lpexView, int element, int position) {
        if (lpexView == null || lpexView._view == null) {
            return position;
        }
        ElementList elementList = lpexView._view.document().elementList();
        return elementList.fullTextToTextPosition(elementList.elementAt(element), position);
    }

    public static int getBaseline(LpexView lpexView) {
        if (lpexView == null || lpexView._view == null) {
            return 0;
        }
        return lpexView._view.screen().textFontMetrics().baseline();
    }

    public static void processLpexKey(LpexView lpexView, String lpexKey) {
        if (lpexView._view.vi()) {
            lpexView._view.viHandler().processLpexKey(lpexKey);
        }
    }

    public static String currentPopupMenu(LpexView lpexView) {
        return PopupParameter.getParameter().currentPopupMenu(lpexView != null ? lpexView._view : null);
    }

    public static LpexDocumentLocation getTextLocationAtPoint(LpexView lpexView, int x, int y) {
        return lpexView == null || lpexView._view == null ? null : lpexView._view.getTextLocationAtPoint(x, y);
    }

    public static int notifyTruncateDocument(LpexView lpexView, LpexDocumentListener listener, int textLimit) {
        return lpexView != null && lpexView._view != null ? lpexView._view.notifyTruncateDocument(listener, textLimit) : 0;
    }

    public static void notifyTruncateDocumentRestore(LpexView lpexView, LpexDocumentListener listener, int textLimit, int firstTruncatedElement) {
        if (lpexView != null && lpexView._view != null) {
            lpexView._view.notifyTruncateDocumentRestore(listener, textLimit, firstTruncatedElement);
        }
    }

    public static void commentUncommentCobolLines(LpexView lpexView, int commentOffset, boolean comment) {
        Element lastElement;
        Element firstElement;
        if (lpexView == null || lpexView._view == null) {
            return;
        }
        View view = lpexView._view;
        if (lpexView.queryOn("block.inView") && lpexView.queryOn("block.anythingSelected")) {
            firstElement = view.block().topElement();
            lastElement = view.block().bottomElement().next();
        } else {
            firstElement = view.documentPosition().element();
            if (firstElement == null) {
                return;
            }
            lastElement = firstElement.next();
        }
        lpexView.doCommand("undo check");
        boolean nlText = lpexView.nls().isSourceSosi() || lpexView.nls().isIgnoringBidiMarks();
        String sourceEncoding = nlText ? lpexView.query("current.sourceEncoding") : "";
        int sourceCcsid = nlText ? lpexView.queryInt("current.sourceCcsid") : 0;
        int offset = commentOffset;
        Element e = firstElement;
        while (e != lastElement) {
            if (!e.show() && e.visible(view)) {
                String text = e.text();
                int textLength = text.length();
                if (nlText) {
                    offset = LpexNls.indexFromEncodingIndex(text, commentOffset, sourceEncoding, sourceCcsid);
                    while (offset < textLength && LpexNls.isBidiMark(text.charAt(offset))) {
                        ++offset;
                    }
                }
                if (comment) {
                    char c;
                    char c2 = c = textLength <= offset ? (char)'\u0000' : text.charAt(offset);
                    if (c != '*' && c != '/') {
                        view.fill(e, offset + 1, 1, "*");
                    }
                    if (view.document()._sourceHebrew || view.document()._sourceArabic) {
                        view.window().getBidiCommentElement().display(commentOffset);
                    }
                } else if (textLength > offset && (text.charAt(offset) == '*' || text.charAt(offset) == '/')) {
                    view.fill(e, offset + 1, 1, " ");
                }
            }
            e = e.next();
        }
        lpexView.doCommand("undo check");
    }

    public static void setProfileHandler(ProfileHandler profileHandler) {
        Profile.setProfileHandler(profileHandler);
    }

    public static void profileChanged() {
        Profile.profileChanged();
    }

    public static void unnumber(LpexView lpexView, boolean trim) {
        if (lpexView != null && lpexView._view != null) {
            lpexView._view.document().elementList().unnumber(lpexView._view, trim);
        }
    }
}

