/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.KeyedList;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.ParameterOnOffOnly;
import com.ibm.lpex.core.ParameterQualifiedWordDefault;
import com.ibm.lpex.core.ParameterQualifierList;
import com.ibm.lpex.core.ParameterWordDefault;
import com.ibm.lpex.core.ParameterWordsDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;

final class UpdateProfileCommand {
    static final int BASE_PROFILE = 1;
    static final int EXTENSIONS = 2;
    static final int EXTENSIONS_CLASSPATH = 3;
    static final int NO_PARSER = 4;
    static final int PALETTE = 5;
    static final int PALETTE_ATTRIBUTES = 6;
    static final int PALETTES = 7;
    static final int PARSER = 8;
    static final int PARSER_ASSOCIATION = 9;
    static final int PARSER_CLASS = 10;
    static final int PARSERS = 11;
    static final int STRICT_EXTENSION = 12;
    static final int USER_ACTIONS = 13;
    static final int USER_COMMANDS = 14;
    static final int USER_KEY_ACTIONS = 15;
    static final int USER_MOUSE_ACTIONS = 16;
    static final int USER_PROFILE = 17;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("baseProfile", 1), new TableNode("extensions", 2), new TableNode("extensionsClasspath", 3), new TableNode("noParser", 4), new TableNode("palette", 5), new TableNode("paletteAttributes.", 6), new TableNode("palettes", 7), new TableNode("parser", 8), new TableNode("parserAssociation.", 9), new TableNode("parserClass.", 10), new TableNode("parsers", 11), new TableNode("strictExtension", 12), new TableNode("userActions", 13), new TableNode("userCommands", 14), new TableNode("userKeyActions", 15), new TableNode("userMouseActions", 16), new TableNode("userProfile", 17)};

    static {
        TableNode.sort(_parameters);
    }

    UpdateProfileCommand() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return BaseProfileParameter.getParameter();
                }
                case 2: {
                    return ExtensionsParameter.getParameter();
                }
                case 3: {
                    return ExtensionsClasspathParameter.getParameter();
                }
                case 4: {
                    return NoParserParameter.getParameter();
                }
                case 5: {
                    return PaletteParameter.getParameter();
                }
                case 7: {
                    return PalettesParameter.getParameter();
                }
                case 6: {
                    return PaletteAttributesParameter.getParameter();
                }
                case 8: {
                    return ParserParameter.getParameter();
                }
                case 9: {
                    return ParserAssociationParameter.getParameter();
                }
                case 10: {
                    return ParserClassParameter.getParameter();
                }
                case 11: {
                    return ParsersParameter.getParameter();
                }
                case 12: {
                    return StrictExtensionParameter.getParameter();
                }
                case 13: {
                    return UserActionsParameter.getParameter();
                }
                case 14: {
                    return UserCommandsParameter.getParameter();
                }
                case 15: {
                    return UserKeyActionsParameter.getParameter();
                }
                case 16: {
                    return UserMouseActionsParameter.getParameter();
                }
                case 17: {
                    return UserProfileParameter.getParameter();
                }
            }
        }
        return null;
    }

    static boolean doCommand(View view, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        boolean all = false;
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("all")) {
                return CommandHandler.invalidParameter(view, token, "updateProfile");
            }
            all = true;
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "updateProfile");
            }
        }
        if (all) {
            Document doc = Document._firstDocument;
            while (doc != null) {
                view = doc._firstView;
                while (view != null) {
                    if (view.updateProfileIssued()) {
                        view.updateProfile();
                    }
                    view = view._next;
                }
                doc = doc._next;
            }
        } else if (view != null) {
            view.updateProfile();
        }
        return true;
    }

    static final class BaseProfileParameter
    extends ParameterWordDefault {
        private static BaseProfileParameter _parameter;

        static BaseProfileParameter getParameter() {
            if (_parameter == null) {
                _parameter = new BaseProfileParameter();
            }
            return _parameter;
        }

        private BaseProfileParameter() {
            super("updateProfile.baseProfile", "lpex");
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._baseProfile = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._baseProfile : null;
        }
    }

    static final class ExtensionsClasspathParameter
    extends ParameterWordDefault {
        private static ExtensionsClasspathParameter _parameter;

        static ExtensionsClasspathParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ExtensionsClasspathParameter();
            }
            return _parameter;
        }

        private ExtensionsClasspathParameter() {
            super("updateProfile.extensionsClasspath", null);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.document().setExtensionsClasspath("null".equalsIgnoreCase(value) ? null : value);
            }
            return true;
        }

        @Override
        boolean setDefaultValue(String value) {
            return super.setDefaultValue("null".equalsIgnoreCase(value) ? null : value);
        }

        @Override
        void currentValueChanged(View view) {
            ClassLoaderList.extensionsClasspathChanged();
        }

        @Override
        String value(View view) {
            return view != null ? view.document().extensionsClasspath() : null;
        }
    }

    static final class ExtensionsParameter
    extends ParameterQualifierList {
        private static ExtensionsParameter _parameter;

        static ExtensionsParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ExtensionsParameter();
            }
            return _parameter;
        }

        private ExtensionsParameter() {
            super("updateProfile.extensions", "updateProfile.parserAssociation.", false);
        }

        @Override
        KeyedList value(View view) {
            return view != null ? view.updateProfileCommandSettings()._parserAssociations : null;
        }
    }

    static final class NoParserParameter
    extends ParameterOnOffDefault {
        private static NoParserParameter _parameter;

        static NoParserParameter getParameter() {
            if (_parameter == null) {
                _parameter = new NoParserParameter();
            }
            return _parameter;
        }

        private NoParserParameter() {
            super("updateProfile.noParser", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.updateProfileCommandSettings()._noParser = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.updateProfileCommandSettings()._noParser : 2;
        }
    }

    static final class PaletteAttributesParameter
    extends ParameterDefault {
        private static PaletteAttributesParameter _parameter;

        static PaletteAttributesParameter getParameter() {
            if (_parameter == null) {
                _parameter = new PaletteAttributesParameter();
            }
            return _parameter;
        }

        private PaletteAttributesParameter() {
            super("updateProfile.paletteAttributes.");
        }

        private String hardcodedValue(String style) {
            switch (Screen.styleId(style)) {
                case 0: {
                    return "0 0 0 255 255 80";
                }
                case 1: {
                    return "0 0 0 204 204 204";
                }
                case 2: {
                    return "-1 -1 -1 232 242 254";
                }
                case 3: {
                    return "255 255 255 0 0 0";
                }
                case 4: {
                    return "0 0 170 255 255 255";
                }
                case 5: {
                    return "0 0 0 255 0 0";
                }
                case 6: {
                    return "0 0 0 204 204 204";
                }
                case 7: {
                    return "0 0 0 204 204 204 outline";
                }
                case 8: {
                    return "0 0 0 255 255 255 204 204 204";
                }
                case 9: {
                    return "0 0 0 255 255 255";
                }
                case 10: {
                    return "0 0 0 255 255 255";
                }
                case 11: {
                    return "255 0 255 255 255 255";
                }
                case 12: {
                    return "0 0 0 204 204 204";
                }
                case 13: {
                    return "255 0 255 204 204 204";
                }
                case 14: {
                    return LpexUtilities.getHardcodedValueStyleSelection();
                }
                case 15: {
                    return "0 0 0 204 204 204";
                }
                case 16: {
                    return "0 0 255 204 204 204";
                }
                case 17: {
                    return "0 0 0 255 255 255";
                }
                case 18: {
                    return "220 220 220 255 255 255";
                }
                case 19: {
                    return "0 255 0 255 255 255";
                }
            }
            return null;
        }

        private boolean hardcodedValueBackgroundOnly(String style) {
            String styleAttributesString = this.hardcodedValue(style);
            return StyleAttributes.checkStyleAttributes(null, styleAttributesString, null) == 2;
        }

        private StyleAttributes hardcodedValue(String style, String palette) {
            String defaultStyleName = Screen.styleName(4);
            if (style.equalsIgnoreCase(defaultStyleName)) {
                return StyleAttributes.getStyleAttributes("0 0 170 255 255 255");
            }
            StyleAttributes styleAttributes = this.currentValue(null, defaultStyleName, palette);
            String backgroundColorString = styleAttributes.backgroundColorString();
            String styleAttributesString = this.hardcodedValue(style);
            styleAttributesString = StyleAttributes.convert(styleAttributesString, "255 255 255", backgroundColorString);
            return StyleAttributes.getStyleAttributes(styleAttributesString);
        }

        private StyleAttributes installValue(String style, String palette) {
            String value = Install.getString("install." + this.name(style + "." + palette));
            if (value != null) {
                return StyleAttributes.getStyleAttributes(value);
            }
            return this.hardcodedValue(style, palette);
        }

        private boolean installValueBackgroundOnly(String style, String palette) {
            String value = Install.getString("install." + this.name(style + "." + palette));
            if (value != null) {
                return StyleAttributes.checkStyleAttributes(null, value, null) == 2;
            }
            return this.hardcodedValueBackgroundOnly(style);
        }

        Setting defaultValue(String style, String palette) {
            String value = Profile.getString("default." + this.name(style + "." + palette));
            if (value == null) {
                return null;
            }
            boolean backgroundOnly = StyleAttributes.checkStyleAttributes(null, value, null) == 2;
            return new Setting(StyleAttributes.getStyleAttributes(value), backgroundOnly);
        }

        private boolean setDefaultValue(String style, String palette, Setting setting) {
            String key = "default." + this.name(style + "." + palette);
            if (setting == null) {
                Profile.remove(key);
            } else if (setting._styleAttributes == null) {
                Profile.putString(key, "null");
            } else {
                Profile.putString(key, setting._styleAttributes.queryString(setting._backgroundOnly));
            }
            return true;
        }

        private Setting currentSetting(View view, String style, String palette) {
            Setting setting;
            Setting setting2 = setting = view != null ? this.value(view, style, palette) : null;
            if (setting == null && (setting = this.defaultValue(style, palette)) == null) {
                setting = new Setting(this.installValue(style, palette), this.installValueBackgroundOnly(style, palette));
            }
            return setting;
        }

        StyleAttributes currentValue(View view, String style, String palette) {
            return this.currentSetting((View)view, (String)style, (String)palette)._styleAttributes;
        }

        boolean currentValueBackgroundOnly(View view, String style, String palette) {
            return this.currentSetting((View)view, (String)style, (String)palette)._backgroundOnly;
        }

        @Override
        boolean set(View view, String qualifier, String parameters) {
            int styleId;
            String style = Parameters.getParameterString(qualifier = Parameters.getQualifierString(qualifier));
            int qualifierIndex = style.indexOf(46);
            if (qualifierIndex != -1) {
                style = qualifier.substring(0, qualifierIndex);
            }
            if ((styleId = Screen.styleId(style)) == -1) {
                return CommandHandler.invalidParameter(view, style, "set " + this.name());
            }
            String palette = Parameters.getQualifierString(qualifier);
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            Setting setting = null;
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("default")) {
                    int rc = StyleAttributes.checkStyleAttributes(view, parameters, "set " + this.name(qualifier));
                    if (rc == 0) {
                        return false;
                    }
                    setting = new Setting(StyleAttributes.getStyleAttributes(parameters), rc == 2);
                } else if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name(qualifier));
                }
            }
            return this.setValue(view, style, palette, setting);
        }

        @Override
        boolean setDefault(View view, String qualifier, String parameters) {
            int styleId;
            String style = Parameters.getParameterString(qualifier = Parameters.getQualifierString(qualifier));
            int qualifierIndex = style.indexOf(46);
            if (qualifierIndex != -1) {
                style = qualifier.substring(0, qualifierIndex);
            }
            if ((styleId = Screen.styleId(style)) == -1) {
                return CommandHandler.invalidParameter(view, style, "set default." + this.name());
            }
            String palette = Parameters.getQualifierString(qualifier);
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            Setting setting = null;
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("install")) {
                    int rc = StyleAttributes.checkStyleAttributes(view, parameters, "set default." + this.name(qualifier));
                    if (rc == 0) {
                        return false;
                    }
                    setting = new Setting(StyleAttributes.getStyleAttributes(parameters), rc == 2);
                } else if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name(qualifier));
                }
            }
            return this.setDefaultValue(style, palette, setting);
        }

        @Override
        String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
            int styleId;
            String style = Parameters.getParameterString(qualifier = Parameters.getQualifierString(qualifier));
            int qualifierIndex = style.indexOf(46);
            if (qualifierIndex != -1) {
                style = qualifier.substring(0, qualifierIndex);
            }
            if ((styleId = Screen.styleId(style)) != -1) {
                String palette = Parameters.getQualifierString(qualifier);
                Setting setting = this.value(view, style, palette);
                if (setting == null) {
                    return "default";
                }
                if (setting._styleAttributes != null) {
                    return setting._styleAttributes.queryString(setting._backgroundOnly);
                }
            }
            return null;
        }

        @Override
        String queryInstall(String qualifier) {
            String palette;
            StyleAttributes styleAttributes;
            int styleId;
            String style = Parameters.getParameterString(qualifier = Parameters.getQualifierString(qualifier));
            int qualifierIndex = style.indexOf(46);
            if (qualifierIndex != -1) {
                style = qualifier.substring(0, qualifierIndex);
            }
            if ((styleId = Screen.styleId(style)) != -1 && (styleAttributes = this.installValue(style, palette = Parameters.getQualifierString(qualifier))) != null) {
                return styleAttributes.queryString(this.installValueBackgroundOnly(style, palette));
            }
            return null;
        }

        @Override
        String queryDefault(String qualifier) {
            int styleId;
            String style = Parameters.getParameterString(qualifier = Parameters.getQualifierString(qualifier));
            int qualifierIndex = style.indexOf(46);
            if (qualifierIndex != -1) {
                style = qualifier.substring(0, qualifierIndex);
            }
            if ((styleId = Screen.styleId(style)) != -1) {
                String palette = Parameters.getQualifierString(qualifier);
                Setting setting = this.defaultValue(style, palette);
                if (setting == null) {
                    return "install";
                }
                if (setting._styleAttributes != null) {
                    return setting._styleAttributes.queryString(setting._backgroundOnly);
                }
            }
            return null;
        }

        @Override
        String queryCurrent(View view, String qualifier) {
            String palette;
            StyleAttributes styleAttributes;
            int styleId;
            String style = Parameters.getParameterString(qualifier = Parameters.getQualifierString(qualifier));
            int qualifierIndex = style.indexOf(46);
            if (qualifierIndex != -1) {
                style = qualifier.substring(0, qualifierIndex);
            }
            if ((styleId = Screen.styleId(style)) != -1 && (styleAttributes = this.currentValue(view, style, palette = Parameters.getQualifierString(qualifier))) != null) {
                return styleAttributes.queryString(this.currentValueBackgroundOnly(view, style, palette));
            }
            return null;
        }

        boolean setValue(View view, String style, String palette, Setting setting) {
            if (view != null) {
                int styleId = Screen.styleId(style);
                if (styleId == -1) {
                    return false;
                }
                KeyedList[] paletteAttributes = view.updateProfileCommandSettings()._paletteAttributes;
                if (paletteAttributes[styleId] == null) {
                    paletteAttributes[styleId] = new KeyedList();
                }
                KeyedList palettes = paletteAttributes[styleId];
                palettes.set(palette, setting);
            }
            return true;
        }

        Setting value(View view, String style, String palette) {
            KeyedList palettes;
            int styleId;
            KeyedList[] paletteAttributes;
            if (view != null && (paletteAttributes = view.updateProfileCommandSettings()._paletteAttributes) != null && (styleId = Screen.styleId(style)) != -1 && (palettes = paletteAttributes[styleId]) != null) {
                return (Setting)palettes.query(palette, true);
            }
            return null;
        }

        static final class Setting {
            StyleAttributes _styleAttributes;
            boolean _backgroundOnly;

            Setting(StyleAttributes styleAttributes, boolean backgroundOnly) {
                this._styleAttributes = styleAttributes;
                this._backgroundOnly = backgroundOnly;
            }
        }
    }

    static final class PaletteParameter
    extends ParameterWordDefault {
        private static PaletteParameter _parameter;

        static PaletteParameter getParameter() {
            if (_parameter == null) {
                _parameter = new PaletteParameter();
            }
            return _parameter;
        }

        private PaletteParameter() {
            super("updateProfile.palette", "white");
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._palette = "null".equalsIgnoreCase(value) ? null : value;
            }
            return true;
        }

        @Override
        boolean setDefaultValue(String value) {
            return super.setDefaultValue("null".equalsIgnoreCase(value) ? null : value);
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._palette : null;
        }
    }

    static final class PalettesParameter
    extends ParameterQualifierList {
        private static PalettesParameter _parameter;

        static PalettesParameter getParameter() {
            if (_parameter == null) {
                _parameter = new PalettesParameter();
            }
            return _parameter;
        }

        private PalettesParameter() {
            super("updateProfile.palettes", "updateProfile.paletteAttributes." + Screen.styleName(4) + ".", true);
        }

        @Override
        KeyedList value(View view) {
            return view != null ? view.updateProfileCommandSettings()._paletteAttributes[4] : null;
        }
    }

    static final class ParserAssociationParameter
    extends ParameterQualifiedWordDefault {
        private static ParserAssociationParameter _parameter;
        private boolean ignoreCase = false;
        private static final String PARSER_ASSOCIATION = "parserAssociation";

        static ParserAssociationParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ParserAssociationParameter();
            }
            return _parameter;
        }

        private ParserAssociationParameter() {
            super("updateProfile.");
        }

        @Override
        boolean setValue(View view, String qualifier, String value) {
            qualifier = this.fixQualifierCase(qualifier);
            if (view != null) {
                qualifier = Parameters.getQualifierString(qualifier);
                view.updateProfileCommandSettings()._parserAssociations.set(qualifier, value, this.ignoreCase);
            }
            return true;
        }

        @Override
        String value(View view, String qualifier) {
            qualifier = this.fixQualifierCase(qualifier);
            if (view == null) {
                return null;
            }
            String extension = Parameters.getQualifierString(qualifier);
            return (String)view.updateProfileCommandSettings()._parserAssociations.query(extension, this.ignoreCase);
        }

        @Override
        String currentValue(View view, String qualifier) {
            qualifier = this.fixQualifierCase(qualifier);
            if (StrictExtensionParameter.getParameter().value(view, null, null)) {
                return super.currentValue(view, qualifier);
            }
            String value = null;
            String extension = Parameters.getQualifierString(qualifier);
            ExtensionsParameter p = ExtensionsParameter.getParameter();
            if (view != null) {
                value = (String)p.value(view).query(extension, true);
            }
            if (value == null && (value = (String)p.defaultValue().query(extension, true)) == null) {
                value = (String)p.installValue().query(extension, true);
            }
            return "null".equalsIgnoreCase(value) ? null : value;
        }

        @Override
        String queryDefault(String qualifier) {
            return super.queryDefault(this.fixQualifierCase(qualifier));
        }

        private String fixQualifierCase(String qualifier) {
            if (qualifier.startsWith(PARSER_ASSOCIATION)) {
                return qualifier;
            }
            String ucQualifier = qualifier.toUpperCase();
            if (ucQualifier.startsWith(PARSER_ASSOCIATION.toUpperCase())) {
                return PARSER_ASSOCIATION + qualifier.substring(qualifier.indexOf(46));
            }
            return qualifier;
        }

        @Override
        String name(String qualifier) {
            return (qualifier = this.fixQualifierCase(qualifier)) != null ? this.name() + qualifier : this.name();
        }
    }

    static final class ParserClassParameter
    extends ParameterQualifiedWordDefault {
        private static ParserClassParameter _parameter;

        static ParserClassParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ParserClassParameter();
            }
            return _parameter;
        }

        private ParserClassParameter() {
            super("updateProfile.");
        }

        @Override
        boolean setValue(View view, String qualifier, String value) {
            if (view != null) {
                qualifier = Parameters.getQualifierString(qualifier);
                view.updateProfileCommandSettings()._parserClasses.set(qualifier, value);
            }
            return true;
        }

        @Override
        String value(View view, String qualifier) {
            qualifier = Parameters.getQualifierString(qualifier);
            return view != null ? (String)view.updateProfileCommandSettings()._parserClasses.query(qualifier, true) : null;
        }
    }

    static final class ParserParameter
    extends ParameterWordDefault {
        private static ParserParameter _parameter;

        static ParserParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ParserParameter();
            }
            return _parameter;
        }

        private ParserParameter() {
            super("updateProfile.parser", "associated");
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._parser = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._parser : null;
        }
    }

    static final class ParsersParameter
    extends ParameterQualifierList {
        private static ParsersParameter _parameter;

        static ParsersParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ParsersParameter();
            }
            return _parameter;
        }

        private ParsersParameter() {
            super("updateProfile.parsers", "updateProfile.parserClass.", true);
        }

        @Override
        KeyedList value(View view) {
            return view != null ? view.updateProfileCommandSettings()._parserClasses : null;
        }
    }

    static final class Settings {
        String _baseProfile;
        boolean _strictExtension = true;
        int _noParser = 2;
        String _palette;
        KeyedList[] _paletteAttributes = new KeyedList[20];
        String _parser;
        KeyedList _parserAssociations = new KeyedList();
        KeyedList _parserClasses = new KeyedList();
        String _userActions;
        String _userCommands;
        String _userKeyActions;
        String _userMouseActions;
        String _userProfile;

        Settings() {
        }
    }

    static final class StrictExtensionParameter
    extends ParameterOnOffOnly {
        private static StrictExtensionParameter _parameter;

        static StrictExtensionParameter getParameter() {
            if (_parameter == null) {
                _parameter = new StrictExtensionParameter();
            }
            return _parameter;
        }

        private StrictExtensionParameter() {
            super("updateProfile.strictExtension");
        }

        @Override
        boolean setValue(View view, String qualifier, boolean value) {
            if (view != null) {
                view.updateProfileCommandSettings()._strictExtension = value;
            }
            return true;
        }

        @Override
        boolean value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            return view != null ? view.updateProfileCommandSettings()._strictExtension : true;
        }
    }

    static final class UserActionsParameter
    extends ParameterWordsDefault {
        private static UserActionsParameter _parameter;

        static UserActionsParameter getParameter() {
            if (_parameter == null) {
                _parameter = new UserActionsParameter();
            }
            return _parameter;
        }

        private UserActionsParameter() {
            super("updateProfile.userActions", null);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._userActions = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._userActions : null;
        }
    }

    static final class UserCommandsParameter
    extends ParameterWordsDefault {
        private static UserCommandsParameter _parameter;

        static UserCommandsParameter getParameter() {
            if (_parameter == null) {
                _parameter = new UserCommandsParameter();
            }
            return _parameter;
        }

        private UserCommandsParameter() {
            super("updateProfile.userCommands", null);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._userCommands = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._userCommands : null;
        }
    }

    static final class UserKeyActionsParameter
    extends ParameterWordsDefault {
        private static UserKeyActionsParameter _parameter;

        static UserKeyActionsParameter getParameter() {
            if (_parameter == null) {
                _parameter = new UserKeyActionsParameter();
            }
            return _parameter;
        }

        private UserKeyActionsParameter() {
            super("updateProfile.userKeyActions", null);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._userKeyActions = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._userKeyActions : null;
        }
    }

    static final class UserMouseActionsParameter
    extends ParameterWordsDefault {
        private static UserMouseActionsParameter _parameter;

        static UserMouseActionsParameter getParameter() {
            if (_parameter == null) {
                _parameter = new UserMouseActionsParameter();
            }
            return _parameter;
        }

        private UserMouseActionsParameter() {
            super("updateProfile.userMouseActions", null);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._userMouseActions = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._userMouseActions : null;
        }
    }

    static final class UserProfileParameter
    extends ParameterWordDefault {
        private static UserProfileParameter _parameter;

        static UserProfileParameter getParameter() {
            if (_parameter == null) {
                _parameter = new UserProfileParameter();
            }
            return _parameter;
        }

        private UserProfileParameter() {
            super("updateProfile.userProfile", null);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.updateProfileCommandSettings()._userProfile = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.updateProfileCommandSettings()._userProfile : null;
        }
    }
}

