/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.View;

final class UndoCommand {
    UndoCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        int undoCount = 1;
        boolean quiet = false;
        boolean discard = false;
        CommandHandler.setStatus(null);
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("clear")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "undo clear");
                }
                if (view != null) {
                    view.document().undo().clear();
                }
                return true;
            }
            if (token.equalsIgnoreCase("check")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "undo check");
                }
                if (view != null) {
                    view.document().undo().check(view);
                }
                return true;
            }
            if (token.equalsIgnoreCase("checkPoint")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "undo checkPoint");
                }
                if (view != null) {
                    view.document().undo().checkPoint(view);
                }
                return true;
            }
            if (token.equalsIgnoreCase("resetChanges")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "undo resetChanges");
                }
                if (view != null) {
                    view.document().undo().resetChanges(view);
                }
                return true;
            }
            if (token.equalsIgnoreCase("save")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "undo save");
                }
                if (view != null) {
                    view.document().undo().save(view);
                }
                return true;
            }
            try {
                undoCount = Integer.parseInt(token);
                token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            catch (NumberFormatException numberFormatException) {}
            while (token != null) {
                if (undoCount >= 0 && token.equalsIgnoreCase("discard")) {
                    discard = true;
                } else if (token.equalsIgnoreCase("quiet")) {
                    quiet = true;
                } else {
                    return CommandHandler.invalidParameter(view, token, "undo");
                }
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
        }
        if (view != null) {
            if (undoCount >= 0) {
                view.document().undo().undo(view, undoCount, quiet, discard);
            } else {
                view.document().undo().redo(view, -undoCount, quiet);
            }
        }
        return true;
    }
}

