/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.View;

final class Undo {
    private Document _document;
    private List _undoableChanges;
    private UndoableChange _currentChange;
    private UndoableChange _currentUndo;
    private boolean _recording = true;
    private boolean _undoing;
    private int _changes;
    private boolean _lastChangeWasYank;
    private boolean _forceDirty;

    Undo(Document document) {
        this._document = document;
        this.clear();
    }

    void clear() {
        this._undoableChanges = new List();
        Element element = this._document.elementList().first();
        while (element != null) {
            element.clearRecordedInfo();
            element = element.next();
        }
        this._currentChange = null;
        this._currentUndo = null;
        this._undoing = false;
        this._changes = 0;
        this._lastChangeWasYank = false;
        this._forceDirty = false;
    }

    private void prepareForRecord(View view) {
        int userActionId;
        if (this._currentUndo != null) {
            new UndoableChange(view, this._currentUndo);
            this._currentUndo = null;
        }
        if (this._currentChange == null) {
            this._currentChange = new UndoableChange(view, null);
        }
        this._lastChangeWasYank = (userActionId = view.actionHandler().userActionId()) == 214 || userActionId == 215;
    }

    private void verifyViChange(Document document) {
        View view = document._firstView;
        while (view != null) {
            if (view.vi()) {
                view.viHandler().verifyChange();
            }
            view = view._next;
        }
    }

    private void verifyViChangeCheck(Document document) {
        View view = document._firstView;
        while (view != null) {
            if (view.vi()) {
                view.viHandler().verifyChangeCheck();
            }
            view = view._next;
        }
    }

    void recordInsert(View view, Element element) {
        if (!element.show()) {
            this.verifyViChange(view.document());
        }
        if (this.recording() && !this._undoing && !element.show()) {
            this._document.resetUserActionElements();
            this.prepareForRecord(view);
            this._currentChange.recordInsert(element);
        }
    }

    void recordChange(View view, Element element, int position) {
        if (!element.show()) {
            this.verifyViChange(view.document());
        }
        if (this.recording() && !this._undoing && !element.show()) {
            this._document.verifyUserActionElements(element);
            this.prepareForRecord(view);
            this._currentChange.recordChange(element);
            this.recordPosition(element, position);
        }
    }

    void recordDelete(View view, Element element) {
        if (!element.show()) {
            this.verifyViChange(view.document());
        }
        if (this.recording() && !this._undoing && !element.show()) {
            this._document.resetUserActionElements();
            this.prepareForRecord(view);
            if (this._currentChange != null) {
                this._currentChange.recordDelete(element);
            }
        } else {
            UndoableChange undoableChange = (UndoableChange)this._undoableChanges.first();
            while (undoableChange != null) {
                undoableChange.unrecordedDelete(view, element);
                undoableChange = (UndoableChange)undoableChange.next();
            }
        }
    }

    void recordPosition(View view) {
        this.recordPosition(view.documentPosition().element(), view.documentPosition().position());
    }

    void recordPosition(Element element, int position) {
        if (this.recording() && !this._undoing && this._currentChange != null) {
            this._currentChange.recordPosition(element, position);
        }
    }

    String getCurrentDeletedChanges() {
        if (this._currentChange != null) {
            return this._currentChange.getRecordedDeletes();
        }
        return null;
    }

    void check(View view) {
        this.verifyViChangeCheck(view.document());
        if (this._currentChange != null && this._currentUndo == null) {
            this._currentChange.check(view);
            if (this._changes < 0) {
                this._changes = -this._changes;
            }
            ++this._changes;
            this._currentChange = null;
        }
        this._document.resetUserActionElements();
    }

    void save(View view) {
        if (this._currentUndo != null && this._currentUndo.prev() != null) {
            UndoableChange tempChange;
            UndoableChange preChange = (UndoableChange)this._currentUndo.prev();
            do {
                tempChange = (UndoableChange)preChange.prev();
                this._undoableChanges.remove(preChange);
            } while ((preChange = tempChange) != null && preChange._undone);
        }
    }

    void checkPoint(View view) {
        if (this._currentChange != null && this._currentUndo == null) {
            this._currentChange.check(view);
            if (this._changes < 0) {
                this._changes = -this._changes;
            }
            ++this._changes;
            this._currentChange = null;
        }
    }

    void resetChanges(View view) {
        this.check(view);
        this._changes = 0;
        this._forceDirty = false;
    }

    void undo(View view) {
        this.undo(view, 1, false, false);
    }

    void undo(View view, int count) {
        this.undo(view, count, false, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void undo(View view, int count, boolean quiet, boolean discard) {
        void var7_8;
        UndoableChange newCurrentUndo;
        this._lastChangeWasYank = false;
        this.check(view);
        if (count <= 0) return;
        if (this._currentUndo != null) {
            if (this._currentUndo.next() == null || ((UndoableChange)this._currentUndo.next())._undone) {
                CommandHandler.setStatus("undo.nothingUndone");
                if (quiet) return;
                view.setLpexMessageText("undo.noMoreChanges");
                return;
            }
            newCurrentUndo = (UndoableChange)this._currentUndo.next();
        } else {
            if (this._undoableChanges.first() == null) {
                CommandHandler.setStatus("undo.nothingUndone");
                if (quiet) return;
                view.setLpexMessageText("undo.noRecordedChanges");
                return;
            }
            newCurrentUndo = (UndoableChange)this._undoableChanges.first();
        }
        while (count > 0 && newCurrentUndo != null) {
            this._undoing = true;
            newCurrentUndo.undo(view);
            this._undoing = false;
            --count;
            this._currentUndo = newCurrentUndo;
            newCurrentUndo = (UndoableChange)newCurrentUndo.next();
            if (!discard) continue;
            this._undoableChanges.remove(this._currentUndo);
            this._currentUndo = null;
        }
        if (quiet) return;
        int i = 0;
        UndoableChange undoableChange = this._currentUndo;
        while (var7_8 != null) {
            ++i;
            List.Node node = var7_8.prev();
        }
        if (newCurrentUndo == null) {
            view.setLpexMessageText("undo.documentAtOriginalState");
            return;
        }
        if (i == 1) {
            view.setLpexMessageText("undo.1ChangeUndone");
            return;
        }
        view.setLpexMessageText("undo.nChangesUndone", i);
    }

    void redo(View view) {
        this.redo(view, 1, false);
    }

    void redo(View view, int count) {
        this.redo(view, count, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void redo(View view, int count, boolean quiet) {
        block8: {
            this._lastChangeWasYank = false;
            this.check(view);
            if (count <= 0) break block8;
            if (this._currentUndo != null) ** GOTO lbl14
            CommandHandler.setStatus("undo.nothingUndone");
            if (!quiet) {
                view.setLpexMessageText("redo.noRedoableChanges");
            }
            return;
lbl-1000:
            // 1 sources

            {
                this._undoing = true;
                this._currentUndo.redo(view);
                this._undoing = false;
                --count;
                this._currentUndo = (UndoableChange)this._currentUndo.prev();
lbl14:
                // 2 sources

                ** while (count > 0 && this._currentUndo != null)
            }
lbl15:
            // 1 sources

            if (!quiet) {
                i = 0;
                curr /* !! */  = this._currentUndo;
                while (curr /* !! */  != null) {
                    ++i;
                    curr /* !! */  = curr /* !! */ .prev();
                }
                if (i == 0) {
                    view.setLpexMessageText("redo.allChangesRedone");
                } else if (i == 1) {
                    view.setLpexMessageText("redo.1ChangeUndone");
                } else {
                    view.setLpexMessageText("redo.nChangesUndone", i);
                }
            }
        }
    }

    boolean redoAvailable() {
        return this._currentUndo != null;
    }

    boolean undoAvailable() {
        if (!this.recording()) {
            return false;
        }
        if (this._currentUndo != null) {
            return this._currentUndo.next() != null;
        }
        return this._undoableChanges.first() != null;
    }

    boolean setRecording(boolean recording) {
        boolean oldRecording = this._recording;
        this._recording = recording;
        return oldRecording;
    }

    boolean recording() {
        return this._recording;
    }

    void forceDirty(boolean forceDirty) {
        this._forceDirty = forceDirty;
    }

    boolean dirty() {
        return this._forceDirty || this._currentChange != null && this._currentUndo == null;
    }

    int changes() {
        return Math.abs(this._changes);
    }

    boolean jumpAvailable() {
        return this._currentUndo != null || this._undoableChanges.first() != null;
    }

    void jump(View view) {
        if (this._currentUndo != null) {
            this._currentUndo.jump(view);
            return;
        }
        if (this._undoableChanges.first() != null) {
            ((UndoableChange)this._undoableChanges.first()).jump(view);
        }
    }

    void setDefaults(View view) {
        UndoableChange undoableChange = (UndoableChange)this._undoableChanges.first();
        while (undoableChange != null) {
            undoableChange.setDefaults(view);
            undoableChange = (UndoableChange)undoableChange.next();
        }
    }

    void disposeView(View view) {
        UndoableChange undoableChange = (UndoableChange)this._undoableChanges.first();
        while (undoableChange != null) {
            undoableChange.disposeView(view);
            undoableChange = (UndoableChange)undoableChange.next();
        }
    }

    void expandAll(View view, boolean expanded) {
        UndoableChange undoableChange = (UndoableChange)this._undoableChanges.first();
        while (undoableChange != null) {
            undoableChange.expandAll(view, expanded);
            undoableChange = (UndoableChange)undoableChange.next();
        }
    }

    boolean lastChangeWasYank() {
        return this._lastChangeWasYank;
    }

    private final class UndoableChange
    extends ListNode {
        List _recordedInserts;
        List _recordedDeletes;
        List _recordedChanges;
        boolean _undone;
        int _startPosition;
        Element _startElement;
        int _endPosition;
        Element _endElement;
        UndoableChange _undoableChange;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("<");
            if (this._undone) {
                buf.append(" u ");
            }
            if (this._recordedInserts != null) {
                buf.append(this._recordedInserts);
            }
            if (this._recordedChanges != null) {
                buf.append(this._recordedChanges);
            }
            if (this._recordedDeletes != null) {
                buf.append(this._recordedDeletes);
            }
            if (this._undoableChange != null) {
                buf.append('~');
                buf.append(this._undoableChange);
            }
            buf.append(">");
            return buf.toString();
        }

        UndoableChange(View view, UndoableChange undoableChange) {
            this._startPosition = view.documentPosition().position();
            this._startElement = view.documentPosition().element();
            this._undoableChange = undoableChange;
            Undo.this._undoableChanges.addAfter(null, this);
        }

        void undo(View view) {
            if (this._undone) {
                return;
            }
            if (this._recordedDeletes != null) {
                RecordedDelete recordedDelete = (RecordedDelete)this._recordedDeletes.first();
                while (recordedDelete != null) {
                    recordedDelete.undelete(view);
                    recordedDelete = (RecordedDelete)recordedDelete.next();
                }
            }
            if (this._recordedChanges != null) {
                RecordedChange recordedChange = (RecordedChange)this._recordedChanges.first();
                while (recordedChange != null) {
                    recordedChange.restore(view);
                    recordedChange = (RecordedChange)recordedChange.next();
                }
            }
            if (this._recordedInserts != null) {
                RecordedInsert recordedInsert = (RecordedInsert)this._recordedInserts.first();
                while (recordedInsert != null) {
                    recordedInsert.uninsert(view);
                    recordedInsert = (RecordedInsert)recordedInsert.next();
                }
            }
            if (this._undoableChange != null) {
                UndoableChange current = this._undoableChange;
                while (current != null && current != this) {
                    current.redo(view);
                    current = (UndoableChange)current.prev();
                }
            }
            this._undone = true;
            if (this._undoableChange == null) {
                --Undo.this._changes;
            }
            this.jump(view);
        }

        void redo(View view) {
            if (!this._undone) {
                return;
            }
            if (this._undoableChange != null) {
                UndoableChange current = (UndoableChange)this.next();
                while (current != null) {
                    current.undo(view);
                    if (current == this._undoableChange) break;
                    current = (UndoableChange)current.next();
                }
            }
            if (this._recordedInserts != null) {
                RecordedInsert recordedInsert = (RecordedInsert)this._recordedInserts.last();
                while (recordedInsert != null) {
                    recordedInsert.reinsert(view);
                    recordedInsert = (RecordedInsert)recordedInsert.prev();
                }
            }
            if (this._recordedChanges != null) {
                RecordedChange recordedChange = (RecordedChange)this._recordedChanges.last();
                while (recordedChange != null) {
                    recordedChange.restore(view);
                    recordedChange = (RecordedChange)recordedChange.prev();
                }
            }
            if (this._recordedDeletes != null) {
                RecordedDelete recordedDelete = (RecordedDelete)this._recordedDeletes.last();
                while (recordedDelete != null) {
                    recordedDelete.redelete(view);
                    recordedDelete = (RecordedDelete)recordedDelete.prev();
                }
            }
            this._undone = false;
            if (this._undoableChange == null) {
                ++Undo.this._changes;
            }
            this.jump(view);
        }

        void recordInsert(Element element) {
            new RecordedInsert(element);
        }

        void recordDelete(Element element) {
            new RecordedDelete(element);
        }

        void recordChange(Element element) {
            if (!element.recorded()) {
                new RecordedChange(element);
            }
        }

        void recordPosition(Element element, int position) {
            this._endElement = element;
            this._endPosition = position;
        }

        void check(View view) {
            if (this._recordedChanges != null) {
                RecordedChange recordedChange = (RecordedChange)this._recordedChanges.first();
                while (recordedChange != null) {
                    recordedChange.element().setRecorded(false);
                    recordedChange = (RecordedChange)recordedChange.next();
                }
            }
            if (this._recordedInserts != null) {
                RecordedInsert recordedInsert = (RecordedInsert)this._recordedInserts.first();
                while (recordedInsert != null) {
                    recordedInsert.element().setRecorded(false);
                    recordedInsert = (RecordedInsert)recordedInsert.next();
                }
            }
        }

        void unrecordedDelete(View view, Element element) {
            RecordedInsert recordedInsert;
            RecordedDelete recordedDelete;
            if (this._startElement == element) {
                this._startElement = null;
            }
            if (this._endElement == element) {
                this._endElement = null;
            }
            if (element.recordedNext()) {
                if (this._recordedDeletes != null) {
                    recordedDelete = (RecordedDelete)this._recordedDeletes.last();
                    while (recordedDelete != null) {
                        recordedDelete.unrecordedDelete(element);
                        recordedDelete = (RecordedDelete)recordedDelete.prev();
                    }
                }
                if (this._recordedInserts != null) {
                    recordedInsert = (RecordedInsert)this._recordedInserts.first();
                    while (recordedInsert != null) {
                        recordedInsert.unrecordedDelete(element);
                        recordedInsert = (RecordedInsert)recordedInsert.next();
                    }
                }
            }
            if (element.recordedChange() && this._recordedChanges != null) {
                RecordedChange recordedChange = (RecordedChange)this._recordedChanges.first();
                while (recordedChange != null && recordedChange.element() != element) {
                    recordedChange = (RecordedChange)recordedChange.next();
                }
                if (recordedChange != null) {
                    this._recordedChanges.remove(recordedChange);
                }
            }
            if (element.recordedInsert() && this._recordedInserts != null) {
                recordedInsert = (RecordedInsert)this._recordedInserts.first();
                while (recordedInsert != null && recordedInsert.element() != element) {
                    recordedInsert = (RecordedInsert)recordedInsert.next();
                }
                if (recordedInsert != null) {
                    this._recordedInserts.remove(recordedInsert);
                }
                element.setRecordedInsert(false);
            }
            if (element.recordedDelete() && this._recordedDeletes != null) {
                recordedDelete = (RecordedDelete)this._recordedDeletes.first();
                while (recordedDelete != null && recordedDelete.element() != element) {
                    recordedDelete = (RecordedDelete)recordedDelete.next();
                }
                if (recordedDelete != null) {
                    this._recordedDeletes.remove(recordedDelete);
                }
            }
        }

        void setDefaults(View view) {
            if (this._recordedDeletes != null) {
                RecordedDelete deleted = (RecordedDelete)this._recordedDeletes.first();
                while (deleted != null) {
                    if (!deleted.undeleted()) {
                        deleted.element().setDefaults(view);
                    }
                    deleted = (RecordedDelete)deleted.next();
                }
            }
            if (this._recordedInserts != null) {
                RecordedInsert inserted = (RecordedInsert)this._recordedInserts.first();
                while (inserted != null) {
                    if (inserted.uninserted()) {
                        inserted.element().setDefaults(view);
                    }
                    inserted = (RecordedInsert)inserted.next();
                }
            }
        }

        void disposeView(View view) {
            if (this._recordedDeletes != null) {
                RecordedDelete deleted = (RecordedDelete)this._recordedDeletes.first();
                while (deleted != null) {
                    if (!deleted.undeleted()) {
                        deleted.element().disposeView(view);
                    }
                    deleted = (RecordedDelete)deleted.next();
                }
            }
            if (this._recordedInserts != null) {
                RecordedInsert inserted = (RecordedInsert)this._recordedInserts.first();
                while (inserted != null) {
                    if (inserted.uninserted()) {
                        inserted.element().disposeView(view);
                    }
                    inserted = (RecordedInsert)inserted.next();
                }
            }
        }

        String getRecordedDeletes() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this._recordedDeletes != null) {
                RecordedDelete deleted = (RecordedDelete)this._recordedDeletes.last();
                while (deleted != null) {
                    stringBuilder.append(deleted.element().text());
                    stringBuilder.append("\n");
                    deleted = (RecordedDelete)deleted.prev();
                }
            }
            return stringBuilder.toString();
        }

        void expandAll(View view, boolean expanded) {
            if (this._recordedDeletes != null) {
                RecordedDelete deleted = (RecordedDelete)this._recordedDeletes.first();
                while (deleted != null) {
                    if (!deleted.undeleted()) {
                        deleted.element().elementView(view).setExpanded(expanded);
                    }
                    deleted = (RecordedDelete)deleted.next();
                }
            }
            if (this._recordedInserts != null) {
                RecordedInsert inserted = (RecordedInsert)this._recordedInserts.first();
                while (inserted != null) {
                    if (inserted.uninserted()) {
                        inserted.element().elementView(view).setExpanded(expanded);
                    }
                    inserted = (RecordedInsert)inserted.next();
                }
            }
        }

        void jump(View view) {
            if (!this._undone) {
                if (this._undoableChange != null && this._recordedInserts == null && this._recordedDeletes == null && this._recordedChanges == null) {
                    this._undoableChange.jump(view);
                } else if (this._endElement != null) {
                    view.documentPosition().jump(this._endElement, this._endPosition);
                }
            } else if (this._undoableChange != null) {
                ((UndoableChange)this.next()).jump(view);
            } else if (this._startElement != null) {
                view.documentPosition().jump(this._startElement, this._startPosition);
            }
        }

        private final class RecordedChange
        extends RecordedElement {
            private String _savedText;
            private String _savedSequenceText;

            RecordedChange(Element element) {
                super(element);
                if (UndoableChange.this._recordedChanges == null) {
                    UndoableChange.this._recordedChanges = new List();
                }
                UndoableChange.this._recordedChanges.addAfter(null, this);
                this._savedText = element.text();
                this._savedSequenceText = element.sequenceText();
                element.setRecorded(true);
                element.setRecordedChange(true);
            }

            void restore(View view) {
                String text = this.element().text();
                String sequenceText = this.element().sequenceText();
                this.element().setText(view, this._savedText, false, true);
                this.element().setSequenceText(this._savedSequenceText);
                ((UndoableChange)UndoableChange.this).Undo.this._document.elementReplaced(view, this.element());
                this._savedText = text;
                this._savedSequenceText = sequenceText;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append('{');
                buf.append(this.element()._ordinal);
                buf.append('=');
                buf.append(this._savedText);
                buf.append('}');
                return buf.toString();
            }
        }

        private final class RecordedDelete
        extends RecordedElement {
            private boolean _undeleted;
            private Element _prevElement;

            RecordedDelete(Element element) {
                super(element);
                if (UndoableChange.this._recordedDeletes == null) {
                    UndoableChange.this._recordedDeletes = new List();
                }
                UndoableChange.this._recordedDeletes.addAfter(null, this);
                this._undeleted = false;
                element.setRecordedDelete(true);
                this._prevElement = element.prev();
                if (this._prevElement != null) {
                    this._prevElement.setRecordedNext(true);
                }
            }

            void undelete(View view) {
                if (!this._undeleted) {
                    ((UndoableChange)UndoableChange.this).Undo.this._document.elementList().addAfter(view, this._prevElement, this.element(), true);
                    this._prevElement = null;
                    this._undeleted = true;
                }
            }

            void redelete(View view) {
                if (this._undeleted) {
                    this._prevElement = this.element().prev();
                    ((UndoableChange)UndoableChange.this).Undo.this._document.elementList().remove(view, this.element());
                    this._undeleted = false;
                    if (this._prevElement != null) {
                        this._prevElement.setRecordedNext(true);
                    }
                }
            }

            boolean undeleted() {
                return this._undeleted;
            }

            void unrecordedDelete(Element element) {
                if (!this._undeleted && element == this._prevElement) {
                    this._prevElement = element.prev();
                    if (UndoableChange.this._recordedDeletes != null) {
                        RecordedDelete recordedDelete = (RecordedDelete)UndoableChange.this._recordedDeletes.first();
                        while (recordedDelete != this && recordedDelete != null) {
                            if (this._prevElement == recordedDelete._prevElement) {
                                this._prevElement = recordedDelete.element();
                            }
                            recordedDelete = (RecordedDelete)recordedDelete.next();
                        }
                    }
                    if (this._prevElement != null) {
                        this._prevElement.setRecordedNext(true);
                    }
                }
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append('{');
                buf.append('-');
                buf.append(this.element()._ordinal);
                buf.append('}');
                return buf.toString();
            }
        }

        private abstract class RecordedElement
        extends ListNode {
            private Element _element;

            protected RecordedElement(Element element) {
                this._element = element;
            }

            Element element() {
                return this._element;
            }
        }

        private final class RecordedInsert
        extends RecordedElement {
            private boolean _uninserted;
            private Element _prevElement;

            RecordedInsert(Element element) {
                super(element);
                if (UndoableChange.this._recordedInserts == null) {
                    UndoableChange.this._recordedInserts = new List();
                }
                UndoableChange.this._recordedInserts.addAfter(null, this);
                this._uninserted = false;
                this.element().setRecorded(true);
                this.element().setRecordedInsert(true);
            }

            void uninsert(View view) {
                if (!this._uninserted) {
                    this._prevElement = this.element().prev();
                    ((UndoableChange)UndoableChange.this).Undo.this._document.elementList().remove(view, this.element());
                    this._uninserted = true;
                    if (this._prevElement != null) {
                        this._prevElement.setRecordedNext(true);
                    }
                }
            }

            void reinsert(View view) {
                if (this._uninserted) {
                    ((UndoableChange)UndoableChange.this).Undo.this._document.elementList().addAfter(view, this._prevElement, this.element(), true);
                    this._uninserted = false;
                    this._prevElement = null;
                }
            }

            boolean uninserted() {
                return this._uninserted;
            }

            void unrecordedDelete(Element element) {
                if (this._uninserted && element == this._prevElement) {
                    this._prevElement = element.prev();
                    if (UndoableChange.this._recordedInserts != null) {
                        RecordedInsert recordedInsert = (RecordedInsert)UndoableChange.this._recordedInserts.last();
                        while (recordedInsert != this && recordedInsert != null) {
                            if (this._prevElement == recordedInsert._prevElement) {
                                this._prevElement = recordedInsert.element();
                            }
                            recordedInsert = (RecordedInsert)recordedInsert.prev();
                        }
                    }
                    if (this._prevElement != null) {
                        this._prevElement.setRecordedNext(true);
                    }
                }
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append('{');
                buf.append('+');
                buf.append(this.element()._ordinal);
                buf.append('}');
                return buf.toString();
            }
        }
    }
}

