/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexWindow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

final class TitleLine
extends CLabel {
    private static final int NONE = 0;
    private static final int NORMAL = 1;
    private static final int ARMED = 2;
    private static final int PRESSED = 3;
    private LpexWindow _lpexWindow;
    private boolean _closeStyle;
    private boolean _active;
    private int _closeState = 0;
    private boolean _originalToolTipSaved;
    private String _originalToolTip;

    TitleLine(LpexWindow parent, int style) {
        super((Composite)parent, style);
        this._lpexWindow = parent;
        this._closeStyle = (style & 0x40) != 0;
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 8: {
                        TitleLine.this.handleMouse(e);
                        break;
                    }
                    case 3: {
                        TitleLine.this.handleMouse(e);
                        break;
                    }
                    case 7: {
                        TitleLine.this.handleMouse(e);
                        break;
                    }
                    case 5: {
                        TitleLine.this.handleMouse(e);
                        break;
                    }
                    case 4: {
                        TitleLine.this.handleMouse(e);
                        break;
                    }
                    case 9: {
                        TitleLine.this.handlePaint(e);
                        break;
                    }
                }
            }
        };
        int[] events = new int[]{8, 3};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
        if (this._closeStyle) {
            int[] closeEvents = new int[]{7, 5, 4, 9};
            int i2 = 0;
            while (i2 < closeEvents.length) {
                this.addListener(closeEvents[i2], listener);
                ++i2;
            }
        }
    }

    public Rectangle getClientArea() {
        Rectangle client = super.getClientArea();
        if (this._closeStyle) {
            client.width -= client.height;
        }
        return client;
    }

    public void setActive(boolean active) {
        this._active = active;
        this.setForeground(this.getDisplay().getSystemColor(active ? 30 : 33));
        this.setBackground(this.getDisplay().getSystemColor(active ? 31 : 34));
        if (this._closeStyle) {
            this.updateX(active ? 1 : 0, this.xBounds());
        }
    }

    private Rectangle xBounds() {
        Rectangle r = super.getClientArea();
        r.width -= r.height;
        r.x += r.width;
        return r;
    }

    private void updateX(int newCloseState, Rectangle xBounds) {
        if (this._closeState != newCloseState) {
            this._closeState = newCloseState;
            this.redraw(xBounds.x, xBounds.y, xBounds.width, xBounds.height, false);
        }
    }

    private void saveToolTipText() {
        this._originalToolTip = this.getToolTipText();
        this._originalToolTipSaved = true;
    }

    private void restoreToolTipText() {
        if (this._originalToolTipSaved) {
            this.setToolTipText(this._originalToolTip);
        }
        this._originalToolTipSaved = false;
    }

    void handleMouse(Event e) {
        Rectangle r = this.xBounds();
        switch (e.type) {
            case 8: {
                Composite parent;
                if (this._closeStyle && r.contains(e.x, e.y)) break;
                if (this._lpexWindow != null && !this._lpexWindow.isDisposed()) {
                    this._lpexWindow.setFocus();
                }
                if (e.button != 1 || !((parent = this._lpexWindow.getParent()) instanceof LpexMultiWindow)) break;
                ((LpexMultiWindow)parent).toggleMaximize(this._lpexWindow);
                break;
            }
            case 3: {
                if (this._closeStyle && e.button == 1 && r.contains(e.x, e.y)) {
                    this.updateX(3, r);
                    break;
                }
                if (this._lpexWindow == null || this._lpexWindow.isDisposed()) break;
                this._lpexWindow.setFocus();
                break;
            }
            case 7: {
                this.restoreToolTipText();
                this.updateX(this._active ? 1 : 0, r);
                break;
            }
            case 5: {
                if (r.contains(e.x, e.y)) {
                    if (this._closeState != 3 && this._closeState != 2) {
                        this.saveToolTipText();
                        this.setToolTipText(LpexResources.message("closeView"));
                    }
                    if (this._closeState == 3) break;
                    this.updateX(2, r);
                    break;
                }
                if (this._closeState != 1) {
                    this.restoreToolTipText();
                }
                this.updateX(1, r);
                break;
            }
            case 4: {
                Composite parent;
                if (e.button != 1 || !r.contains(e.x, e.y)) break;
                boolean pressed = this._closeState == 3;
                this.updateX(2, r);
                if (!pressed || !((parent = this._lpexWindow.getParent()) instanceof LpexMultiWindow)) break;
                ((LpexMultiWindow)parent).closeWindow(this._lpexWindow);
                break;
            }
        }
    }

    void handlePaint(Event e) {
        Rectangle r = this.xBounds();
        if (r.height < 11 || r.width < 11) {
            return;
        }
        if (this._closeState != 0) {
            int x = r.x + (r.height - 9) / 2;
            int y = r.y + (r.height - 9) / 2;
            if (this._closeState == 3) {
                ++x;
                ++y;
            }
            Color lineColor = this._closeState == 2 || this._closeState == 3 ? new Color((Device)this.getDisplay(), 252, 160, 160) : this.getDisplay().getSystemColor(25);
            e.gc.setForeground(lineColor);
            e.gc.setLineWidth(2);
            e.gc.drawLine(x, y, x + 9, y + 9);
            e.gc.drawLine(x, y + 9, x + 9, y);
            if (this._closeState == 2 || this._closeState == 3) {
                lineColor.dispose();
            }
        }
    }
}

