/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.View;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class TextWindowDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_DELAY = 100;
    static final int SCROLL_VAR = 10;
    TextWindow _textWindow;
    Listener _paintListener;
    int _cursorWidth;
    LpexDocumentLocation _currentLocation;
    long _scrollTime;
    int _scrollX;
    int _scrollY;

    public TextWindowDropTargetEffect(TextWindow textWindow) {
        super((Control)textWindow);
        this._textWindow = textWindow;
        this._paintListener = new Listener(){

            public void handleEvent(Event event) {
                View view = TextWindowDropTargetEffect.this._textWindow.view();
                int[] cursor = view.getPointAtLocation(TextWindowDropTargetEffect.this._currentLocation);
                if (cursor != null) {
                    event.gc.setBackground(event.display.getSystemColor(2));
                    event.gc.fillRectangle(cursor[0], cursor[1], TextWindowDropTargetEffect.this._cursorWidth, TextWindowDropTargetEffect.this.rowHeight(view));
                }
            }
        };
    }

    public void dragEnter(DropTargetEvent event) {
        this._currentLocation = null;
        this._scrollTime = 0L;
        this._cursorWidth = this._textWindow.view().cursorWidth();
        this.getControl().removeListener(9, this._paintListener);
        this.getControl().addListener(9, this._paintListener);
    }

    public void dragLeave(DropTargetEvent event) {
        this.updateDropCursor(this._currentLocation, null);
        this.getControl().removeListener(9, this._paintListener);
        this._scrollTime = 0L;
    }

    public void dragOver(DropTargetEvent event) {
        Element e;
        LpexDocumentLocation newLocation;
        View view = this._textWindow.view();
        Point pt = this._textWindow.getDisplay().map(null, (Control)this._textWindow, event.x, event.y);
        if ((event.feedback & 8) != 0) {
            if (this._scrollTime != 0L && pt.x >= this._scrollX - 10 && pt.x <= this._scrollX + 10 && pt.y >= this._scrollY - 10 && pt.y <= this._scrollY + 10) {
                if (System.currentTimeMillis() >= this._scrollTime) {
                    int lineHeight;
                    Screen screen = view.screen();
                    Rectangle area = this._textWindow.getClientArea();
                    int startMargin = screen.expandHideAreaWidth() + screen.prefixAreaWidth();
                    int charWidth = screen.textFontMetrics().spaceWidth();
                    int scrollAmount = 8 * charWidth;
                    int scrollMargin = 3 * charWidth;
                    if (pt.x < area.x + startMargin + scrollMargin) {
                        int scroll = screen.scroll();
                        if (scroll > 0) {
                            screen.setScroll(scroll - scrollAmount);
                            Document.screenShow(screen);
                        }
                    } else if (pt.x > area.width - scrollMargin) {
                        screen.setScroll(screen.scroll() + scrollAmount);
                        Document.screenShow(screen);
                    }
                    if (pt.y < area.y + (lineHeight = screen.textFontMetrics().textHeight())) {
                        view.documentPosition().scrollScreenUp(1);
                        Document.screenShow(screen);
                    } else {
                        int mostRowsHeight = lineHeight * (screen.rows() - 1);
                        if (pt.y > area.y + mostRowsHeight) {
                            view.documentPosition().scrollScreenDown(1);
                            Document.screenShow(screen);
                        }
                    }
                    this._scrollTime = 0L;
                }
            } else {
                this._scrollTime = System.currentTimeMillis() + 100L;
                this._scrollX = pt.x;
                this._scrollY = pt.y;
            }
        } else {
            this._scrollTime = 0L;
        }
        if (!((event.feedback & 1) == 0 || (newLocation = view.getLocationAtPoint(pt.x, pt.y)) == null || (e = view.document().elementList().elementAt(newLocation.element)).show() || view.markList().protect(e) || newLocation.equals(this._currentLocation))) {
            this.updateDropCursor(this._currentLocation, newLocation);
            this._currentLocation = newLocation;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (this._currentLocation != null) {
            this._textWindow.view().documentPosition().jump(this._currentLocation);
            this._currentLocation = null;
        }
    }

    void updateDropCursor(LpexDocumentLocation oldLocation, LpexDocumentLocation newLocation) {
        if (!(oldLocation == null && newLocation == null || oldLocation != null && oldLocation.equals(newLocation))) {
            View view = this._textWindow.view();
            int rowHeight = this.rowHeight(view);
            int[] cursor = view.getPointAtLocation(oldLocation);
            if (cursor != null) {
                this._textWindow.redraw(cursor[0], cursor[1], this._cursorWidth, rowHeight, false);
            }
            if ((cursor = view.getPointAtLocation(newLocation)) != null) {
                this._textWindow.redraw(cursor[0], cursor[1], this._cursorWidth, rowHeight, false);
            }
        }
    }

    private int rowHeight(View view) {
        return view.screen().textFontMetrics().textHeight();
    }
}

