/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TextWindow;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

final class TextFontMetrics {
    private Screen screen;
    private FontMetrics fontMetrics;
    private int textHeight;
    private int baseline;
    private int spaceWidth;
    private int[] charWidths;

    TextFontMetrics(Screen screenParameter) {
        this.screen = screenParameter;
        this.init();
    }

    private void init() {
        TextWindow textWindow = this.screen == null ? null : this.screen.textWindow();
        GC g = null;
        if (textWindow != null && !textWindow.isDisposed()) {
            g = new GC((Drawable)textWindow);
            g.setFont(this.screen.currentFont().getFont());
            this.fontMetrics = g.getFontMetrics();
            if (this.fontMetrics != null) {
                this.baseline = this.fontMetrics.getAscent() + this.fontMetrics.getLeading();
                this.textHeight = this.baseline + this.fontMetrics.getDescent();
                this.charWidths = new int[256];
                StringBuilder buffer = new StringBuilder(1).append(' ');
                char ch = '\u0000';
                while (ch < '\u0100') {
                    buffer.setCharAt(0, ch);
                    this.charWidths[ch] = g.stringExtent((String)buffer.toString()).x;
                    ch = (char)(ch + '\u0001');
                }
                this.spaceWidth = this.charWidths[32];
                if (this.spaceWidth == 0) {
                    this.spaceWidth = (int)this.fontMetrics.getAverageCharacterWidth();
                }
            }
            g.dispose();
        }
    }

    int textHeight() {
        return this.textHeight;
    }

    int baseline() {
        return this.baseline;
    }

    int spaceWidth() {
        return this.spaceWidth;
    }

    int substringWidth(String string, int beginIndex, int endIndex) {
        if (string == null) {
            return 0;
        }
        int length = string.length();
        beginIndex = this.correctBeginIndex(length, beginIndex, endIndex);
        endIndex = this.correctEndIndex(length, beginIndex, endIndex);
        String subString = string.substring(beginIndex, endIndex);
        return this.stringWidth(subString);
    }

    int substringWidth(char[] charArray, int beginIndex, int endIndex) {
        if (charArray == null || charArray.length == 0) {
            return 0;
        }
        int beginIndex2 = this.correctBeginIndex(charArray.length, beginIndex, endIndex);
        int endIndex2 = this.correctEndIndex(charArray.length, beginIndex2, endIndex);
        int length = endIndex2 - beginIndex2;
        String string = new String(charArray, beginIndex2, length);
        return this.stringWidth(string);
    }

    int substringWidth(GC g, char[] charArray, int beginIndex, int endIndex) {
        if (charArray == null || charArray.length == 0) {
            return 0;
        }
        int beginIndex2 = this.correctBeginIndex(charArray.length, beginIndex, endIndex);
        int endIndex2 = this.correctEndIndex(charArray.length, beginIndex2, endIndex);
        int length = endIndex2 - beginIndex2;
        String string = new String(charArray, beginIndex2, length);
        return this.calculateStringWidth(g, string);
    }

    int stringWidth(String string) {
        if (string == null) {
            return 0;
        }
        TextWindow textWindow = this.screen.textWindow();
        return textWindow == null || textWindow.isDisposed() ? this.precompiledStringWidth(string) : this.stringWidthTextWindow((Composite)textWindow, string);
    }

    int charWidth(char c) {
        TextWindow textWindow = this.screen.textWindow();
        return textWindow == null || textWindow.isDisposed() ? this.precompiledCharWidth(c) : this.charWidthTextWindow((Composite)textWindow, c);
    }

    private int stringWidthTextWindow(Composite textWindow, String s) {
        GC g = new GC((Drawable)textWindow);
        g.setFont(this.screen.currentFont().getFont());
        int width = this.calculateStringWidth(g, s);
        g.dispose();
        return width;
    }

    private int charWidthTextWindow(Composite textWindow, char c) {
        GC g = new GC((Drawable)textWindow);
        g.setFont(this.screen.currentFont().getFont());
        int width = this.buildCharWidth(g, c);
        g.dispose();
        return width;
    }

    private int precompiledCharWidth(char c) {
        return c <= '\u00ff' && this.charWidths != null && this.charWidths[c] != 0 ? this.charWidths[c] : this.spaceWidth;
    }

    private int precompiledStringWidth(String s) {
        char[] cArray = s.toCharArray();
        int width = 0;
        char[] cArray2 = cArray;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray2[n2];
            width += this.precompiledCharWidth(c);
            ++n2;
        }
        return width;
    }

    private int buildCharWidth(GC g, char c) {
        int width = this.calculateCharWidth(g, c);
        if (c <= '\u00ff') {
            this.charWidths[c] = width;
        }
        return width;
    }

    private int calculateCharWidth(GC g, char c) {
        return this.calculateStringWidth(g, TextFontMetrics.convertCharToString(c));
    }

    private int calculateStringWidth(GC g, String s) {
        return s != null ? g.stringExtent((String)s).x : 0;
    }

    private int correctBeginIndex(int len, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            return 0;
        }
        if (beginIndex > len) {
            return len;
        }
        if (beginIndex > endIndex) {
            return endIndex;
        }
        return beginIndex;
    }

    private int correctEndIndex(int len, int beginIndex, int endIndex) {
        if (endIndex < 0) {
            return 0;
        }
        if (endIndex > len) {
            return len;
        }
        if (beginIndex > endIndex) {
            return beginIndex;
        }
        return endIndex;
    }

    private static final String convertCharToString(char c) {
        return "" + c;
    }
}

