/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesList;
import com.ibm.lpex.core.View;

final class StyleAttributesParameter
extends Parameter {
    private static StyleAttributesParameter _parameter;

    static StyleAttributesParameter getParameter() {
        if (_parameter == null) {
            _parameter = new StyleAttributesParameter();
        }
        return _parameter;
    }

    private StyleAttributesParameter() {
        super("styleAttributes.");
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        int styleId = Screen.styleId(qualifier);
        if (styleId == -1 && qualifier.length() != 1) {
            return CommandHandler.invalidParameter(view, qualifier, "set " + this.name());
        }
        int rc = StyleAttributes.checkStyleAttributes(view, parameters, "set " + this.name(qualifier));
        if (rc == 0) {
            return false;
        }
        if (view != null) {
            boolean backgroundOnly = rc == 2;
            boolean backgroundOnlyChanged = false;
            StyleAttributes styleAttributes = StyleAttributes.getStyleAttributes(parameters);
            StyleAttributesList styleAttributesList = view.styleAttributesList();
            if (styleId != -1) {
                view.screen().setStyleAttributes(styleId, styleAttributes, backgroundOnly);
                if (styleAttributes == null) {
                    styleAttributes = view.screen().styleAttributes(styleId);
                    backgroundOnly = view.screen().backgroundOnly(styleId);
                }
                if (styleId == 15) {
                    styleAttributesList.set('\u0001', styleAttributes);
                } else if (styleId == 16) {
                    styleAttributesList.set('\u0002', styleAttributes);
                } else if (styleId == 0) {
                    backgroundOnlyChanged = styleAttributesList.backgroundOnly('\u0003') ^ backgroundOnly;
                    styleAttributesList.set('\u0003', styleAttributes, backgroundOnly);
                } else if (styleId == 5) {
                    backgroundOnlyChanged = styleAttributesList.backgroundOnly('\u0004') ^ backgroundOnly;
                    styleAttributesList.set('\u0004', styleAttributes, backgroundOnly);
                } else if (styleId == 2) {
                    backgroundOnlyChanged = styleAttributesList.backgroundOnly('\u0005') ^ backgroundOnly;
                    styleAttributesList.set('\u0005', styleAttributes, backgroundOnly);
                }
            } else {
                char styleCharacter = qualifier.charAt(0);
                if (styleCharacter == '!') {
                    view.screen().setStyleAttributes(4, styleAttributes, backgroundOnly);
                } else {
                    backgroundOnlyChanged = styleAttributesList.backgroundOnly(styleCharacter) ^ backgroundOnly;
                    styleAttributesList.set(styleCharacter, styleAttributes, backgroundOnly);
                }
            }
            if (backgroundOnlyChanged) {
                view.styleAttributesChanged();
            }
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return this.query(view, qualifier);
    }

    String query(View view, String qualifier) {
        if (view != null) {
            StyleAttributes styleAttributes = null;
            boolean backgroundOnly = false;
            int styleId = Screen.styleId(qualifier);
            if (styleId != -1) {
                styleAttributes = view.screen().styleAttributes(styleId);
                backgroundOnly = view.screen().backgroundOnly(styleId);
            } else if (qualifier.length() == 1) {
                char styleCharacter = qualifier.charAt(0);
                if (styleCharacter == '!') {
                    styleAttributes = view.screen().styleAttributes(4);
                } else {
                    styleAttributes = view.styleAttributesList().find(styleCharacter);
                    backgroundOnly = view.styleAttributesList().backgroundOnly(styleCharacter);
                }
            }
            if (styleAttributes != null) {
                return styleAttributes.queryString(backgroundOnly);
            }
        }
        return null;
    }
}

