/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Color;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.View;

final class StyleAttributes
extends ListNode {
    private static final int NONE = 0;
    private static final int UNDERLINE = 1;
    private static final int STRIKEOUT = 2;
    private static final int SQUIGGLE = 4;
    private static final int OUTLINE = 8;
    private static final int BOLD = 16;
    private static final int ITALIC = 32;
    private static final int BACKGROUND_DARKMODE = 46;
    static final int INVALID = 0;
    static final int VALID = 1;
    static final int BACKGROUNDONLY = 2;
    private static List _list = new List();
    private Color _foregroundColor;
    private Color _backgroundColor;
    private Color _effectsColor;
    private int _effects;

    private StyleAttributes(Color foregroundColor, Color backgroundColor, Color effectsColor, int effects) {
        this._foregroundColor = foregroundColor;
        this._backgroundColor = backgroundColor;
        this._effectsColor = effectsColor;
        this._effects = effects;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static StyleAttributes getStyleAttributes(String styleAttributesString) {
        int[] intParameter;
        boolean effectsColorSpecified;
        boolean backgroundOnly;
        String token;
        LpexStringTokenizer st;
        block50: {
            st = new LpexStringTokenizer(styleAttributesString);
            String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            if (token == null) {
                return null;
            }
            backgroundOnly = false;
            effectsColorSpecified = false;
            intParameter = new int[9];
            int i = 0;
            try {
                while (i < 9) {
                    if (token == null) {
                        if (i < 6 || effectsColorSpecified) {
                            return null;
                        }
                        break;
                    }
                    intParameter[i] = Integer.parseInt(token);
                    if (intParameter[i] < 0) {
                        if (i > 2) {
                            return null;
                        }
                        backgroundOnly = true;
                    } else if (intParameter[i] > 255) {
                        return null;
                    }
                    if (i > 5) {
                        effectsColorSpecified = true;
                    }
                    token = st.hasMoreTokens() ? st.nextToken() : null;
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                if (i >= 6 && !effectsColorSpecified) break block50;
                return null;
            }
        }
        if (backgroundOnly) {
            if (intParameter[0] != -1 || intParameter[1] != -1 || intParameter[2] != -1) {
                return null;
            }
            intParameter[0] = 0;
            intParameter[1] = 0;
            intParameter[2] = 170;
            if (intParameter[3] == 46 && intParameter[4] == 46 && intParameter[5] == 46) {
                intParameter[0] = 100;
                intParameter[1] = 150;
            }
        }
        int style = 0;
        while (token != null) {
            if (token.equalsIgnoreCase("underline")) {
                style |= 1;
            } else if (token.equalsIgnoreCase("strikeout")) {
                style |= 2;
            } else if (token.equalsIgnoreCase("squiggle")) {
                style |= 4;
            } else if (token.equalsIgnoreCase("outline")) {
                style |= 8;
            } else if (token.equalsIgnoreCase("bold")) {
                style |= 0x10;
            } else if (token.equalsIgnoreCase("italic")) {
                style |= 0x20;
            } else {
                return null;
            }
            String string = token = st.hasMoreTokens() ? st.nextToken() : null;
        }
        Color fg = new Color(intParameter[0], intParameter[1], intParameter[2]);
        Color bg = new Color(intParameter[3], intParameter[4], intParameter[5]);
        Color ef = effectsColorSpecified ? new Color(intParameter[6], intParameter[7], intParameter[8]) : null;
        StyleAttributes styleAttributes = (StyleAttributes)_list.first();
        while (styleAttributes != null && !styleAttributes.equals(fg, bg, ef, style)) {
            styleAttributes = (StyleAttributes)styleAttributes.next();
        }
        if (styleAttributes == null) {
            boolean fgFound = false;
            boolean bgFound = false;
            boolean efFound = ef == null;
            styleAttributes = (StyleAttributes)_list.first();
            while (!(styleAttributes == null || fgFound && bgFound && efFound)) {
                if (!fgFound) {
                    if (fg.isEquivalent(styleAttributes.foregroundColor())) {
                        fg.dispose();
                        fg = styleAttributes.foregroundColor();
                        fgFound = true;
                    } else if (fg.isEquivalent(styleAttributes.backgroundColor())) {
                        fg.dispose();
                        fg = styleAttributes.backgroundColor();
                        fgFound = true;
                    } else if (fg.isEquivalent(styleAttributes.effectsColor())) {
                        fg.dispose();
                        fg = styleAttributes.effectsColor();
                        fgFound = true;
                    }
                }
                if (!bgFound) {
                    if (bg.isEquivalent(styleAttributes.foregroundColor())) {
                        bg.dispose();
                        bg = styleAttributes.foregroundColor();
                        bgFound = true;
                    } else if (bg.isEquivalent(styleAttributes.backgroundColor())) {
                        bg.dispose();
                        bg = styleAttributes.backgroundColor();
                        bgFound = true;
                    } else if (bg.isEquivalent(styleAttributes.effectsColor())) {
                        bg.dispose();
                        bg = styleAttributes.effectsColor();
                        bgFound = true;
                    }
                }
                if (!efFound && ef != null) {
                    if (ef.isEquivalent(styleAttributes.foregroundColor())) {
                        ef.dispose();
                        ef = styleAttributes.foregroundColor();
                        efFound = true;
                    } else if (ef.isEquivalent(styleAttributes.backgroundColor())) {
                        ef.dispose();
                        ef = styleAttributes.backgroundColor();
                        efFound = true;
                    } else if (ef.isEquivalent(styleAttributes.effectsColor())) {
                        ef.dispose();
                        ef = styleAttributes.effectsColor();
                        efFound = true;
                    }
                }
                styleAttributes = (StyleAttributes)styleAttributes.next();
            }
            styleAttributes = new StyleAttributes(fg, bg, ef, style);
        } else {
            _list.remove(styleAttributes);
            fg.dispose();
            bg.dispose();
            if (ef != null) {
                ef.dispose();
            }
        }
        _list.addAfter(null, styleAttributes);
        return styleAttributes;
    }

    static StyleAttributes getStyleAttributes(StyleAttributes foregroundStyleAttributes, StyleAttributes backgroundStyleAttributes) {
        if (backgroundStyleAttributes == null || foregroundStyleAttributes == null) {
            return null;
        }
        int style = backgroundStyleAttributes._effects | foregroundStyleAttributes._effects;
        Color fg = foregroundStyleAttributes.foregroundColor();
        Color bg = backgroundStyleAttributes.backgroundColor();
        Color ef = foregroundStyleAttributes.effectsColor();
        if (ef == null) {
            ef = backgroundStyleAttributes.effectsColor();
        }
        StyleAttributes styleAttributes = (StyleAttributes)_list.first();
        while (styleAttributes != null && !styleAttributes.equals(fg, bg, ef, style)) {
            styleAttributes = (StyleAttributes)styleAttributes.next();
        }
        if (styleAttributes == null) {
            styleAttributes = new StyleAttributes(fg, bg, ef, style);
        } else {
            _list.remove(styleAttributes);
        }
        _list.addAfter(null, styleAttributes);
        return styleAttributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] getRgb(String color) {
        LpexStringTokenizer st = new LpexStringTokenizer(color);
        int[] rgb = new int[3];
        try {
            int i = 0;
            while (i < 3) {
                if (!st.hasMoreTokens()) {
                    return null;
                }
                rgb[i] = Integer.parseInt(st.nextToken());
                if (rgb[i] < 0) return null;
                if (rgb[i] > 255) {
                    return null;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (st.hasMoreTokens()) {
            return null;
        }
        int[] nArray = rgb;
        return nArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int checkStyleAttributes(View view, String styleAttributesString, String command) {
        st = new LpexStringTokenizer(styleAttributesString);
        if (st.hasMoreTokens() == false) return 1;
        v0 = st.nextToken();
        token = v0;
        if (token == null) {
            return 1;
        }
        backgroundOnly = false;
        effectsColorSpecified = false;
        i = 0;
        try {
            while (i < 9) {
                block12: {
                    if (token != null) break block12;
                    if (i < 6 || effectsColorSpecified) {
                        CommandHandler.incomplete(view, command);
                        return 0;
                    }
                    ** GOTO lbl47
                }
                intParameter = Integer.parseInt(token);
                if (intParameter < 0) {
                    if (intParameter != -1 || i > 2 || i != 0 && !backgroundOnly) {
                        CommandHandler.invalidParameter(view, token, command);
                        return 0;
                    }
                    backgroundOnly = true;
                } else if (intParameter > 255 || backgroundOnly && i < 3) {
                    CommandHandler.invalidParameter(view, token, command);
                    return 0;
                }
                if (i > 5) {
                    effectsColorSpecified = true;
                }
                token = st.hasMoreTokens() != false ? st.nextToken() : null;
                ++i;
            }
            ** GOTO lbl47
        }
        catch (NumberFormatException e) {
            if (i >= 6 && !effectsColorSpecified) ** GOTO lbl47
            CommandHandler.invalidParameter(view, token, command);
            return 0;
        }
lbl-1000:
        // 1 sources

        {
            if (!(token.equalsIgnoreCase("underline") || token.equalsIgnoreCase("strikeout") || token.equalsIgnoreCase("squiggle") || token.equalsIgnoreCase("outline") || token.equalsIgnoreCase("bold") || token.equalsIgnoreCase("italic"))) {
                CommandHandler.invalidParameter(view, token, command);
                return 0;
            }
            v1 = token = st.hasMoreTokens() != false ? st.nextToken() : null;
lbl47:
            // 4 sources

            ** while (token != null)
        }
lbl48:
        // 1 sources

        if (backgroundOnly == false) return 1;
        return 2;
    }

    boolean equals(StyleAttributes styleAttributes) {
        if (this == styleAttributes) {
            return true;
        }
        return styleAttributes != null && this._effects == styleAttributes._effects && this._foregroundColor.equals(styleAttributes.foregroundColor()) && this._backgroundColor.equals(styleAttributes.backgroundColor()) && (this._effectsColor == null && styleAttributes.effectsColor() == null || this._effectsColor != null && this._effectsColor.equals(styleAttributes.effectsColor()));
    }

    boolean equalsInPainting(StyleAttributes styleAttributes) {
        if (this.outline() && !this._foregroundColor.equals(styleAttributes.foregroundColor())) {
            return false;
        }
        return this._effects == styleAttributes._effects && this._backgroundColor.equals(styleAttributes.backgroundColor()) && (this._effectsColor == null && styleAttributes.effectsColor() == null || this._effectsColor != null && this._effectsColor.equals(styleAttributes.effectsColor()));
    }

    private boolean equals(Color foregroundColor, Color backgroundColor, Color effectsColor, int effects) {
        return this._effects == effects && this._foregroundColor.equals(foregroundColor) && this._backgroundColor.equals(backgroundColor) && (this._effectsColor == null && effectsColor == null || this._effectsColor != null && this._effectsColor.equals(effectsColor));
    }

    Color foregroundColor() {
        return this._foregroundColor;
    }

    Color backgroundColor() {
        return this._backgroundColor;
    }

    Color effectsColor() {
        return this._effectsColor;
    }

    String backgroundColorString() {
        return "" + this._backgroundColor.getRed() + ' ' + this._backgroundColor.getGreen() + ' ' + this._backgroundColor.getBlue();
    }

    boolean underline() {
        return (this._effects & 1) != 0;
    }

    boolean strikeout() {
        return (this._effects & 2) != 0;
    }

    boolean squiggle() {
        return (this._effects & 4) != 0;
    }

    boolean outline() {
        return (this._effects & 8) != 0;
    }

    boolean bold() {
        return (this._effects & 0x10) != 0;
    }

    boolean italic() {
        return (this._effects & 0x20) != 0;
    }

    boolean boldItalic() {
        return (this._effects & 0x30) == 48;
    }

    String queryString(boolean backgroundOnly) {
        StringBuilder buffer = new StringBuilder(96);
        if (backgroundOnly) {
            buffer.append("-1 -1 -1 ");
        } else {
            buffer.append(this._foregroundColor.getRed()).append(' ').append(this._foregroundColor.getGreen()).append(' ').append(this._foregroundColor.getBlue()).append(' ');
        }
        buffer.append(this._backgroundColor.getRed()).append(' ').append(this._backgroundColor.getGreen()).append(' ').append(this._backgroundColor.getBlue());
        if (this._effectsColor != null) {
            buffer.append(' ').append(this._effectsColor.getRed()).append(' ').append(this._effectsColor.getGreen()).append(' ').append(this._effectsColor.getBlue());
        }
        if (this.underline()) {
            buffer.append(" underline");
        }
        if (this.strikeout()) {
            buffer.append(" strikeout");
        }
        if (this.squiggle()) {
            buffer.append(" squiggle");
        }
        if (this.outline()) {
            buffer.append(" outline");
        }
        if (this.bold()) {
            buffer.append(" bold");
        }
        if (this.italic()) {
            buffer.append(" italic");
        }
        return buffer.toString();
    }

    static String background(View view) {
        StyleAttributes defaultStyleAttributes;
        if (view != null && (defaultStyleAttributes = view.screen().styleAttributes(4)) != null) {
            return defaultStyleAttributes.backgroundColorString();
        }
        return null;
    }

    static String convert(String styleAttributesString, String fromBackground, String toBackground) {
        if (styleAttributesString == null || fromBackground == null || toBackground == null) {
            return null;
        }
        if (fromBackground.equals(toBackground)) {
            return styleAttributesString;
        }
        StyleAttributes styleAttributes = StyleAttributes.getStyleAttributes(styleAttributesString);
        if (styleAttributes == null) {
            return null;
        }
        int[] fromBackgroundRgb = StyleAttributes.getRgb(fromBackground);
        int[] toBackgroundRgb = StyleAttributes.getRgb(toBackground);
        if (fromBackgroundRgb == null || toBackgroundRgb == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(96);
        if (StyleAttributes.checkStyleAttributes(null, styleAttributesString, null) == 2) {
            buffer.append("-1 -1 -1");
        } else {
            buffer.append(StyleAttributes.convertColorComponent(styleAttributes.foregroundColor().getRed(), fromBackgroundRgb[0], toBackgroundRgb[0])).append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.foregroundColor().getGreen(), fromBackgroundRgb[1], toBackgroundRgb[1])).append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.foregroundColor().getBlue(), fromBackgroundRgb[2], toBackgroundRgb[2]));
        }
        buffer.append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.backgroundColor().getRed(), fromBackgroundRgb[0], toBackgroundRgb[0])).append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.backgroundColor().getGreen(), fromBackgroundRgb[1], toBackgroundRgb[1])).append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.backgroundColor().getBlue(), fromBackgroundRgb[2], toBackgroundRgb[2]));
        if (styleAttributes.effectsColor() != null) {
            buffer.append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.effectsColor().getRed(), fromBackgroundRgb[0], toBackgroundRgb[0])).append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.effectsColor().getGreen(), fromBackgroundRgb[1], toBackgroundRgb[1])).append(' ').append(StyleAttributes.convertColorComponent(styleAttributes.effectsColor().getBlue(), fromBackgroundRgb[2], toBackgroundRgb[2]));
        }
        if (styleAttributes.underline()) {
            buffer.append(" underline");
        }
        if (styleAttributes.strikeout()) {
            buffer.append(" strikeout");
        }
        if (styleAttributes.squiggle()) {
            buffer.append(" squiggle");
        }
        if (styleAttributes.outline()) {
            buffer.append(" outline");
        }
        if (styleAttributes.bold()) {
            buffer.append(" bold");
        }
        if (styleAttributes.italic()) {
            buffer.append(" italic");
        }
        return buffer.toString();
    }

    private static int convertColorComponent(int colorComponent, int fromColorComponent, int toColorComponent) {
        int contrast = colorComponent - fromColorComponent;
        boolean moreColorPreferred = true;
        if (contrast < 0) {
            contrast = -contrast;
            moreColorPreferred = false;
        }
        int moreColor = toColorComponent + contrast;
        int lessColor = toColorComponent - contrast;
        int moreColorOverflow = 0;
        if (moreColor > 255) {
            moreColorOverflow = moreColor - 255;
            moreColor = 255;
        }
        int lessColorOverflow = 0;
        if (lessColor < 0) {
            lessColorOverflow = -lessColor;
            lessColor = 0;
        }
        int returnValue = colorComponent;
        returnValue = moreColorOverflow == 0 && lessColorOverflow == 0 ? (moreColorPreferred ? moreColor : lessColor) : (moreColorOverflow > lessColorOverflow ? lessColor : moreColor);
        return returnValue;
    }
}

