/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.RealColumnNumbersParameter;
import com.ibm.lpex.core.StatusLineListener;

final class StatusLineManager
extends List {
    static final int INPUT_MODE_INSERT = 1;
    static final int INPUT_MODE_REPLACE = 2;
    static final int INPUT_MODE_COMMAND = 3;
    private static String MSG_INSERT;
    private static String MSG_REPLACE;
    private static String MSG_COMMAND;
    private static String MSG_BROWSE;
    private int _line;
    private int _column;
    private int _inputMode;
    private int _changes;
    private boolean _browseMode;
    private String _info;

    StatusLineManager() {
        this.initializeNlsStrings();
    }

    private void initializeNlsStrings() {
        MSG_INSERT = LpexResources.message("status.insert");
        MSG_REPLACE = LpexResources.message("status.replace");
        MSG_COMMAND = LpexResources.message("status.command");
        MSG_BROWSE = LpexResources.message("status.browse");
    }

    void localeChanged() {
        this.initializeNlsStrings();
        List.Node node = this.first();
        while (node != null) {
            this.refreshListener(((ListenerNode)node).listener());
            node = node.next();
        }
    }

    void setLine(int line) {
        if (this._line != line) {
            this._line = line;
            List.Node node = this.first();
            while (node != null) {
                ((ListenerNode)node).listener().line(this._line);
                node = node.next();
            }
        }
    }

    void setColumn(LpexView view, int column) {
        if (this._column != (column = RealColumnNumbersParameter.getRealColumnNumber(view._view, column))) {
            this._column = column;
            List.Node node = this.first();
            while (node != null) {
                ListenerNode n = (ListenerNode)node;
                StatusLineListener s = n.listener();
                s.column(this._column);
                node = node.next();
            }
        }
    }

    void setInputMode(int inputMode) {
        if (this._inputMode != inputMode) {
            this._inputMode = inputMode;
            String inputModeText = this.inputModeText();
            List.Node node = this.first();
            while (node != null) {
                ((ListenerNode)node).listener().inputMode(inputModeText);
                node = node.next();
            }
        }
    }

    private String inputModeText() {
        String inputModeText = null;
        switch (this._inputMode) {
            case 1: {
                inputModeText = MSG_INSERT;
                break;
            }
            case 2: {
                inputModeText = MSG_REPLACE;
                break;
            }
            case 3: {
                inputModeText = MSG_COMMAND;
                break;
            }
        }
        return inputModeText;
    }

    void setChanges(int changes) {
        if (this._changes != changes) {
            this._changes = changes;
            List.Node node = this.first();
            while (node != null) {
                ((ListenerNode)node).listener().changes(this._changes);
                node = node.next();
            }
        }
    }

    void setBrowseMode(boolean browseMode) {
        if (this._browseMode != browseMode) {
            this._browseMode = browseMode;
            String browseModeText = this._browseMode ? MSG_BROWSE : null;
            List.Node node = this.first();
            while (node != null) {
                ((ListenerNode)node).listener().browseMode(browseModeText);
                node = node.next();
            }
        }
    }

    void setInfo(String info) {
        if (this._info == null && info == null) {
            return;
        }
        if (this._info == null || !this._info.equals(info)) {
            this._info = info;
            List.Node node = this.first();
            while (node != null) {
                ((ListenerNode)node).listener().info(this._info);
                node = node.next();
            }
        }
    }

    void addListener(StatusLineListener listener) {
        if (this.find(listener) == null) {
            this.addAfter(null, new ListenerNode(listener));
            this.refreshListener(listener);
        }
    }

    private void refreshListener(StatusLineListener listener) {
        listener.line(this._line);
        listener.column(this._column);
        listener.inputMode(this.inputModeText());
        listener.changes(this._changes);
        listener.browseMode(this._browseMode ? MSG_BROWSE : null);
        listener.info(this._info);
    }

    void removeListener(StatusLineListener listener) {
        ListenerNode node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
    }

    ListenerNode find(StatusLineListener listener) {
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (node.listener() == listener) {
                return node;
            }
            node = (ListenerNode)node.next();
        }
        return null;
    }

    private static class ListenerNode
    extends ListNode {
        private StatusLineListener _listener;

        ListenerNode(StatusLineListener listener) {
            this._listener = listener;
        }

        StatusLineListener listener() {
            return this._listener;
        }
    }
}

