/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.View;

final class SourceCcsidParameter
extends ParameterIntegerDefault {
    private static SourceCcsidParameter _parameter;
    private static int DEFAULT_CCSID;

    static {
        DEFAULT_CCSID = 0;
    }

    static SourceCcsidParameter getParameter() {
        if (_parameter == null) {
            _parameter = new SourceCcsidParameter();
        }
        return _parameter;
    }

    private SourceCcsidParameter() {
        super("sourceCcsid", DEFAULT_CCSID);
    }

    @Override
    boolean setValue(View view, int value, boolean useDefaultValue) {
        if (value < 0 || value > 65535) {
            return CommandHandler.invalidParameter(view, String.valueOf(value), "set " + this.name());
        }
        if (view != null) {
            Document document = view.document();
            boolean changed = document._sourceCcsidParm != value;
            document._sourceCcsidParm = value;
            document._useDefaultSourceCcsid = useDefaultValue;
            if (changed) {
                this.currentValueChanged(view);
            }
        }
        return true;
    }

    @Override
    void currentValueChanged(View view) {
        view.document().sourceCcsidChanged();
    }

    @Override
    boolean useDefaultValue(View view) {
        return view != null ? view.document()._useDefaultSourceCcsid : true;
    }

    @Override
    int value(View view) {
        return view != null ? view.document()._sourceCcsidParm : DEFAULT_CCSID;
    }
}

