/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.icu.text.Collator;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.View;
import java.util.Arrays;
import java.util.Comparator;

final class SortCommand {
    static java.text.Collator _jdkCollator;
    static Collator _icuCollator;

    SortCommand() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean doCommand(View view, String parameters) {
        LpexStringTokenizer st;
        Block block = view == null ? Block.lpexBlock() : view.block();
        boolean selection = view != null && block.view() == view && block.anythingSelected();
        boolean all = !selection;
        int startElement = 0;
        int endElement = 0;
        boolean isIgnoringBidiMarks = view != null ? view.nls().isIgnoringBidiMarks() : false;
        boolean usingSourceColumns = view != null ? view.nls().usingSourceColumns() : false;
        FieldOptions options = new FieldOptions();
        options._isIgnoringBidiMarks = isIgnoringBidiMarks;
        options._usingSourceColumns = usingSourceColumns;
        if (selection && block.type() == 3) {
            options._blockRectangle = true;
        }
        if ((st = new LpexStringTokenizer(parameters)).hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("all")) {
                all = true;
                selection = false;
                options._blockRectangle = false;
                token = null;
            } else if (token.equalsIgnoreCase("block") || token.equalsIgnoreCase("selection")) {
                selection = true;
                options._blockRectangle = block.type() == 3;
                all = false;
                token = null;
            } else if (token.equalsIgnoreCase("elementRange")) {
                selection = false;
                all = false;
                options._blockRectangle = false;
                startElement = 1;
                int n = endElement = view != null ? view.document().elementList().count() : 0;
                if (!st.hasMoreTokens()) return CommandHandler.integerMissing(view, "elementRange", "sort");
                token = st.nextToken();
                try {
                    startElement = Integer.parseInt(token) - (view != null ? view.document().linesBeforeStart() : 0);
                    if (startElement < 1) {
                        return CommandHandler.invalidParameter(view, token, "sort");
                    }
                    token = null;
                    if (st.hasMoreTokens()) {
                        token = st.nextToken();
                        try {
                            endElement = Integer.parseInt(token) - (view != null ? view.document().linesBeforeStart() : 0);
                            if (endElement < 1) {
                                return CommandHandler.invalidParameter(view, token, "sort");
                            }
                            token = null;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (NumberFormatException e) {
                    return CommandHandler.integerMissing(view, "elementRange", "sort");
                }
            }
            FieldOptions currentFieldOptions = options;
            while (token != null || st.hasMoreTokens()) {
                FieldOptions newFieldOptions;
                if (token == null) {
                    token = st.nextToken();
                }
                if (token.equalsIgnoreCase("descending")) {
                    currentFieldOptions._descending = true;
                    token = null;
                    continue;
                }
                if (token.equalsIgnoreCase("numeric")) {
                    currentFieldOptions._numeric = true;
                    token = null;
                    continue;
                }
                if (token.equalsIgnoreCase("localeSensitive")) {
                    currentFieldOptions._localeSensitive = true;
                    token = null;
                    SortCommand.createCollator();
                    continue;
                }
                if (token.equalsIgnoreCase("columnRange")) {
                    currentFieldOptions._blockRectangle = false;
                    if (!st.hasMoreTokens()) return CommandHandler.integerMissing(view, "columnRange", "sort");
                    token = st.nextToken();
                    try {
                        currentFieldOptions._startColumn = Integer.parseInt(token);
                        if (currentFieldOptions._startColumn < 1) {
                            return CommandHandler.invalidParameter(view, token, "sort");
                        }
                        token = null;
                        if (!st.hasMoreTokens()) continue;
                        token = st.nextToken();
                        try {
                            currentFieldOptions._endColumn = Integer.parseInt(token);
                            if (currentFieldOptions._endColumn < 1) {
                                return CommandHandler.invalidParameter(view, token, "sort");
                            }
                            token = null;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.integerMissing(view, "columnRange", "sort");
                    }
                }
                if (!token.equalsIgnoreCase("newField")) return CommandHandler.invalidParameter(view, token, "sort");
                currentFieldOptions._next = newFieldOptions = new FieldOptions();
                currentFieldOptions = newFieldOptions;
                newFieldOptions._isIgnoringBidiMarks = isIgnoringBidiMarks;
                newFieldOptions._usingSourceColumns = usingSourceColumns;
                token = null;
            }
        }
        if (view == null) {
            return true;
        }
        if (all) {
            startElement = 1;
            endElement = view.document().elementList().count();
        } else if (selection) {
            if (block.view() == view && block.anythingSelected()) {
                startElement = view.document().elementList().ordinalOf(block.topElement());
                endElement = view.document().elementList().ordinalOf(block.bottomElement());
            } else {
                startElement = 0;
                endElement = 0;
            }
        }
        SortCommand.sort(view, startElement, endElement, options);
        return true;
    }

    static void sort(View view, int startElementOrdinal, int endElementOrdinal, FieldOptions options) {
        if (!view.changeAllowed()) {
            return;
        }
        ElementList elementList = view.document().elementList();
        MarkList markList = view.markList();
        Element startElement = elementList.elementAt(startElementOrdinal);
        while (startElement != null && (!startElement.visible(view) || startElement.show() || markList.protect(startElement))) {
            startElement = startElement.next();
        }
        Element endElement = elementList.elementAt(endElementOrdinal);
        while (endElement != null && (!endElement.visible(view) || endElement.show() || markList.protect(endElement))) {
            endElement = endElement.prev();
        }
        if (startElement == null || endElement == null || elementList.ordinalOf(startElement) >= elementList.ordinalOf(endElement)) {
            return;
        }
        int count = 2;
        Element element = startElement.next();
        while (element != null && element != endElement) {
            if (element.visible(view) && !element.show() && !markList.protect(element)) {
                ++count;
            }
            element = element.next();
        }
        Element[] elements = new Element[count];
        elements[0] = startElement;
        elements[count - 1] = endElement;
        int i = 1;
        element = startElement.next();
        while (element != null && element != endElement) {
            if (element.visible(view) && !element.show() && !markList.protect(element)) {
                elements[i] = element;
                ++i;
            }
            element = element.next();
        }
        Element[] originalElements = new Element[count];
        i = 0;
        while (i < count) {
            originalElements[i] = elements[i];
            ++i;
        }
        SortComparator comparator = new SortComparator(view, options);
        Arrays.sort(elements, comparator);
        String[] newTexts = new String[count];
        i = 0;
        while (i < count) {
            if (originalElements[i] != elements[i]) {
                newTexts[i] = elements[i].text();
            }
            ++i;
        }
        DocumentPosition documentPosition = view.documentPosition();
        DocumentPosition.Preserve preserve = documentPosition.preserve();
        i = 0;
        while (i < count) {
            if (newTexts[i] != null) {
                documentPosition.jump(originalElements[i], 1);
                view.overlayElements(newTexts[i]);
            }
            ++i;
        }
        preserve.restore();
        documentPosition.disposePreserve(preserve);
    }

    static void localeChanged() {
        _jdkCollator = null;
        _icuCollator = null;
    }

    private static void createCollator() {
        if (_jdkCollator != null || _icuCollator != null) {
            return;
        }
        try {
            _icuCollator = Collator.getInstance();
        }
        catch (Throwable t) {
            _jdkCollator = java.text.Collator.getInstance();
        }
    }

    private static int collatorCompare(String text1, String text2) {
        if (_icuCollator != null) {
            return _icuCollator.compare(text1, text2);
        }
        if (_jdkCollator != null) {
            return _jdkCollator.compare(text1, text2);
        }
        return 0;
    }

    static final class FieldOptions {
        FieldOptions _next;
        int _startColumn = 1;
        int _endColumn = -1;
        boolean _blockRectangle;
        boolean _numeric;
        boolean _descending;
        boolean _localeSensitive;
        boolean _isIgnoringBidiMarks;
        boolean _usingSourceColumns;

        FieldOptions() {
        }

        String text(View view, Element element) {
            if (this._blockRectangle) {
                StringBuilder buffer = new StringBuilder(element.length());
                view.block().getSelectedText(view, element, buffer);
                return this.stripBidiMarks(buffer.toString());
            }
            String text = this.stripBidiMarks(element.text());
            int startColumn = this._startColumn;
            int endColumn = this._endColumn;
            if (this._usingSourceColumns) {
                startColumn = view.nls().indexFromEncodingIndex(text, startColumn - 1) + 1;
                endColumn = view.nls().indexFromEncodingIndex(text, endColumn - 1) + 1;
                if (LpexNls.isLigature(text, endColumn - 1)) {
                    ++endColumn;
                }
            }
            if (LpexNls.isTrailingSurrogate(text, startColumn - 1)) {
                --startColumn;
            }
            if (LpexNls.isLeadingSurrogate(text, endColumn - 1)) {
                ++endColumn;
            }
            if (startColumn > text.length()) {
                text = "";
            } else if (startColumn > 1) {
                text = text.substring(startColumn - 1);
            }
            if (endColumn > 0) {
                int len = endColumn - startColumn + 1;
                if (len <= 0) {
                    text = "";
                } else if (text.length() > len) {
                    text = text.substring(0, len);
                }
            }
            return text;
        }

        String stripBidiMarks(String text) {
            return this._isIgnoringBidiMarks ? LpexNls.stripBidiMarks(text) : text;
        }
    }

    static final class SortComparator
    implements Comparator<Element> {
        private View _view;
        private FieldOptions _options;

        SortComparator(View view, FieldOptions options) {
            this._view = view;
            this._options = options;
        }

        @Override
        public int compare(Element o1, Element o2) {
            int compare;
            FieldOptions options = this._options;
            do {
                String text1 = options.text(this._view, o1);
                String text2 = options.text(this._view, o2);
                if (options._numeric) {
                    try {
                        int integer1 = Integer.parseInt(text1.trim());
                        int integer2 = Integer.parseInt(text2.trim());
                        compare = integer1 - integer2;
                    }
                    catch (NumberFormatException e) {
                        compare = text1.compareTo(text2);
                    }
                } else {
                    compare = options._localeSensitive ? SortCommand.collatorCompare(text1, text2) : text1.compareTo(text2);
                }
                if (compare != 0 && options._descending) {
                    compare = -compare;
                }
                options = options._next;
            } while (compare == 0 && options != null);
            return compare;
        }
    }
}

