/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.ParameterCharacterDefault;
import com.ibm.lpex.core.View;

final class ShiftInCharacterParameter
extends ParameterCharacterDefault {
    private static ShiftInCharacterParameter _parameter;

    static ShiftInCharacterParameter getParameter() {
        if (_parameter == null) {
            _parameter = new ShiftInCharacterParameter();
        }
        return _parameter;
    }

    private ShiftInCharacterParameter() {
        super("shiftInCharacter", ' ');
    }

    @Override
    boolean setValue(View view, String qualifier, char value) {
        if (view != null) {
            char oldValue = this.currentValue(view);
            if (!view.nls().setSI(value)) {
                return CommandHandler.invalidParameter(view, String.valueOf(value), "set " + this.name());
            }
            if (oldValue != this.currentValue(view)) {
                this.currentValueChanged(view);
            }
        }
        return true;
    }

    @Override
    void currentValueChanged(View view) {
        view.showSosiChanged();
    }

    @Override
    char value(View view) {
        return view != null ? view.nls().SI : (char)'\u0000';
    }
}

