/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

final class SequenceNumbersParameter
extends ParameterDefault {
    private static SequenceNumbersParameter _parameter;
    private static final int _hardCodedNumColumn = 1;
    private static final int _hardCodedNumWidth = 0;
    private static final int _hardCodedTextColumn = 1;
    private static final int _hardCodedTextWidth = 0;
    private int _installNumColumn;
    private int _installNumWidth;
    private int _installTextColumn;
    private int _installTextWidth;
    private boolean _installValueLoaded;
    private int _defaultNumColumn;
    private int _defaultNumWidth;
    private int _defaultTextColumn;
    private int _defaultTextWidth;
    private boolean _defaultValueLoaded;
    private boolean _useInstallValue;

    static SequenceNumbersParameter getParameter() {
        if (_parameter == null) {
            _parameter = new SequenceNumbersParameter();
        }
        return _parameter;
    }

    private SequenceNumbersParameter() {
        super("sequenceNumbers");
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                SequenceNumbersParameter.this._installValueLoaded = false;
                if (SequenceNumbersParameter.this.useInstallValue()) {
                    SequenceNumbersParameter.this.defaultValueChanged();
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                SequenceNumbersParameter.this._defaultValueLoaded = false;
                SequenceNumbersParameter.this.defaultValueChanged();
            }
        });
    }

    private void loadInstallValue() {
        if (!this._installValueLoaded) {
            this._installNumColumn = 1;
            this._installNumWidth = 0;
            this._installTextColumn = 1;
            this._installTextWidth = 0;
            this._installValueLoaded = true;
            int numColumn = 1;
            int numWidth = 0;
            int textColumn = 1;
            int textWidth = 0;
            String value = Install.getString("install." + this.name());
            if (value != null) {
                LpexStringTokenizer st = new LpexStringTokenizer(value);
                try {
                    if (st.hasMoreTokens()) {
                        numColumn = Integer.parseInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            numWidth = Integer.parseInt(st.nextToken());
                            if (st.hasMoreTokens()) {
                                textColumn = Integer.parseInt(st.nextToken());
                                if (!st.hasMoreTokens()) {
                                    return;
                                }
                                textWidth = Integer.parseInt(st.nextToken());
                                if (st.hasMoreTokens()) {
                                    return;
                                }
                            }
                            if (SequenceNumbersParameter.validSequenceNumbers(numColumn, numWidth, textColumn, textWidth, null, null)) {
                                this._installNumColumn = numColumn;
                                this._installNumWidth = numWidth;
                                this._installTextColumn = textColumn;
                                this._installTextWidth = textWidth;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private int installNumColumn() {
        this.loadInstallValue();
        return this._installNumColumn;
    }

    private int installTextColumn() {
        this.loadInstallValue();
        return this._installTextColumn;
    }

    private int installNumWidth() {
        this.loadInstallValue();
        return this._installNumWidth;
    }

    private int installTextWidth() {
        this.loadInstallValue();
        return this._installTextWidth;
    }

    private void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            this._useInstallValue = true;
            this._defaultValueLoaded = true;
            int numColumn = this._installNumColumn;
            int numWidth = this._installNumWidth;
            int textColumn = this._installTextColumn;
            int textWidth = this._installTextWidth;
            String value = Profile.getString("default." + this.name());
            if (value != null) {
                LpexStringTokenizer st = new LpexStringTokenizer(value);
                try {
                    if (st.hasMoreTokens()) {
                        numColumn = Integer.parseInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            numWidth = Integer.parseInt(st.nextToken());
                            if (st.hasMoreTokens()) {
                                textColumn = Integer.parseInt(st.nextToken());
                                if (!st.hasMoreTokens()) {
                                    return;
                                }
                                textWidth = Integer.parseInt(st.nextToken());
                                if (st.hasMoreTokens()) {
                                    return;
                                }
                            }
                            if (SequenceNumbersParameter.validSequenceNumbers(numColumn, numWidth, textColumn, textWidth, null, null)) {
                                this._useInstallValue = false;
                                this._defaultNumColumn = numColumn;
                                this._defaultNumWidth = numWidth;
                                this._defaultTextColumn = textColumn;
                                this._defaultTextWidth = textWidth;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean useInstallValue() {
        this.loadDefaultValue();
        return this._useInstallValue;
    }

    private int defaultNumColumn() {
        this.loadDefaultValue();
        return this._defaultNumColumn;
    }

    private int defaultTextColumn() {
        this.loadDefaultValue();
        return this._defaultTextColumn;
    }

    private int defaultNumWidth() {
        this.loadDefaultValue();
        return this._defaultNumWidth;
    }

    private int defaultTextWidth() {
        this.loadDefaultValue();
        return this._defaultTextWidth;
    }

    private boolean setDefaultValue(int numColumn, int numWidth, int textColumn, int textWidth, boolean useInstallValue) {
        this._defaultNumColumn = numColumn;
        this._defaultNumWidth = numWidth;
        this._defaultTextColumn = textColumn;
        this._defaultTextWidth = textWidth;
        this._useInstallValue = useInstallValue;
        this._defaultValueLoaded = true;
        if (!this._useInstallValue) {
            StringBuilder value = new StringBuilder();
            value.append(this._defaultNumColumn).append(' ').append(this._defaultNumWidth).append(' ').append(this._defaultTextColumn).append(' ').append(this._defaultTextWidth);
            Profile.putString("default." + this.name(), value.toString());
        } else {
            Profile.remove("default." + this.name());
        }
        this.defaultValueChanged();
        return true;
    }

    int currentNumColumn(Document document) {
        if (this.useDefaultValue(document)) {
            return this.useInstallValue() ? this.installNumColumn() : this.defaultNumColumn();
        }
        return this.numColumn(document);
    }

    int currentTextColumn(Document document) {
        if (this.useDefaultValue(document)) {
            return this.useInstallValue() ? this.installTextColumn() : this.defaultTextColumn();
        }
        return this.textColumn(document);
    }

    int currentNumWidth(Document document) {
        if (this.useDefaultValue(document)) {
            return this.useInstallValue() ? this.installNumWidth() : this.defaultNumWidth();
        }
        return this.numWidth(document);
    }

    int currentTextWidth(Document document) {
        if (this.useDefaultValue(document)) {
            return this.useInstallValue() ? this.installTextWidth() : this.defaultTextWidth();
        }
        return this.textWidth(document);
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        boolean useDefaultValue = true;
        int numColumn = 1;
        int numWidth = 0;
        int textColumn = 1;
        int textWidth = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String command = "set " + this.name();
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("default")) {
                useDefaultValue = false;
                try {
                    numColumn = Integer.parseInt(token);
                    if (!st.hasMoreTokens()) {
                        return CommandHandler.incomplete(view, command);
                    }
                    token = st.nextToken();
                    numWidth = Integer.parseInt(token);
                    if (st.hasMoreTokens()) {
                        token = st.nextToken();
                        textColumn = Integer.parseInt(token);
                        if (!st.hasMoreTokens()) {
                            return CommandHandler.incomplete(view, command);
                        }
                        token = st.nextToken();
                        textWidth = Integer.parseInt(token);
                    }
                    if (!SequenceNumbersParameter.validSequenceNumbers(numColumn, numWidth, textColumn, textWidth, view, command)) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, command);
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), command);
            }
        }
        if (view != null) {
            return this.setValue(view, numColumn, numWidth, textColumn, textWidth, useDefaultValue);
        }
        return true;
    }

    private boolean setValue(View view, int numColumn, int numWidth, int textColumn, int textWidth, boolean useDefaultValue) {
        Document document = view.document();
        if (document != null) {
            Settings settings = document.sequenceNumbersSettings();
            settings._numColumn = numColumn;
            settings._numWidth = numWidth;
            settings._textColumn = textColumn;
            settings._textWidth = textWidth;
            settings._useDefaultValue = useDefaultValue;
            this.currentValueChanged(view);
        }
        return true;
    }

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        boolean useInstallValue = true;
        int numColumn = 1;
        int numWidth = 0;
        int textColumn = 1;
        int textWidth = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String command = "set default." + this.name();
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("install")) {
                useInstallValue = false;
                try {
                    numColumn = Integer.parseInt(token);
                    if (!st.hasMoreTokens()) {
                        return CommandHandler.incomplete(view, command);
                    }
                    token = st.nextToken();
                    numWidth = Integer.parseInt(token);
                    if (st.hasMoreTokens()) {
                        token = st.nextToken();
                        textColumn = Integer.parseInt(token);
                        if (!st.hasMoreTokens()) {
                            return CommandHandler.incomplete(view, command);
                        }
                        token = st.nextToken();
                        textWidth = Integer.parseInt(token);
                    }
                    if (!SequenceNumbersParameter.validSequenceNumbers(numColumn, numWidth, textColumn, textWidth, view, command)) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, command);
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), command);
            }
        }
        return this.setDefaultValue(numColumn, numWidth, textColumn, textWidth, useInstallValue);
    }

    private void defaultValueChanged() {
        Document document = Document._firstDocument;
        while (document != null) {
            if (this.useDefaultValue(document)) {
                this.currentValueChanged(document._firstView);
            }
            document = document._next;
        }
    }

    private void currentValueChanged(View view) {
        Document document = view.document();
        if (document != null) {
            document.elementList().setSequenceNumbers(view, this.currentNumColumn(document), this.currentNumWidth(document), this.currentTextColumn(document), this.currentTextWidth(document));
        }
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            Document document = view.document();
            if (this.useDefaultValue(document)) {
                return "default";
            }
            StringBuilder value = new StringBuilder();
            value.append(this.numColumn(document)).append(' ').append(this.numWidth(document)).append(' ').append(this.textColumn(document)).append(' ').append(this.textWidth(document));
            return value.toString();
        }
        return null;
    }

    private boolean useDefaultValue(Document document) {
        return document == null ? true : document.sequenceNumbersSettings()._useDefaultValue;
    }

    private int numColumn(Document document) {
        return document == null ? 1 : document.sequenceNumbersSettings()._numColumn;
    }

    private int textColumn(Document document) {
        return document == null ? 1 : document.sequenceNumbersSettings()._textColumn;
    }

    private int numWidth(Document document) {
        return document == null ? 0 : document.sequenceNumbersSettings()._numWidth;
    }

    private int textWidth(Document document) {
        return document == null ? 0 : document.sequenceNumbersSettings()._textWidth;
    }

    @Override
    String queryInstall(String qualifier) {
        StringBuilder inst = new StringBuilder();
        inst.append(this.installNumColumn()).append(' ').append(this.installNumWidth()).append(' ').append(this.installTextColumn()).append(' ').append(this.installTextWidth());
        return inst.toString();
    }

    @Override
    String queryDefault(String qualifier) {
        if (this.useInstallValue()) {
            return "install";
        }
        StringBuilder dflt = new StringBuilder();
        dflt.append(this.defaultNumColumn()).append(' ').append(this.defaultNumWidth()).append(' ').append(this.defaultTextColumn()).append(' ').append(this.defaultTextWidth());
        return dflt.toString();
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        Document document = view != null ? view.document() : null;
        StringBuilder curr = new StringBuilder();
        curr.append(this.currentNumColumn(document)).append(' ').append(this.currentNumWidth(document)).append(' ').append(this.currentTextColumn(document)).append(' ').append(this.currentTextWidth(document));
        return curr.toString();
    }

    static boolean validSequenceNumbers(int numColumn, int numWidth, int textColumn, int textWidth, View view, String command) {
        if (numColumn < 1) {
            return CommandHandler.invalidParameter(view, String.valueOf(numColumn), command);
        }
        if (numWidth < 0 || numWidth > 9) {
            return CommandHandler.invalidParameter(view, String.valueOf(numWidth), command);
        }
        if (textColumn < 1) {
            return CommandHandler.invalidParameter(view, String.valueOf(textColumn), command);
        }
        if (textWidth < 0 || textWidth > 9) {
            return CommandHandler.invalidParameter(view, String.valueOf(textWidth), command);
        }
        if (numWidth != 0 && textWidth != 0) {
            boolean valid;
            boolean bl = numColumn < textColumn ? numColumn + numWidth == textColumn : (valid = textColumn + textWidth == numColumn);
            if (!valid) {
                if (view != null) {
                    view.setLpexMessageText("sequenceNumbers.notContiguous", command);
                }
                return false;
            }
        }
        return true;
    }

    static final class Settings {
        boolean _useDefaultValue = true;
        int _numColumn = 1;
        int _numWidth = 0;
        int _textColumn = 1;
        int _textWidth = 0;

        Settings() {
        }
    }
}

