/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.ParameterWordDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;
import java.io.Writer;

final class SaveCommand {
    static final int INVALID = 0;
    static final int BYTE_ORDER_MARK = 1;
    static final int ENFORCE_TEXT_LIMIT = 2;
    static final int LINE_SEPARATOR = 3;
    static final int TEXT_LIMIT = 4;
    static final int TRIM = 5;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("bom", 1), new TableNode("byteOrderMark", 1), new TableNode("enforceTextLimit", 2), new TableNode("lineSeparator", 3), new TableNode("textLimit", 4), new TableNode("trim", 5)};

    static {
        TableNode.sort(_parameters);
    }

    SaveCommand() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return ByteOrderMarkParameter.getParameter();
                }
                case 2: {
                    return EnforceTextLimitParameter.getParameter();
                }
                case 3: {
                    return LineSeparatorParameter.getParameter();
                }
                case 4: {
                    return TextLimitParameter.getParameter();
                }
                case 5: {
                    return TrimParameter.getParameter();
                }
            }
        }
        return null;
    }

    static boolean doCommand(View view, String parameters) {
        String eol = LineSeparatorParameter.getParameter().currentEol(view);
        boolean trim = TrimParameter.getParameter().currentValue(view);
        int textLimit = TextLimitParameter.getParameter().currentValue(view);
        String fileName = null;
        String fileEncoding = null;
        boolean prompt = false;
        boolean visible = false;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("prompt")) {
                prompt = true;
                continue;
            }
            if (token.equalsIgnoreCase("visible")) {
                visible = true;
                continue;
            }
            if (token.equalsIgnoreCase("trim")) {
                trim = true;
                continue;
            }
            if (token.equalsIgnoreCase("noTrim")) {
                trim = false;
                continue;
            }
            if (token.equalsIgnoreCase("textLimit")) {
                if (!st.hasMoreTokens()) {
                    return CommandHandler.integerMissing(view, "textLimit", "save");
                }
                token = st.nextToken();
                try {
                    textLimit = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "save");
                }
                if (textLimit >= 0) continue;
                return CommandHandler.invalidParameter(view, token, "save");
            }
            if (token.equalsIgnoreCase("encoding")) {
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, "save");
                }
                fileEncoding = st.nextToken();
                if (LpexNls.isValidEncoding(fileEncoding)) continue;
                return CommandHandler.invalidParameter(view, fileEncoding, "save");
            }
            if (token.equalsIgnoreCase("lineSeparator")) {
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, "save");
                }
                eol = st.nextToken();
                if ("CRLF".equalsIgnoreCase(eol)) {
                    eol = "\r\n";
                    continue;
                }
                if ("LF".equalsIgnoreCase(eol)) {
                    eol = "\n";
                    continue;
                }
                if ("CR".equalsIgnoreCase(eol)) {
                    eol = "\r";
                    continue;
                }
                return CommandHandler.invalidParameter(view, eol, "save");
            }
            if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                return CommandHandler.invalidQuotedParameter(view, token, "save");
            }
            fileName = LpexStringTokenizer.trimQuotes(token);
            if (!st.hasMoreTokens()) break;
            return CommandHandler.invalidParameter(view, st.nextToken(), "save");
        }
        if (view != null) {
            CommandHandler.setStatus(null);
            if (fileName == null || fileName.length() == 0) {
                fileName = view.document().name();
            }
            if (prompt || fileName == null) {
                fileName = LpexUtilities.fileDialog(view, LpexResources.message("fileDialog.saveAs"), true, fileName);
            }
            if (fileName != null) {
                view.save(null, fileName, fileEncoding, visible, eol, trim, textLimit);
            } else {
                CommandHandler.setStatus("save.cancelled");
            }
        }
        return true;
    }

    static void saveToWriter(View view) {
        if (view != null) {
            Writer writer = view.getSaveWriter();
            if (writer == null) {
                view.commandHandler().doCommand("save");
            } else {
                view.save(writer, null, null, false, LineSeparatorParameter.getParameter().currentEol(view), TrimParameter.getParameter().currentValue(view), TextLimitParameter.getParameter().currentValue(view));
            }
        }
    }

    static final class ByteOrderMarkParameter
    extends ParameterWordDefault {
        private static ByteOrderMarkParameter _parameter;

        static ByteOrderMarkParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ByteOrderMarkParameter();
            }
            return _parameter;
        }

        private ByteOrderMarkParameter() {
            super("save.byteOrderMark", null);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean isAcceptableValue(String value) {
            return "asis".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.document().saveCommandSettings()._byteOrderMark = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.document().saveCommandSettings()._byteOrderMark : null;
        }
    }

    static final class EnforceTextLimitParameter
    extends ParameterOnOffDefault {
        private static EnforceTextLimitParameter _parameter;

        static EnforceTextLimitParameter getParameter() {
            if (_parameter == null) {
                _parameter = new EnforceTextLimitParameter();
            }
            return _parameter;
        }

        private EnforceTextLimitParameter() {
            super("save.enforceTextLimit", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.setEnforceTextLimit(value);
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.enforceTextLimit() : 2;
        }
    }

    static final class LineSeparatorParameter
    extends ParameterWordDefault {
        private static LineSeparatorParameter _parameter;

        static LineSeparatorParameter getParameter() {
            if (_parameter == null) {
                _parameter = new LineSeparatorParameter();
            }
            return _parameter;
        }

        private LineSeparatorParameter() {
            super("save.lineSeparator", null);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean isAcceptableValue(String value) {
            return "CRLF".equalsIgnoreCase(value) || "LF".equalsIgnoreCase(value) || "CR".equalsIgnoreCase(value);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.document().saveCommandSettings()._lineSeparator = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.document().saveCommandSettings()._lineSeparator : null;
        }

        String currentEol(View view) {
            String eol = this.currentValue(view);
            if ("CRLF".equalsIgnoreCase(eol)) {
                return "\r\n";
            }
            if ("LF".equalsIgnoreCase(eol)) {
                return "\n";
            }
            if ("CR".equalsIgnoreCase(eol)) {
                return "\r";
            }
            return null;
        }
    }

    static final class Settings {
        int _trim = 2;
        int _textLimit;
        boolean _useDefaultTextLimit = true;
        String _lineSeparator;
        String _byteOrderMark;

        Settings() {
        }
    }

    static final class TextLimitParameter
    extends ParameterIntegerDefault {
        private static TextLimitParameter _parameter;

        static TextLimitParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TextLimitParameter();
            }
            return _parameter;
        }

        private TextLimitParameter() {
            super("save.textLimit", 0);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.document().saveCommandSettings();
                settings._textLimit = value;
                settings._useDefaultTextLimit = useDefaultValue;
                this.currentValueChanged(view);
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            if (view != null) {
                view.document().elementList().setTextLimit(view, this.currentValue(view));
            }
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.document().saveCommandSettings()._useDefaultTextLimit : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.document().saveCommandSettings()._textLimit : 0;
        }
    }

    static final class TrimParameter
    extends ParameterOnOffDefault {
        private static TrimParameter _parameter;

        static TrimParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TrimParameter();
            }
            return _parameter;
        }

        private TrimParameter() {
            super("save.trim", true);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.document().saveCommandSettings()._trim = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.document().saveCommandSettings()._trim : 2;
        }
    }
}

