/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.View;
import java.io.Writer;

final class SaveAsHtmlCommand {
    SaveAsHtmlCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        return SaveAsHtmlCommand.doCommand(view, null, parameters);
    }

    static boolean doCommand(View view, Writer writer, String parameters) {
        Object fileName = null;
        boolean prompt = false;
        boolean visible = false;
        boolean block = false;
        boolean lineNumbers = false;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("prompt")) {
                prompt = true;
                continue;
            }
            if (token.equalsIgnoreCase("visible")) {
                visible = true;
                continue;
            }
            if (token.equalsIgnoreCase("block") || token.equalsIgnoreCase("selection")) {
                block = true;
                continue;
            }
            if (token.equalsIgnoreCase("lineNumbers")) {
                lineNumbers = true;
                continue;
            }
            if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                return CommandHandler.invalidQuotedParameter(view, token, "saveAsHtml");
            }
            fileName = LpexStringTokenizer.trimQuotes(token);
            if (!st.hasMoreTokens()) break;
            return CommandHandler.invalidParameter(view, st.nextToken(), "saveAsHtml");
        }
        if (view != null) {
            boolean addHtmlSuffix = false;
            CommandHandler.setStatus(null);
            if (fileName == null || ((String)fileName).length() == 0) {
                fileName = view.document().name();
                addHtmlSuffix = true;
            }
            if (prompt || fileName == null) {
                fileName = LpexUtilities.fileDialog(view, LpexResources.message("fileDialog.saveAs"), true, (String)fileName);
                addHtmlSuffix = false;
            }
            if (fileName != null) {
                if (addHtmlSuffix) {
                    fileName = (String)fileName + ".html";
                }
                view.saveAsHtml((String)fileName, visible, block, lineNumbers);
            } else {
                CommandHandler.setStatus("save.cancelled");
            }
        }
        return true;
    }
}

