/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.FormatLine;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.ParameterOnOffOnly;
import com.ibm.lpex.core.SequenceNumbersParameter;
import com.ibm.lpex.core.View;

final class RealColumnNumbersParameter
extends ParameterOnOffOnly {
    private static RealColumnNumbersParameter _parameter;

    static RealColumnNumbersParameter getParameter() {
        if (_parameter == null) {
            _parameter = new RealColumnNumbersParameter();
        }
        return _parameter;
    }

    private RealColumnNumbersParameter() {
        super("realColumnNumbers");
    }

    @Override
    boolean setValue(View view, String qualifier, boolean value) {
        if (view != null) {
            view._realColumnNumbers = value;
            if (view.window() != null && view.window().formatLine() instanceof FormatLine) {
                FormatLine line = (FormatLine)view.window().formatLine();
                line.invalidateFormat();
                line.redraw();
            }
            if (view.lpexView().parser() != null) {
                view.lpexView().parser().totalParse();
            }
        }
        return true;
    }

    @Override
    boolean value(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view._realColumnNumbers;
    }

    public static int getRealColumnNumber(View view, int effectiveColumnNumber) {
        if (!view._realColumnNumbers) {
            return effectiveColumnNumber;
        }
        SequenceNumbersParameter parm = SequenceNumbersParameter.getParameter();
        int numColumn = parm.currentNumColumn(view.document());
        if (numColumn > 1) {
            return effectiveColumnNumber;
        }
        int numWidth = parm.currentNumWidth(view.document());
        int textWidth = parm.currentTextWidth(view.document());
        int totalWidth = numWidth + textWidth;
        return effectiveColumnNumber + totalWidth;
    }

    public static int getEffectiveColumnNumber(View view, int realColumnNumber) {
        int textWidth;
        if (!view._realColumnNumbers) {
            return realColumnNumber;
        }
        SequenceNumbersParameter parm = SequenceNumbersParameter.getParameter();
        int numColumn = parm.currentNumColumn(view.document());
        if (numColumn > 1) {
            return realColumnNumber;
        }
        int numWidth = parm.currentNumWidth(view.document());
        int totalWidth = numWidth + (textWidth = parm.currentTextWidth(view.document()));
        int effective = realColumnNumber - totalWidth;
        if (effective < 1) {
            effective = 0;
        }
        return effective;
    }
}

