/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

final class ProfileCommand {
    ProfileCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        String fileName = null;
        boolean prompt = false;
        boolean importing = false;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "profile");
        }
        String token = st.nextToken();
        if (token.equalsIgnoreCase("flush")) {
            Profile.flush();
            return true;
        }
        if (token.equalsIgnoreCase("import")) {
            importing = true;
        } else if (!token.equalsIgnoreCase("export")) {
            return CommandHandler.invalidParameter(view, token, "profile");
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equalsIgnoreCase("prompt")) {
                prompt = true;
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if (token != null) {
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "profile");
                }
                fileName = LpexStringTokenizer.trimQuotes(token);
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "profile");
                }
            }
        }
        CommandHandler.setStatus(null);
        if (prompt || fileName == null) {
            if (view == null) {
                return true;
            }
            if (fileName == null) {
                fileName = LpexStringTokenizer.removeQuotes(Profile.getString("importExportProfile"));
            }
            if (fileName == null) {
                fileName = "Profile.properties";
            }
            fileName = LpexUtilities.fileDialog(view, LpexResources.message(importing ? "fileDialog.importProfile" : "fileDialog.exportProfile"), true, fileName);
        }
        if (fileName == null) {
            CommandHandler.setStatus(importing ? "import.cancelled" : "save.cancelled");
        } else {
            boolean success;
            boolean bl = success = importing ? Profile.importProfile(fileName) : Profile.exportProfile(fileName);
            if (success) {
                Profile.putString("importExportProfile", LpexStringTokenizer.addQuotes(fileName));
            } else {
                if (view != null) {
                    view.setLpexMessageText(importing ? "file.errorReading" : "file.errorWriting", fileName);
                }
                CommandHandler.setStatus(importing ? "file.errorReading" : "save.failed");
            }
        }
        return true;
    }
}

