/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.DefaultProfile;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.ProfileHandler;

final class Profile {
    private static ProfileHandler _profileHandler;
    private static List _listeners;

    static {
        _listeners = new List();
    }

    private Profile() {
    }

    static void setProfileHandler(ProfileHandler profileHandler) {
        _profileHandler = profileHandler;
        Profile.profileChanged();
    }

    static void profileChanged() {
        List.Node node = _listeners.first();
        while (node != null) {
            ((ProfileListenerNode)node).listener().profileChanged();
            node = node.next();
        }
    }

    private static ProfileHandler profileHandler() {
        if (_profileHandler == null) {
            _profileHandler = new DefaultProfile();
        }
        return _profileHandler;
    }

    static String name() {
        return Profile.profileHandler().name();
    }

    static boolean setName(String name) {
        return Profile.profileHandler().setName(name);
    }

    static boolean importProfile(String fileName) {
        return Profile.profileHandler().importProfile(fileName);
    }

    static boolean exportProfile(String fileName) {
        return Profile.profileHandler().exportProfile(fileName);
    }

    static void resetProfile() {
        Profile.profileHandler().resetProfile();
    }

    static String getString(String key) {
        return Profile.profileHandler().getString(key);
    }

    static void putString(String key, String value) {
        Profile.profileHandler().putString(key, value);
    }

    static void remove(String key) {
        Profile.profileHandler().remove(key);
    }

    static void flush() {
        Profile.profileHandler().flush();
    }

    static String getKeys() {
        return Profile.profileHandler().getKeys();
    }

    static void addProfileChangedListener(ProfileChangedListener listener) {
        _listeners.addAfter(null, new ProfileListenerNode(listener));
    }

    static interface ProfileChangedListener {
        public void profileChanged();
    }

    private static class ProfileListenerNode
    extends ListNode {
        private ProfileChangedListener _listener;

        ProfileListenerNode(ProfileChangedListener listener) {
            this._listener = listener;
        }

        ProfileChangedListener listener() {
            return this._listener;
        }
    }
}

