/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.PrintCommand;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;

final class ProcessPrefixCommand {
    static final String PREFIX_MARK_NAME = "ProcessPrefix";
    private static String _skeleton;
    private static int _skeletonPosition;
    private static FinalCursor finalCursor;
    private static List pending;
    private static List pendingUnpaired;
    private static final char TURKISH_DOTLESS_I = '\u0131';
    private static final int PROFILE_INVALID = 0;
    private static final int PROFILE_SEU = 1;
    private static final int PROFILE_XEDIT = 2;
    private static final int PROFILE_ISPF = 3;
    private static final int SEU_INVALID = 0;
    private static final int SEU_LOCATE = 1;
    private static final int SEU_SCROLL_DOWN = 2;
    private static final int SEU_SCROLL_UP = 3;
    private static final int SEU_CURRENT = 4;
    private static final int SEU_AFTER = 5;
    private static final int SEU_BEFORE = 6;
    private static final int SEU_DELETE = 7;
    private static final int SEU_BLOCK_DELETE = 8;
    private static final int SEU_INSERT = 9;
    private static final int SEU_INSERT_SKELETON = 10;
    private static final int SEU_SHIFT_LEFT = 11;
    private static final int SEU_BLOCK_SHIFT_LEFT = 12;
    private static final int SEU_BLOCK_SHIFT_LEFT_TRUNCATE = 13;
    private static final int SEU_PRINT = 14;
    private static final int SEU_BLOCK_PRINT = 15;
    private static final int SEU_SHIFT_LEFT_TRUNCATE = 16;
    private static final int SEU_OVERLAY = 17;
    private static final int SEU_BLOCK_OVERLAY = 18;
    private static final int SEU_SHIFT_RIGHT = 19;
    private static final int SEU_REPEAT = 20;
    private static final int SEU_BLOCK_REPEAT = 21;
    private static final int SEU_BLOCK_SHIFT_RIGHT = 22;
    private static final int SEU_BLOCK_SHIFT_RIGHT_TRUNCATE = 23;
    private static final int SEU_SHIFT_RIGHT_TRUNCATE = 24;
    private static final int SEU_SKELETON = 25;
    private static final int SEU_SHOW_FIRST = 26;
    private static final int SEU_SHOW_LAST = 27;
    private static final int SEU_WINDOW = 28;
    private static final int SEU_EXCLUDE = 29;
    private static final int SEU_BLOCK_EXCLUDE = 30;
    private static final int SEU_PENDING = 31;
    private static final TableNode[] _seuCommands;
    private static final int XEDIT_INVALID = 0;
    private static final int XEDIT_DUPLICATE = 1;
    private static final int XEDIT_BLOCK_DUPLICATE = 2;
    private static final int XEDIT_SHIFT_LEFT_TRUNCATE = 3;
    private static final int XEDIT_BLOCK_SHIFT_LEFT_TRUNCATE = 4;
    private static final int XEDIT_SHIFT_RIGHT_TRUNCATE = 5;
    private static final int XEDIT_BLOCK_SHIFT_RIGHT_TRUNCATE = 6;
    private static final int XEDIT_CURRENT = 7;
    private static final int XEDIT_SHIFT_LEFT = 8;
    private static final int XEDIT_BLOCK_SHIFT_LEFT = 9;
    private static final int XEDIT_SHIFT_RIGHT = 10;
    private static final int XEDIT_BLOCK_SHIFT_RIGHT = 11;
    private static final int XEDIT_ADD = 12;
    private static final int XEDIT_DELETE = 13;
    private static final int XEDIT_BLOCK_DELETE = 14;
    private static final int XEDIT_FOLLOWING = 15;
    private static final int XEDIT_INSERT = 16;
    private static final int XEDIT_PREVIOUS = 17;
    private static final int XEDIT_SHOW = 18;
    private static final int XEDIT_SHOW_ALL = 19;
    private static final int XEDIT_SHOW_FIRST = 20;
    private static final int XEDIT_SHOW_LAST = 21;
    private static final int XEDIT_EXCLUDE = 22;
    private static final int XEDIT_EXCLUDE_ALL = 23;
    private static final int XEDIT_BLOCK_EXCLUDE = 24;
    private static final int XEDIT_PENDING = 25;
    private static final TableNode[] _xeditCommands;
    private static final int ISPF_INVALID = 0;
    private static final int ISPF_SHIFT_LEFT_TRUNCATE = 1;
    private static final int ISPF_BLOCK_SHIFT_LEFT_TRUNCATE = 2;
    private static final int ISPF_SHIFT_RIGHT_TRUNCATE = 3;
    private static final int ISPF_BLOCK_SHIFT_RIGHT_TRUNCATE = 4;
    private static final int ISPF_CURRENT = 5;
    private static final int ISPF_SHIFT_LEFT = 6;
    private static final int ISPF_BLOCK_SHIFT_LEFT = 7;
    private static final int ISPF_SHIFT_RIGHT = 8;
    private static final int ISPF_BLOCK_SHIFT_RIGHT = 9;
    private static final int ISPF_AFTER = 10;
    private static final int ISPF_BEFORE = 11;
    private static final int ISPF_DELETE = 12;
    private static final int ISPF_BLOCK_DELETE = 13;
    private static final int ISPF_SHOW_FIRST = 14;
    private static final int ISPF_INSERT = 15;
    private static final int ISPF_SHOW_LAST = 16;
    private static final int ISPF_LOWER_CASE = 17;
    private static final int ISPF_BLOCK_LOWER_CASE = 18;
    private static final int ISPF_OVERLAY = 19;
    private static final int ISPF_BLOCK_OVERLAY = 20;
    private static final int ISPF_DUPLICATE = 21;
    private static final int ISPF_BLOCK_DUPLICATE = 22;
    private static final int ISPF_SHOW = 23;
    private static final int ISPF_UPPER_CASE = 24;
    private static final int ISPF_BLOCK_UPPER_CASE = 25;
    private static final int ISPF_EXCLUDE = 26;
    private static final int ISPF_BLOCK_EXCLUDE = 27;
    private static final int ISPF_PENDING = 28;
    private static final TableNode[] _ispfCommands;
    private static final int PROCESS_CONTINUE = 1;
    private static final int PROCESS_RESTART = 2;
    private static final int PROCESS_QUIT = 3;
    static final int PRIORITY_LOW = 0;
    static final int PRIORITY_HIGH = 1;

    static {
        finalCursor = new FinalCursor();
        pending = new List();
        pendingUnpaired = new List();
        _seuCommands = new TableNode[]{new TableNode("", 1), new TableNode("+", 2), new TableNode("-", 3), new TableNode("/", 4), new TableNode("a", 5), new TableNode("b", 6), new TableNode("c", 31), new TableNode("cc", 31), new TableNode("d", 7), new TableNode("dd", 8), new TableNode("i", 9), new TableNode("is", 10), new TableNode("l", 11), new TableNode("ll", 12), new TableNode("llp", 15), new TableNode("llt", 13), new TableNode("lp", 14), new TableNode("lt", 16), new TableNode("m", 31), new TableNode("mm", 31), new TableNode("o", 17), new TableNode("oo", 18), new TableNode("r", 19), new TableNode("rp", 20), new TableNode("rpp", 21), new TableNode("rr", 22), new TableNode("rrt", 23), new TableNode("rt", 24), new TableNode("s", 25), new TableNode("sf", 26), new TableNode("sl", 27), new TableNode("w", 28), new TableNode("x", 29), new TableNode("xx", 30), new TableNode(String.valueOf('\u0131'), 9)};
        TableNode.sort(_seuCommands);
        _xeditCommands = new TableNode[]{new TableNode("\"", 1), new TableNode("\"\"", 2), new TableNode("(", 3), new TableNode("((", 4), new TableNode(")", 5), new TableNode("))", 6), new TableNode("/", 7), new TableNode("<", 8), new TableNode("<<", 9), new TableNode(">", 10), new TableNode(">>", 11), new TableNode("a", 12), new TableNode("c", 25), new TableNode("cc", 25), new TableNode("d", 13), new TableNode("dd", 14), new TableNode("f", 15), new TableNode("i", 16), new TableNode("m", 25), new TableNode("mm", 25), new TableNode("p", 17), new TableNode("s", 18), new TableNode("s*", 19), new TableNode("s+", 20), new TableNode("s-", 21), new TableNode("x", 22), new TableNode("x*", 23), new TableNode("xx", 24), new TableNode(String.valueOf('\u0131'), 16)};
        TableNode.sort(_xeditCommands);
        _ispfCommands = new TableNode[]{new TableNode("(", 1), new TableNode("((", 2), new TableNode(")", 3), new TableNode("))", 4), new TableNode("/", 5), new TableNode("<", 6), new TableNode("<<", 7), new TableNode(">", 8), new TableNode(">>", 9), new TableNode("a", 10), new TableNode("b", 11), new TableNode("c", 28), new TableNode("cc", 28), new TableNode("d", 12), new TableNode("dd", 13), new TableNode("f", 14), new TableNode("i", 15), new TableNode("l", 16), new TableNode("lc", 17), new TableNode("lcc", 18), new TableNode("m", 28), new TableNode("mm", 28), new TableNode("o", 19), new TableNode("oo", 20), new TableNode("r", 21), new TableNode("rr", 22), new TableNode("s", 23), new TableNode("uc", 24), new TableNode("ucc", 25), new TableNode("x", 26), new TableNode("xx", 27), new TableNode(String.valueOf('\u0131'), 15)};
        TableNode.sort(_ispfCommands);
    }

    ProcessPrefixCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        PendingNode node;
        int status;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        int profile = 0;
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("seu")) {
                profile = 1;
            } else if (token.equalsIgnoreCase("ispf")) {
                profile = 3;
            } else if (token.equalsIgnoreCase("xedit")) {
                profile = 2;
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "processPrefix");
            }
        }
        if (view == null || profile == 0) {
            return true;
        }
        finalCursor.reset(view);
        do {
            pending.clear();
            pendingUnpaired.clear();
            status = 1;
            Element element = ProcessPrefixCommand.firstPrefix(view);
            while (element != null && status == 1) {
                String prefixText = element.elementView(view).prefixText();
                switch (profile) {
                    case 1: {
                        status = ProcessPrefixCommand.processSEU(view, element, prefixText);
                        break;
                    }
                    case 2: {
                        status = ProcessPrefixCommand.processXEDIT(view, element, prefixText);
                        break;
                    }
                    case 3: {
                        status = ProcessPrefixCommand.processISPF(view, element, prefixText);
                        break;
                    }
                }
                element = ProcessPrefixCommand.nextPrefix(view, element);
            }
        } while (status == 2);
        if (status != 3) {
            finalCursor.positionCursor();
        }
        if ((node = (PendingNode)pendingUnpaired.first()) == null) {
            node = (PendingNode)pending.first();
        }
        if (node == null) {
            view.screen().setPendingCommand(null, null);
        } else {
            view.screen().setPendingCommand(node._element, node._command);
        }
        pending.clear();
        pendingUnpaired.clear();
        return true;
    }

    private static int processSEU(View view, Element element, String prefixText) {
        String command = ProcessPrefixCommand.command(prefixText);
        int count = ProcessPrefixCommand.count(prefixText);
        TableNode tableNode = TableNode.binarySearch(_seuCommands, command);
        int commandId = tableNode != null ? tableNode.id() : 0;
        switch (commandId) {
            case 1: {
                if (count > 0) {
                    Element e = view.document().elementList().nonShowElementAt(count);
                    view.documentPosition().jump(e, 1);
                }
                element.elementView(view).setPrefixText(null);
                break;
            }
            case 2: {
                if (count == -1) {
                    count = 1;
                }
                view.documentPosition().scrollDown(count);
                element.elementView(view).setPrefixText(null);
                break;
            }
            case 3: {
                if (count == -1) {
                    count = 1;
                }
                view.documentPosition().scrollUp(count);
                element.elementView(view).setPrefixText(null);
                break;
            }
            case 4: {
                if (count != -1) break;
                view.screen().setCursorRow(1);
                view.documentPosition().jump(element, 1);
                element.elementView(view).setPrefixText(null);
                break;
            }
            case 5: 
            case 6: {
                return ProcessPrefixCommand.targetSEU(view, element, command, count);
            }
            case 7: {
                return ProcessPrefixCommand.deleteElements(view, element, count);
            }
            case 8: {
                if (count != -1) break;
                return ProcessPrefixCommand.deleteBlock(view, element);
            }
            case 9: {
                return ProcessPrefixCommand.insert(view, element, count, null, 1, 1);
            }
            case 10: {
                return ProcessPrefixCommand.insert(view, element, count, _skeleton, _skeletonPosition, 0);
            }
            case 11: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, -count, false);
                break;
            }
            case 12: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, -count, command, false);
            }
            case 13: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, -count, command, true);
            }
            case 14: {
                if (count == -1) {
                    count = 1;
                }
                Element endElement = element;
                while (count > 1 && endElement != null) {
                    endElement = endElement.nextVisible(view);
                    --count;
                }
                element.elementView(view).setPrefixText(null);
                PrintCommand.doCommand(view, "visible startElement " + view.document().elementList().ordinalOf(element) + " endElement " + view.document().elementList().ordinalOf(endElement));
                break;
            }
            case 15: {
                if (count != -1) break;
                Element endElement = ProcessPrefixCommand.nextPrefix(view, element);
                while (endElement != null) {
                    prefixText = endElement.elementView(view).prefixText();
                    if ("llp".equals(ProcessPrefixCommand.command(prefixText)) && ProcessPrefixCommand.count(prefixText) == -1) {
                        element.elementView(view).setPrefixText(null);
                        endElement.elementView(view).setPrefixText(null);
                        PrintCommand.doCommand(view, "visible startElement " + view.document().elementList().ordinalOf(element) + " endElement " + view.document().elementList().ordinalOf(endElement));
                        return 1;
                    }
                    endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
                }
                ProcessPrefixCommand.setPendingUnpaired(element, "llp");
                break;
            }
            case 16: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, -count, true);
                break;
            }
            case 17: 
            case 18: {
                return ProcessPrefixCommand.targetSEU(view, element, command, count);
            }
            case 19: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, count, false);
                break;
            }
            case 20: {
                ProcessPrefixCommand.duplicateElement(view, element, count);
                break;
            }
            case 21: {
                ProcessPrefixCommand.duplicateBlock(view, element, count, "rpp");
                break;
            }
            case 22: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, count, command, false);
            }
            case 23: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, count, command, true);
            }
            case 24: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, count, true);
                break;
            }
            case 25: {
                if (count != -1) break;
                element.elementView(view).setPrefixText(null);
                _skeleton = element.text();
                _skeletonPosition = view.documentPosition().element() == element ? view.documentPosition().position() : 1;
                break;
            }
            case 26: {
                return ProcessPrefixCommand.showFirst(view, element, count);
            }
            case 27: {
                return ProcessPrefixCommand.showLast(view, element, count);
            }
            case 28: {
                if (count == -1) {
                    count = 1;
                }
                element.elementView(view).setPrefixText(null);
                view.documentPosition().home();
                if (--count <= 0) break;
                view.documentPosition().scrollRight(count * view.screen().textFontMetrics().spaceWidth());
                break;
            }
            case 29: {
                ProcessPrefixCommand.excludeCount(view, count, element);
                break;
            }
            case 30: {
                ProcessPrefixCommand.excludeBlock(view, count, element);
                break;
            }
            case 31: {
                ProcessPrefixCommand.setPending(element, command);
                break;
            }
        }
        return 1;
    }

    private static int targetSEU(View view, Element targetElement, String targetCommand, int targetCount) {
        if (targetCount == -1) {
            targetCount = 1;
        } else if (targetCommand.equalsIgnoreCase("oo")) {
            return 1;
        }
        if (!view.changeAllowed()) {
            view.documentPosition().jump(targetElement, 1);
            view.setInPrefix(true);
            return 3;
        }
        Element endTargetElement = null;
        if (targetCommand.equalsIgnoreCase("oo")) {
            endTargetElement = ProcessPrefixCommand.nextPrefix(view, targetElement);
            while (endTargetElement != null) {
                String prefixText = endTargetElement.elementView(view).prefixText();
                if ("oo".equals(ProcessPrefixCommand.command(prefixText)) && ProcessPrefixCommand.count(prefixText) == -1) break;
                endTargetElement = ProcessPrefixCommand.nextPrefix(view, endTargetElement);
            }
            if (endTargetElement == null) {
                ProcessPrefixCommand.setPendingUnpaired(targetElement, "oo");
                return 1;
            }
        } else if (targetCommand.equalsIgnoreCase("o")) {
            endTargetElement = targetElement;
            int i = 1;
            while (i < targetCount) {
                Element nextVisible = endTargetElement.nextVisible(view);
                if (nextVisible == null) break;
                endTargetElement = nextVisible;
                ++i;
            }
        }
        boolean after = targetCommand.equalsIgnoreCase("a");
        boolean overlay = targetCommand.equalsIgnoreCase("oo") || targetCommand.equalsIgnoreCase("o");
        DocumentPosition.Preserve preserve = null;
        StringBuilder sourceText = null;
        int sourceCount = 0;
        Element element = ProcessPrefixCommand.firstPrefix(view);
        while (element != null && sourceText == null) {
            String prefixText = element.elementView(view).prefixText();
            String command = ProcessPrefixCommand.command(prefixText);
            int count = ProcessPrefixCommand.count(prefixText);
            if (command.equalsIgnoreCase("c") || command.equalsIgnoreCase("cr") || command.equalsIgnoreCase("m")) {
                boolean move = command.equalsIgnoreCase("m");
                if (count == -1) {
                    count = 1;
                }
                if (move && count > 1) {
                    Element sourceElement = element;
                    int i = count;
                    while (i > 0 && sourceElement != null) {
                        if (sourceElement == targetElement) {
                            view.documentPosition().jump(targetElement, 1);
                            view.setInPrefix(true);
                            return 3;
                        }
                        --i;
                        sourceElement = sourceElement.nextVisible(view);
                    }
                }
                targetElement.elementView(view).setPrefixText(null);
                if (targetCommand.equalsIgnoreCase("oo") && endTargetElement != null) {
                    endTargetElement.elementView(view).setPrefixText(null);
                }
                if (move || command.equalsIgnoreCase("c")) {
                    ProcessPrefixCommand.clearPrefix(view, element);
                }
                preserve = view.documentPosition().preserve();
                view.documentPosition().jump(targetElement, after ? targetElement.end() : 1);
                view.document().resetUserActionElements();
                sourceText = new StringBuilder();
                boolean first = true;
                while (count > 0 && element != null) {
                    if (!element.show()) {
                        ++sourceCount;
                        String text = element.text();
                        if (!first) {
                            sourceText.append('\n');
                        }
                        first = false;
                        sourceText.append(text);
                    }
                    Element nextElement = element.nextVisible(view);
                    if (move) {
                        if (element == endTargetElement) {
                            if (endTargetElement == targetElement) {
                                endTargetElement = null;
                                overlay = false;
                                after = true;
                            } else {
                                endTargetElement = element.prevVisible(view);
                            }
                        }
                        if (element == targetElement) {
                            if (overlay) {
                                targetElement = element.nextVisible(view);
                            } else if (element.next() != null) {
                                targetElement = element.next();
                                after = false;
                            } else {
                                targetElement = element.prev();
                                after = true;
                            }
                        }
                        view.deleteElement(element);
                    }
                    element = nextElement;
                    --count;
                }
                break;
            }
            if (count == -1 && (command.equalsIgnoreCase("cc") || command.equalsIgnoreCase("ccr") || command.equalsIgnoreCase("mm"))) {
                Element nextElement;
                ElementList elementList;
                int target;
                Element startElement = element;
                boolean retain = command.equalsIgnoreCase("ccr");
                boolean move = command.equalsIgnoreCase("mm");
                Element endElement = null;
                element = ProcessPrefixCommand.nextPrefix(view, element);
                while (element != null && endElement == null) {
                    prefixText = element.elementView(view).prefixText();
                    command = ProcessPrefixCommand.command(prefixText);
                    count = ProcessPrefixCommand.count(prefixText);
                    if (count == -1 && (move && command.equalsIgnoreCase("mm") || !move && (command.equalsIgnoreCase("cc") || command.equalsIgnoreCase("ccr")))) {
                        if (!retain) {
                            retain = command.equalsIgnoreCase("ccr");
                        }
                        endElement = element;
                    }
                    element = ProcessPrefixCommand.nextPrefix(view, element);
                }
                if (endElement == null) {
                    view.documentPosition().jump(startElement, 1);
                    view.setInPrefix(true);
                    ProcessPrefixCommand.setPendingUnpaired(startElement, move ? "mm" : (retain ? "ccr" : "cc"));
                    return 3;
                }
                if (move && (target = (elementList = view.document().elementList()).ordinalOf(targetElement)) > elementList.ordinalOf(startElement) && target < elementList.ordinalOf(endElement)) {
                    view.documentPosition().jump(targetElement, 1);
                    view.setInPrefix(true);
                    return 3;
                }
                targetElement.elementView(view).setPrefixText(null);
                if (targetCommand.equalsIgnoreCase("oo") && endTargetElement != null) {
                    endTargetElement.elementView(view).setPrefixText(null);
                }
                if (!retain) {
                    ProcessPrefixCommand.clearPrefix(view, startElement);
                    ProcessPrefixCommand.clearPrefix(view, endElement);
                }
                preserve = view.documentPosition().preserve();
                view.documentPosition().jump(targetElement, after ? targetElement.end() : 1);
                view.document().resetUserActionElements();
                sourceText = new StringBuilder();
                boolean first = true;
                element = startElement;
                endElement = endElement.nextVisible(view);
                do {
                    if (!element.show()) {
                        ++sourceCount;
                        String text = element.text();
                        if (!first) {
                            sourceText.append('\n');
                        }
                        first = false;
                        sourceText.append(text);
                    }
                    nextElement = element.nextVisible(view);
                    if (!move) continue;
                    if (element == endTargetElement) {
                        if (endTargetElement == targetElement) {
                            endTargetElement = null;
                            overlay = false;
                            after = true;
                        } else {
                            endTargetElement = element.prevVisible(view);
                        }
                    }
                    if (element == targetElement) {
                        if (overlay) {
                            targetElement = element.nextVisible(view);
                        } else if (element.next() != null) {
                            targetElement = element.next();
                            after = false;
                        } else {
                            targetElement = element.prev();
                            after = true;
                        }
                    }
                    view.deleteElement(element);
                } while ((element = nextElement) != endElement);
                break;
            }
            element = ProcessPrefixCommand.nextPrefix(view, element);
        }
        if (sourceText == null) {
            ProcessPrefixCommand.setPending(targetElement, targetCommand);
            return 1;
        }
        if (overlay) {
            ProcessPrefixCommand.overlayAtTarget(view, sourceText.toString(), sourceCount, targetElement, endTargetElement);
        } else {
            Element finalElement;
            if (after) {
                finalElement = view.documentPosition().element();
                view.documentPosition().end();
                view.setIgnoreFields();
                int i = 0;
                while (i < targetCount) {
                    view.insertText("\n" + sourceText.toString());
                    ++i;
                }
                view.resetIgnoreFields();
                finalElement = finalElement.nextVisible(view);
            } else {
                boolean forceAllVisible = view.setForceAllVisible(true);
                view.setIgnoreFields();
                finalElement = new Element(view.document());
                view.insertElementBefore(finalElement);
                view.insertText(sourceText.toString());
                int i = 0;
                while (i < targetCount - 1) {
                    view.insertText("\n" + sourceText.toString());
                    ++i;
                }
                view.resetIgnoreFields();
                view.setForceAllVisible(forceAllVisible);
            }
            finalCursor.setCursor(finalElement);
        }
        if (preserve != null) {
            preserve.restore();
            view.documentPosition().disposePreserve(preserve);
        }
        return 2;
    }

    private static int processXEDIT(View view, Element element, String prefixText) {
        String command = ProcessPrefixCommand.command(prefixText);
        int count = ProcessPrefixCommand.count(prefixText);
        TableNode tableNode = TableNode.binarySearch(_xeditCommands, command);
        int commandId = tableNode != null ? tableNode.id() : 0;
        switch (commandId) {
            case 1: {
                ProcessPrefixCommand.duplicateElement(view, element, count);
                break;
            }
            case 2: {
                ProcessPrefixCommand.duplicateBlock(view, element, count, "\"\"");
                break;
            }
            case 3: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, -count, true);
                break;
            }
            case 4: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, -count, command, true);
            }
            case 5: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, count, true);
                break;
            }
            case 6: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, count, command, true);
            }
            case 7: {
                if (count != -1) break;
                view.screen().setCursorRow(1);
                view.documentPosition().jump(element, 1);
                element.elementView(view).setPrefixText(null);
                break;
            }
            case 8: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, -count, false);
                break;
            }
            case 9: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, -count, command, false);
            }
            case 10: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, count, false);
                break;
            }
            case 11: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, count, command, false);
            }
            case 12: {
                return ProcessPrefixCommand.insert(view, element, count, null, 1, 1);
            }
            case 13: {
                return ProcessPrefixCommand.deleteElements(view, element, count);
            }
            case 14: {
                if (count != -1) break;
                return ProcessPrefixCommand.deleteBlock(view, element);
            }
            case 15: {
                if (count != -1) break;
                return ProcessPrefixCommand.targetXEDIT(view, element, true);
            }
            case 16: {
                return ProcessPrefixCommand.insert(view, element, count, null, 1, 1);
            }
            case 17: {
                if (count != -1) break;
                return ProcessPrefixCommand.targetXEDIT(view, element, false);
            }
            case 18: {
                return count == -1 ? ProcessPrefixCommand.show(view, element) : ProcessPrefixCommand.showFirst(view, element, count);
            }
            case 19: {
                if (count != -1) break;
                return ProcessPrefixCommand.show(view, element);
            }
            case 20: {
                return ProcessPrefixCommand.showFirst(view, element, count);
            }
            case 21: {
                return ProcessPrefixCommand.showLast(view, element, count);
            }
            case 22: {
                ProcessPrefixCommand.excludeCount(view, count, element);
                break;
            }
            case 23: {
                if (count != -1) break;
                element.elementView(view).setPrefixText(null);
                ProcessPrefixCommand.exclude(view, view.document().elementList().first(), view.document().elementList().last());
                break;
            }
            case 24: {
                ProcessPrefixCommand.excludeBlock(view, count, element);
                break;
            }
            case 25: {
                ProcessPrefixCommand.setPending(element, command);
                break;
            }
        }
        return 1;
    }

    private static int targetXEDIT(View view, Element targetElement, boolean after) {
        Element finalElement;
        if (!view.changeAllowed()) {
            view.documentPosition().jump(targetElement, 1);
            view.setInPrefix(true);
            return 3;
        }
        DocumentPosition.Preserve preserve = null;
        StringBuilder sourceText = null;
        Element element = ProcessPrefixCommand.firstPrefix(view);
        while (element != null && sourceText == null) {
            String prefixText = element.elementView(view).prefixText();
            String command = ProcessPrefixCommand.command(prefixText);
            int count = ProcessPrefixCommand.count(prefixText);
            if (command.equalsIgnoreCase("c") || command.equalsIgnoreCase("m")) {
                boolean move = command.equalsIgnoreCase("m");
                if (count == -1) {
                    count = 1;
                }
                if (move && count > 1) {
                    Element sourceElement = element;
                    int i = count;
                    while (i > 0 && sourceElement != null) {
                        if (sourceElement == targetElement) {
                            view.documentPosition().jump(targetElement, 1);
                            view.setInPrefix(true);
                            return 3;
                        }
                        --i;
                        sourceElement = sourceElement.nextVisible(view);
                    }
                }
                targetElement.elementView(view).setPrefixText(null);
                ProcessPrefixCommand.clearPrefix(view, element);
                preserve = view.documentPosition().preserve();
                view.documentPosition().jump(targetElement, after ? targetElement.end() : 1);
                view.document().resetUserActionElements();
                sourceText = new StringBuilder();
                boolean first = true;
                while (count > 0 && element != null) {
                    if (!element.show()) {
                        String text = element.text();
                        if (!first) {
                            sourceText.append('\n');
                        }
                        first = false;
                        sourceText.append(text);
                    }
                    Element nextElement = element.nextVisible(view);
                    if (move) {
                        if (element == targetElement) {
                            if (element.next() != null) {
                                targetElement = element.next();
                                after = false;
                            } else {
                                targetElement = element.prev();
                                after = true;
                            }
                        }
                        view.deleteElement(element);
                    }
                    element = nextElement;
                    --count;
                }
                break;
            }
            if (count == -1 && (command.equalsIgnoreCase("cc") || command.equalsIgnoreCase("mm"))) {
                Element nextElement;
                ElementList elementList;
                int target;
                Element startElement = element;
                boolean move = command.equalsIgnoreCase("mm");
                Element endElement = null;
                element = ProcessPrefixCommand.nextPrefix(view, element);
                while (element != null && endElement == null) {
                    prefixText = element.elementView(view).prefixText();
                    command = ProcessPrefixCommand.command(prefixText);
                    count = ProcessPrefixCommand.count(prefixText);
                    if (count == -1 && (move && command.equalsIgnoreCase("mm") || !move && command.equalsIgnoreCase("cc"))) {
                        endElement = element;
                    }
                    element = ProcessPrefixCommand.nextPrefix(view, element);
                }
                if (endElement == null) {
                    view.documentPosition().jump(startElement, 1);
                    view.setInPrefix(true);
                    ProcessPrefixCommand.setPendingUnpaired(startElement, move ? "mm" : "cc");
                    return 3;
                }
                if (move && (target = (elementList = view.document().elementList()).ordinalOf(targetElement)) > elementList.ordinalOf(startElement) && target < elementList.ordinalOf(endElement)) {
                    view.documentPosition().jump(targetElement, 1);
                    view.setInPrefix(true);
                    return 3;
                }
                targetElement.elementView(view).setPrefixText(null);
                ProcessPrefixCommand.clearPrefix(view, startElement);
                ProcessPrefixCommand.clearPrefix(view, endElement);
                preserve = view.documentPosition().preserve();
                view.documentPosition().jump(targetElement, after ? targetElement.end() : 1);
                view.document().resetUserActionElements();
                sourceText = new StringBuilder();
                boolean first = true;
                element = startElement;
                endElement = endElement.nextVisible(view);
                do {
                    if (!element.show()) {
                        String text = element.text();
                        if (!first) {
                            sourceText.append('\n');
                        }
                        first = false;
                        sourceText.append(text);
                    }
                    nextElement = element.nextVisible(view);
                    if (!move) continue;
                    if (element == targetElement) {
                        if (element.next() != null) {
                            targetElement = element.next();
                            after = false;
                        } else {
                            targetElement = element.prev();
                            after = true;
                        }
                    }
                    view.deleteElement(element);
                } while ((element = nextElement) != endElement);
                break;
            }
            element = ProcessPrefixCommand.nextPrefix(view, element);
        }
        if (sourceText == null) {
            ProcessPrefixCommand.setPending(targetElement, after ? "f" : "p");
            return 1;
        }
        if (after) {
            finalElement = view.documentPosition().element();
            view.documentPosition().end();
            view.insertText("\n" + sourceText.toString());
            finalElement = finalElement.nextVisible(view);
        } else {
            boolean forceAllVisible = view.setForceAllVisible(true);
            view.setIgnoreFields();
            finalElement = new Element(view.document());
            view.insertElementBefore(finalElement);
            view.insertText(sourceText.toString());
            view.resetIgnoreFields();
            view.setForceAllVisible(forceAllVisible);
        }
        finalCursor.setCursor(finalElement);
        if (preserve != null) {
            preserve.restore();
            view.documentPosition().disposePreserve(preserve);
        }
        return 2;
    }

    private static int processISPF(View view, Element element, String prefixText) {
        String command = ProcessPrefixCommand.command(prefixText);
        int count = ProcessPrefixCommand.count(prefixText);
        TableNode tableNode = TableNode.binarySearch(_ispfCommands, command);
        int commandId = tableNode != null ? tableNode.id() : 0;
        switch (commandId) {
            case 1: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, -count, true, true);
                break;
            }
            case 2: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, -count, command, true, true);
            }
            case 3: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, count, true, true);
                break;
            }
            case 4: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, count, command, true, true);
            }
            case 5: {
                if (count != -1) break;
                view.screen().setCursorRow(1);
                view.documentPosition().jump(element, 1);
                element.elementView(view).setPrefixText(null);
                break;
            }
            case 6: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, -count, false, true);
                break;
            }
            case 7: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, -count, command, false, true);
            }
            case 8: {
                if (count == -1) {
                    count = 1;
                }
                if (!view.changeAllowed()) break;
                view.document().resetUserActionElements();
                element.elementView(view).setPrefixText(null);
                view.shiftElement(element, count, false, true);
                break;
            }
            case 9: {
                if (count == -1) {
                    count = 1;
                }
                return ProcessPrefixCommand.shiftBlock(view, element, count, command, false, true);
            }
            case 10: 
            case 11: {
                return ProcessPrefixCommand.targetISPF(view, element, command, count, true);
            }
            case 12: {
                return ProcessPrefixCommand.deleteElements(view, element, count);
            }
            case 13: {
                if (count != -1) break;
                return ProcessPrefixCommand.deleteBlock(view, element);
            }
            case 14: {
                return ProcessPrefixCommand.showFirst(view, element, count);
            }
            case 15: {
                return ProcessPrefixCommand.insert(view, element, count, null, 1, 1);
            }
            case 16: {
                return ProcessPrefixCommand.showLast(view, element, count);
            }
            case 17: {
                if (!view.changeAllowed()) break;
                if (count == -1) {
                    count = 1;
                }
                element.elementView(view).setPrefixText(null);
                view.document().resetUserActionElements();
                while (count > 0 && element != null) {
                    view.changeCase(element, false);
                    element = element.nextVisible(view);
                    --count;
                }
                break;
            }
            case 18: {
                if (count != -1 || !view.changeAllowed()) break;
                Element endElement = ProcessPrefixCommand.nextPrefix(view, element);
                while (endElement != null) {
                    prefixText = endElement.elementView(view).prefixText();
                    if ("lcc".equals(ProcessPrefixCommand.command(prefixText)) && ProcessPrefixCommand.count(prefixText) == -1) {
                        view.document().resetUserActionElements();
                        element.elementView(view).setPrefixText(null);
                        endElement.elementView(view).setPrefixText(null);
                        endElement = endElement.nextVisible(view);
                        do {
                            view.changeCase(element, false);
                        } while ((element = element.nextVisible(view)) != endElement);
                        return 1;
                    }
                    endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
                }
                ProcessPrefixCommand.setPendingUnpaired(element, "lcc");
                break;
            }
            case 19: 
            case 20: {
                return ProcessPrefixCommand.targetISPF(view, element, command, count, true);
            }
            case 21: {
                ProcessPrefixCommand.duplicateElement(view, element, count);
                break;
            }
            case 22: {
                ProcessPrefixCommand.duplicateBlock(view, element, count, "rr");
                break;
            }
            case 23: {
                if (count != -1) break;
                return ProcessPrefixCommand.show(view, element);
            }
            case 24: {
                if (!view.changeAllowed()) break;
                if (count == -1) {
                    count = 1;
                }
                element.elementView(view).setPrefixText(null);
                view.document().resetUserActionElements();
                while (count > 0 && element != null) {
                    view.changeCase(element, true);
                    element = element.nextVisible(view);
                    --count;
                }
                return 1;
            }
            case 25: {
                if (count != -1 || !view.changeAllowed()) break;
                Element endElement = ProcessPrefixCommand.nextPrefix(view, element);
                while (endElement != null) {
                    prefixText = endElement.elementView(view).prefixText();
                    if ("ucc".equals(ProcessPrefixCommand.command(prefixText)) && ProcessPrefixCommand.count(prefixText) == -1 && count == -1 && command.equalsIgnoreCase("ucc")) {
                        view.document().resetUserActionElements();
                        element.elementView(view).setPrefixText(null);
                        endElement.elementView(view).setPrefixText(null);
                        endElement = endElement.nextVisible(view);
                        do {
                            view.changeCase(element, true);
                        } while ((element = element.nextVisible(view)) != endElement);
                        return 1;
                    }
                    endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
                }
                ProcessPrefixCommand.setPendingUnpaired(element, "ucc");
                break;
            }
            case 26: {
                ProcessPrefixCommand.excludeCount(view, count, element);
                break;
            }
            case 27: {
                ProcessPrefixCommand.excludeBlock(view, count, element);
                break;
            }
            case 28: {
                ProcessPrefixCommand.setPending(element, command);
                break;
            }
        }
        return 1;
    }

    private static int targetISPF(View view, Element targetElement, String targetCommand, int targetCount, boolean checkBounds) {
        if (targetCount == -1) {
            targetCount = 1;
        } else if (targetCommand.equalsIgnoreCase("oo")) {
            return 1;
        }
        if (!view.changeAllowed()) {
            view.documentPosition().jump(targetElement, 1);
            view.setInPrefix(true);
            return 3;
        }
        Element endTargetElement = null;
        if (targetCommand.equalsIgnoreCase("oo")) {
            endTargetElement = ProcessPrefixCommand.nextPrefix(view, targetElement);
            while (endTargetElement != null) {
                String prefixText = endTargetElement.elementView(view).prefixText();
                if ("oo".equals(ProcessPrefixCommand.command(prefixText)) && ProcessPrefixCommand.count(prefixText) == -1) break;
                endTargetElement = ProcessPrefixCommand.nextPrefix(view, endTargetElement);
            }
            if (endTargetElement == null) {
                ProcessPrefixCommand.setPendingUnpaired(targetElement, "oo");
                return 1;
            }
        } else if (targetCommand.equalsIgnoreCase("o")) {
            endTargetElement = targetElement;
            int i = 1;
            while (i < targetCount) {
                Element nextVisible = endTargetElement.nextVisible(view);
                if (nextVisible == null) break;
                endTargetElement = nextVisible;
                ++i;
            }
        }
        boolean after = targetCommand.equalsIgnoreCase("a");
        boolean overlay = targetCommand.equalsIgnoreCase("oo") || targetCommand.equalsIgnoreCase("o");
        DocumentPosition.Preserve preserve = null;
        StringBuilder sourceText = null;
        int sourceCount = 0;
        Element element = ProcessPrefixCommand.firstPrefix(view);
        while (element != null && sourceText == null) {
            String prefixText = element.elementView(view).prefixText();
            String command = ProcessPrefixCommand.command(prefixText);
            int count = ProcessPrefixCommand.count(prefixText);
            if (command.equalsIgnoreCase("c") || command.equalsIgnoreCase("m")) {
                boolean move = command.equalsIgnoreCase("m");
                if (count == -1) {
                    count = 1;
                }
                if (move && count > 1) {
                    Element sourceElement = element;
                    int i = count;
                    while (i > 0 && sourceElement != null) {
                        if (sourceElement == targetElement) {
                            view.documentPosition().jump(targetElement, 1);
                            view.setInPrefix(true);
                            return 3;
                        }
                        --i;
                        sourceElement = sourceElement.nextVisible(view);
                    }
                }
                targetElement.elementView(view).setPrefixText(null);
                if (targetCommand.equalsIgnoreCase("oo") && endTargetElement != null) {
                    endTargetElement.elementView(view).setPrefixText(null);
                }
                ProcessPrefixCommand.clearPrefix(view, element);
                preserve = view.documentPosition().preserve();
                view.documentPosition().jump(targetElement, after ? targetElement.end() : 1);
                view.document().resetUserActionElements();
                sourceText = new StringBuilder();
                boolean first = true;
                while (count > 0 && element != null) {
                    if (!element.show()) {
                        ++sourceCount;
                        String text = element.text();
                        if (!first) {
                            sourceText.append('\n');
                        }
                        first = false;
                        sourceText.append(text);
                    }
                    Element nextElement = element.nextVisible(view);
                    if (move) {
                        if (element == endTargetElement) {
                            if (endTargetElement == targetElement) {
                                endTargetElement = null;
                                overlay = false;
                                after = true;
                            } else {
                                endTargetElement = element.prevVisible(view);
                            }
                        }
                        if (element == targetElement) {
                            if (overlay) {
                                targetElement = element.nextVisible(view);
                            } else if (element.next() != null) {
                                targetElement = element.next();
                                after = false;
                            } else {
                                targetElement = element.prev();
                                after = true;
                            }
                        }
                        if (checkBounds && view.getBoundsStartCol() > 0 && view.getBoundsEndCol() > 0) {
                            Object lineText = element.text();
                            if (view.getBoundsStartCol() < ((String)lineText).length()) {
                                lineText = ((String)lineText).substring(0, view.getBoundsStartCol() - 1) + ((String)lineText).substring(Math.min(view.getBoundsEndCol(), ((String)lineText).length()));
                            }
                            if (((String)lineText).trim().length() == 0) {
                                view.deleteElement(element);
                            }
                        } else {
                            view.deleteElement(element);
                        }
                    }
                    element = nextElement;
                    --count;
                }
                break;
            }
            if (count == -1 && (command.equalsIgnoreCase("cc") || command.equalsIgnoreCase("mm"))) {
                Element nextElement;
                ElementList elementList;
                int target;
                Element startElement = element;
                boolean move = command.equalsIgnoreCase("mm");
                Element endElement = null;
                element = ProcessPrefixCommand.nextPrefix(view, element);
                while (element != null && endElement == null) {
                    prefixText = element.elementView(view).prefixText();
                    command = ProcessPrefixCommand.command(prefixText);
                    count = ProcessPrefixCommand.count(prefixText);
                    if (count == -1 && (move && command.equalsIgnoreCase("mm") || !move && command.equalsIgnoreCase("cc"))) {
                        endElement = element;
                    }
                    element = ProcessPrefixCommand.nextPrefix(view, element);
                }
                if (endElement == null) {
                    view.documentPosition().jump(startElement, 1);
                    view.setInPrefix(true);
                    ProcessPrefixCommand.setPendingUnpaired(startElement, move ? "mm" : "cc");
                    return 3;
                }
                if (move && (target = (elementList = view.document().elementList()).ordinalOf(targetElement)) > elementList.ordinalOf(startElement) && target < elementList.ordinalOf(endElement)) {
                    view.documentPosition().jump(targetElement, 1);
                    view.setInPrefix(true);
                    return 3;
                }
                targetElement.elementView(view).setPrefixText(null);
                if (targetCommand.equalsIgnoreCase("oo") && endTargetElement != null) {
                    endTargetElement.elementView(view).setPrefixText(null);
                }
                ProcessPrefixCommand.clearPrefix(view, startElement);
                ProcessPrefixCommand.clearPrefix(view, endElement);
                preserve = view.documentPosition().preserve();
                view.documentPosition().jump(targetElement, after ? targetElement.end() : 1);
                view.document().resetUserActionElements();
                sourceText = new StringBuilder();
                boolean first = true;
                element = startElement;
                endElement = endElement.nextVisible(view);
                do {
                    if (!element.show()) {
                        ++sourceCount;
                        String text = element.text();
                        if (!first) {
                            sourceText.append('\n');
                        }
                        first = false;
                        sourceText.append(text);
                    }
                    nextElement = element.nextVisible(view);
                    if (!move) continue;
                    if (element == endTargetElement) {
                        if (endTargetElement == targetElement) {
                            endTargetElement = null;
                            overlay = false;
                            after = true;
                        } else {
                            endTargetElement = element.prevVisible(view);
                        }
                    }
                    if (element == targetElement) {
                        if (overlay) {
                            targetElement = element.nextVisible(view);
                        } else if (element.next() != null) {
                            targetElement = element.next();
                            after = false;
                        } else {
                            targetElement = element.prev();
                            after = true;
                        }
                    }
                    view.deleteElement(element);
                } while ((element = nextElement) != endElement);
                break;
            }
            element = ProcessPrefixCommand.nextPrefix(view, element);
        }
        if (sourceText == null) {
            ProcessPrefixCommand.setPending(targetElement, targetCommand);
            return 1;
        }
        if (overlay) {
            ProcessPrefixCommand.overlayAtTarget(view, sourceText.toString(), sourceCount, targetElement, endTargetElement, checkBounds);
        } else {
            Element finalElement;
            if (after) {
                finalElement = view.documentPosition().element();
                view.documentPosition().end();
                boolean forceAllVisible = view.setForceAllVisible(true);
                view.setIgnoreFields();
                int i = 0;
                while (i < targetCount) {
                    view.insertText("\n" + sourceText.toString());
                    ++i;
                }
                view.resetIgnoreFields();
                view.setForceAllVisible(forceAllVisible);
                finalElement = finalElement.nextVisible(view);
            } else {
                boolean forceAllVisible = view.setForceAllVisible(true);
                view.setIgnoreFields();
                finalElement = new Element(view.document());
                view.insertElementBefore(finalElement);
                view.insertText(sourceText.toString());
                int i = 0;
                while (i < targetCount - 1) {
                    view.insertText("\n" + sourceText.toString());
                    ++i;
                }
                view.resetIgnoreFields();
                view.setForceAllVisible(forceAllVisible);
            }
            finalCursor.setCursor(finalElement);
        }
        if (preserve != null) {
            preserve.restore();
            view.documentPosition().disposePreserve(preserve);
        }
        return 2;
    }

    private static String command(String prefixText) {
        char c;
        StringBuilder prefix = new StringBuilder(prefixText.trim());
        StringBuilder command = new StringBuilder();
        StringBuilder number = new StringBuilder();
        boolean digitAtStart = true;
        while (prefix.length() > 0) {
            c = prefix.charAt(0);
            if (Character.isDigit(c)) break;
            digitAtStart = false;
            command.append(c);
            prefix.deleteCharAt(0);
        }
        while (prefix.length() > 0) {
            c = prefix.charAt(0);
            if (!Character.isDigit(c)) break;
            number.append(c);
            prefix.deleteCharAt(0);
        }
        if (!digitAtStart && prefix.length() != 0) {
            command.append((CharSequence)number);
        }
        command.append((CharSequence)prefix);
        return command.toString().trim().toLowerCase();
    }

    private static int count(String prefixText) {
        prefixText = prefixText.trim();
        boolean digitAtStart = true;
        while (prefixText.length() > 0) {
            char c = prefixText.charAt(0);
            if (Character.isDigit(c)) break;
            digitAtStart = false;
            prefixText = prefixText.substring(1);
        }
        StringBuilder number = new StringBuilder();
        while (prefixText.length() > 0) {
            char c = prefixText.charAt(0);
            if (!Character.isDigit(c)) break;
            number.append(c);
            prefixText = prefixText.substring(1);
        }
        if (number.length() > 0 && (digitAtStart || prefixText.length() == 0)) {
            try {
                return Integer.parseInt(number.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static int blockCount(int count1, int count2) {
        if (count2 == -1) {
            return count1;
        }
        return count1 > 0 ? Math.max(count1, count2) : Math.min(count1, -count2);
    }

    private static Element firstPrefix(View view) {
        String prefixText;
        Element element = view.document().elementList().firstVisible(view);
        if (element != null && ((prefixText = element.elementView(view).prefixText()) == null || prefixText.length() == 0)) {
            element = ProcessPrefixCommand.nextPrefix(view, element);
        }
        return element;
    }

    private static Element nextPrefix(View view, Element element) {
        element = element.nextVisible(view);
        while (element != null) {
            String prefixText = element.elementView(view).prefixText();
            if (prefixText != null && prefixText.length() > 0) {
                return element;
            }
            element = element.nextVisible(view);
        }
        return null;
    }

    private static String nextMarkName(View view) {
        int i = 0;
        while (true) {
            String markName = PREFIX_MARK_NAME + String.valueOf(i);
            if (view.markList().find(markName) == null) {
                return markName;
            }
            ++i;
        }
    }

    private static void excludeCount(View view, int count, Element element) {
        Element end;
        if (count == -1) {
            count = 1;
        }
        Element endElement = end = element;
        while (count > 1 && end != null) {
            if ((end = end.nextVisible(view)) != null) {
                endElement = end;
            }
            --count;
        }
        element.elementView(view).setPrefixText(null);
        ProcessPrefixCommand.exclude(view, element, endElement);
    }

    private static void excludeBlock(View view, int count, Element element) {
        if (count == -1) {
            Element endElement = ProcessPrefixCommand.nextPrefix(view, element);
            while (endElement != null) {
                String prefixText = endElement.elementView(view).prefixText();
                if ("xx".equals(ProcessPrefixCommand.command(prefixText)) && ProcessPrefixCommand.count(prefixText) == -1) {
                    element.elementView(view).setPrefixText(null);
                    endElement.elementView(view).setPrefixText(null);
                    ProcessPrefixCommand.exclude(view, element, endElement);
                    return;
                }
                endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
            }
            ProcessPrefixCommand.setPendingUnpaired(element, "xx");
        }
    }

    private static void exclude(View view, Element element1, Element element2) {
        MarkList.Mark mark;
        if (element1 != null && element1.prev() != null) {
            ElementView.MarkNode markNode = element1.prev().elementView((View)view)._firstMarkNode;
            while (markNode != null) {
                MarkList.Mark mark2 = markNode.mark();
                if (mark2.excluded() && mark2.name().startsWith(PREFIX_MARK_NAME)) {
                    element1 = mark2.element1();
                    ElementList elementList = view.document().elementList();
                    if (elementList.ordinalOf(element2) < elementList.ordinalOf(mark2.element2())) {
                        element2 = mark2.element2();
                    }
                    mark2.clear();
                }
                markNode = markNode._next;
            }
        }
        Element nextElement = null;
        Element element = element1 != null && element1.prev() != null ? element1.prev() : element1;
        while (element != null && element != element2.next()) {
            nextElement = element.next();
            mark = view.markList().headerMark(element);
            if (mark != null && mark.name().startsWith(PREFIX_MARK_NAME)) {
                ElementList elementList;
                if (element1 == element) {
                    element1 = nextElement;
                }
                if ((elementList = view.document().elementList()).ordinalOf(element2) < elementList.ordinalOf(mark.element2())) {
                    element2 = mark.element2();
                }
                mark.clear();
            }
            element = nextElement;
        }
        if (element2 != null && element2.next() != null && (mark = view.markList().headerMark(element2.next())) != null && mark.name().startsWith(PREFIX_MARK_NAME)) {
            element2 = mark.element2();
            mark.clear();
        }
        if (element1 != null && element2 != null) {
            mark = view.markList().set(ProcessPrefixCommand.nextMarkName(view), element1, element2, false);
            mark.setExcluded(true);
            mark.setExcludedHeader(true);
            Element end = element2.next();
            Element e = element1;
            while (e != end) {
                String command;
                ElementView elementView = e.elementView(view);
                String prefixText = elementView.prefixText();
                if (prefixText != null && prefixText.length() > 0 && ("x".equals(command = ProcessPrefixCommand.command(prefixText)) || "xx".equals(command) || "x*".equals(command))) {
                    elementView.setPrefixText(null);
                }
                e = e.next();
            }
        }
    }

    static void coalesceExcludes(View view, Element prev, Element next) {
        String baseProfile = view.baseProfile();
        if ("ispf".equals(baseProfile) || "seu".equals(baseProfile) || "xedit".equals(baseProfile)) {
            ProcessPrefixCommand.doCoalesceExcludes(view, prev, next);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doCoalesceExcludes(View view, Element prev, Element next) {
        element = prev != null ? prev : view.document().elementList().first();
        while (element != null && element != next) {
            mark1 = ProcessPrefixCommand.getExclude(view, element);
            if (mark1 != null) ** GOTO lbl20
            element = element.next();
            continue;
lbl-1000:
            // 1 sources

            {
                element = mark1.element2().next();
                mark2 = ProcessPrefixCommand.getExclude(view, element);
                if (mark2 != null) {
                    mark = view.markList().set(ProcessPrefixCommand.nextMarkName(view), mark1.element1(), mark2.element2(), false);
                    mark.setExcluded(true);
                    mark.setExcludedHeader(true);
                    mark1.clear();
                    mark2.clear();
                    mark1 = mark;
                    continue;
                }
                if (element != null && element != next && next != null && (elementList = view.document().elementList()).ordinalOf(element) > elementList.ordinalOf(next)) {
                    return;
                }
                mark1 = null;
lbl20:
                // 3 sources

                ** while (mark1 != null)
            }
lbl21:
            // 1 sources

        }
    }

    private static MarkList.Mark getExclude(View view, Element element) {
        if (element != null) {
            MarkList.Mark mark = view.markList().headerMark(element);
            if (mark != null && mark.name().startsWith(PREFIX_MARK_NAME)) {
                return mark;
            }
            ElementView.MarkNode markNode = element.elementView((View)view)._firstMarkNode;
            while (markNode != null) {
                mark = markNode.mark();
                if (mark.excluded() && mark.name().startsWith(PREFIX_MARK_NAME)) {
                    return mark;
                }
                markNode = markNode._next;
            }
        }
        return null;
    }

    private static int insert(View view, Element element, int count, String text, int finalCursorPosition, int finalCursorPriority) {
        if (view.changeAllowed()) {
            if (count == -1) {
                count = 1;
            }
            ElementView elementView = element.elementView(view);
            view.document().resetUserActionElements();
            elementView.setPrefixText(null);
            DocumentPosition.Preserve preserve = view.documentPosition().preserve();
            view.documentPosition().jump(element, 1);
            elementView.setExpanded(true);
            finalCursorPosition = ProcessPrefixCommand.findIndentPosition(element, view, finalCursorPosition);
            boolean first = true;
            while (count > 0) {
                Element newElement = new Element(view.document(), text);
                view.insertElement(newElement);
                --count;
                if (!first) continue;
                first = false;
                finalCursor.setCursor(newElement, finalCursorPosition, finalCursorPriority);
            }
            preserve.restore();
            view.documentPosition().disposePreserve(preserve);
            return 1;
        }
        view.documentPosition().jump(element, 1);
        view.setInPrefix(true);
        return 3;
    }

    private static int findIndentPosition(Element element, View view, int finalCursorPosition) {
        if (element != null && !element.show() && !view.markList().protect(element) && view.changeAllowed()) {
            int i;
            int desiredIndentPosition = 1;
            Element prevElement = element.prevNonShow();
            while (prevElement != null) {
                String p = prevElement.text();
                if (p.trim().length() > 0) {
                    i = 0;
                    while (p.charAt(i) == ' ' || p.charAt(i) == '\t') {
                        ++i;
                    }
                    desiredIndentPosition = view.displayColumn(prevElement.elementView(view), i + 1);
                    break;
                }
                prevElement = prevElement.prevNonShow();
            }
            String t = element.text();
            i = 0;
            while (i < t.length() && (t.charAt(i) == ' ' || t.charAt(i) == '\t')) {
                ++i;
            }
            int indentPosition = view.displayColumn(element.elementView(view), i + 1);
            finalCursorPosition = indentPosition != desiredIndentPosition && t.equals("") ? desiredIndentPosition : indentPosition;
        }
        return finalCursorPosition;
    }

    private static int deleteElements(View view, Element element, int count) {
        if (view.changeAllowed()) {
            if (count == -1) {
                count = 1;
            }
            ElementView elementView = element.elementView(view);
            elementView.setPrefixText(null);
            view.document().resetUserActionElements();
            Element beforeFirst = element.prev();
            Element preVisible = element.prevVisible(view);
            Element nextElement = null;
            while (count > 0 && element != null) {
                nextElement = element.next();
                view.deleteElement(element);
                element = nextElement;
                --count;
            }
            if (preVisible == null) {
                if (!view.topExpanded()) {
                    view.setTopExpanded(true);
                }
            } else if (preVisible.elementView(view).expandHideHeader()) {
                preVisible.elementView(view).setExpanded(true);
            }
            ProcessPrefixCommand.doCoalesceExcludes(view, beforeFirst, nextElement);
            return 2;
        }
        return 1;
    }

    private static int deleteBlock(View view, Element firstElement) {
        if (view.changeAllowed()) {
            Element endElement = ProcessPrefixCommand.nextPrefix(view, firstElement);
            while (endElement != null) {
                String prefixText = endElement.elementView(view).prefixText();
                if (ProcessPrefixCommand.command(prefixText).equalsIgnoreCase("dd") && ProcessPrefixCommand.count(prefixText) == -1) {
                    view.document().resetUserActionElements();
                    firstElement.prev();
                    firstElement.elementView(view).setPrefixText(null);
                    endElement.elementView(view).setPrefixText(null);
                    view.block().deleteElements(view, firstElement, endElement);
                    return 2;
                }
                endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
            }
            ProcessPrefixCommand.setPendingUnpaired(firstElement, "dd");
        }
        return 1;
    }

    private static void duplicateElement(View view, Element element, int count) {
        if (count == -1) {
            count = 1;
        }
        if (view.changeAllowed()) {
            element.elementView(view).setPrefixText(null);
            view.document().resetUserActionElements();
            Object text = element.text();
            text = "\n" + (String)text;
            DocumentPosition.Preserve preserve = view.documentPosition().preserve();
            view.documentPosition().jump(element, element.end());
            boolean forceAllVisible = view.setForceAllVisible(true);
            view.setIgnoreFields();
            boolean first = true;
            while (count > 0) {
                view.insertText((String)text);
                --count;
                if (!first) continue;
                first = false;
                finalCursor.setCursor(view.documentPosition().element());
            }
            view.resetIgnoreFields();
            view.setForceAllVisible(forceAllVisible);
            preserve.restore();
            view.documentPosition().disposePreserve(preserve);
        }
    }

    private static void duplicateBlock(View view, Element element, int count, String blockCommand) {
        if (count == -1) {
            count = 1;
        }
        if (view.changeAllowed()) {
            Element endElement = ProcessPrefixCommand.nextPrefix(view, element);
            while (endElement != null) {
                String prefixText = endElement.elementView(view).prefixText();
                String command = ProcessPrefixCommand.command(prefixText);
                if (command.equals(blockCommand)) {
                    count = ProcessPrefixCommand.blockCount(count, ProcessPrefixCommand.count(prefixText));
                    view.document().resetUserActionElements();
                    element.elementView(view).setPrefixText(null);
                    endElement.elementView(view).setPrefixText(null);
                    StringBuilder sourceText = new StringBuilder(512);
                    do {
                        if (element.show()) continue;
                        sourceText.append('\n').append(element.text());
                    } while ((element = element.nextVisible(view)) != endElement.next());
                    DocumentPosition.Preserve preserve = view.documentPosition().preserve();
                    view.documentPosition().jump(endElement, endElement.end());
                    boolean forceAllVisible = view.setForceAllVisible(true);
                    String text = sourceText.toString();
                    while (count > 0) {
                        view.insertText(text);
                        --count;
                    }
                    finalCursor.setCursor(endElement.nextVisible(view));
                    view.setForceAllVisible(forceAllVisible);
                    preserve.restore();
                    view.documentPosition().disposePreserve(preserve);
                    return;
                }
                endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
            }
            ProcessPrefixCommand.setPendingUnpaired(element, blockCommand);
        }
    }

    private static void overlayAtTarget(View view, String sourceText, int sourceCount, Element targetElement, Element endTargetElement) {
        ProcessPrefixCommand.overlayAtTarget(view, sourceText, sourceCount, targetElement, endTargetElement, false);
    }

    private static void overlayAtTarget(View view, String sourceText, int sourceCount, Element targetElement, Element endTargetElement, boolean checkBounds) {
        int overlayCount = 0;
        Element stopElement = endTargetElement.nextVisible(view);
        Element element = targetElement;
        while (element != stopElement) {
            if (!element.show()) {
                ++overlayCount;
            }
            element = element.nextVisible(view);
        }
        if (targetElement.show()) {
            targetElement = targetElement.nextVisibleNonShow(view);
        }
        Element nextOverlayElement = targetElement;
        finalCursor.setCursor(targetElement);
        while (overlayCount > 0 && nextOverlayElement != null) {
            view.documentPosition().jump(nextOverlayElement, 1);
            if (overlayCount >= sourceCount) {
                nextOverlayElement = view.overlayElements(sourceText, true, checkBounds);
                overlayCount -= sourceCount;
                continue;
            }
            view.overlayElements(sourceText, true, overlayCount, checkBounds);
            break;
        }
    }

    private static int shiftBlock(View view, Element element, int count, String command, boolean truncate) {
        return ProcessPrefixCommand.shiftBlock(view, element, count, command, truncate, false);
    }

    private static int shiftBlock(View view, Element element, int count, String command, boolean truncate, boolean checkBounds) {
        if (view.changeAllowed()) {
            Element endElement = ProcessPrefixCommand.nextPrefix(view, element);
            while (endElement != null) {
                String prefixText = endElement.elementView(view).prefixText();
                if (command.equals(ProcessPrefixCommand.command(prefixText))) {
                    count = ProcessPrefixCommand.blockCount(count, ProcessPrefixCommand.count(prefixText));
                    view.document().resetUserActionElements();
                    element.elementView(view).setPrefixText(null);
                    endElement.elementView(view).setPrefixText(null);
                    endElement = endElement.nextVisible(view);
                    do {
                        view.shiftElement(element, count, truncate, checkBounds);
                    } while ((element = element.nextVisible(view)) != endElement);
                    return 1;
                }
                endElement = ProcessPrefixCommand.nextPrefix(view, endElement);
            }
            ProcessPrefixCommand.setPendingUnpaired(element, command);
        }
        return 1;
    }

    private static int showFirst(View view, Element element, int count) {
        MarkList.Mark mark = view.markList().headerMark(element);
        if (mark != null && mark.name().startsWith(PREFIX_MARK_NAME)) {
            if (count == -1) {
                count = 1;
            }
            element = mark.element1();
            Element element2 = mark.element2();
            while (count > 0 && element != element2.next()) {
                if (!element.show()) {
                    --count;
                }
                element = element.next();
            }
            if (element != element2.next()) {
                mark.clear();
                ProcessPrefixCommand.exclude(view, element, element2);
            } else {
                mark.clear();
            }
        }
        return 1;
    }

    private static int showLast(View view, Element element, int count) {
        MarkList.Mark mark = view.markList().headerMark(element);
        if (mark != null && mark.name().startsWith(PREFIX_MARK_NAME)) {
            if (count == -1) {
                count = 1;
            }
            Element element1 = mark.element1();
            element = mark.element2();
            while (count > 0 && element != element1.prev()) {
                if (!element.show()) {
                    --count;
                }
                element = element.prev();
            }
            if (element != element1.prev()) {
                mark.clear();
                ProcessPrefixCommand.exclude(view, element1, element);
            } else {
                mark.clear();
            }
        }
        return 1;
    }

    private static int show(View view, Element element) {
        MarkList.Mark mark = view.markList().headerMark(element);
        if (mark != null && mark.name().startsWith(PREFIX_MARK_NAME)) {
            mark.clear();
        }
        return 1;
    }

    static void restorePrefix(View view) {
        Element element = view.document().elementList().first();
        while (element != null) {
            element.elementView(view).setPrefixText(null);
            Element next = element.next();
            ProcessPrefixCommand.show(view, element);
            element = next;
        }
    }

    static void clearPrefix(View view, Element element) {
        element.elementView(view).setPrefixText(null);
        List.Node pendingNode = ProcessPrefixCommand.findPendingNode(pending, element);
        if (pendingNode != null) {
            pending.remove(pendingNode);
        }
    }

    static void setPending(Element element, String command) {
        if (ProcessPrefixCommand.findPendingNode(pending, element) == null) {
            pending.addBefore(null, new PendingNode(element, command));
        }
    }

    static void setPendingUnpaired(Element element, String command) {
        if (ProcessPrefixCommand.findPendingNode(pendingUnpaired, element) == null) {
            pendingUnpaired.addBefore(null, new PendingNode(element, command));
        }
    }

    static List.Node findPendingNode(List list, Element element) {
        List.Node current = list.first();
        while (current != null) {
            if (((PendingNode)current)._element == element) {
                return current;
            }
            current = current.next();
        }
        return null;
    }

    static void locatePendingCommand(LpexView lpexView) {
        View view = lpexView._view;
        Element element = view.screen().pendingElement();
        if (element != null) {
            boolean keepPending = false;
            if (element._partOfList) {
                view.ensureVisible(element);
                view.documentPosition().jump(element, 1);
                view.setInPrefix(true);
                if (view.window() != null) {
                    view.window().textWindowRequestFocus();
                }
                keepPending = true;
            }
            if (!keepPending) {
                view.screen().setPendingCommand(null, null);
            }
            lpexView.doCommand("screenShow view");
        }
    }

    private static final class FinalCursor {
        View _view;
        Element _element;
        int _position;
        int _priority;

        private FinalCursor() {
        }

        void reset(View view) {
            this._view = view;
            this._element = null;
            this._position = 1;
        }

        void setCursor(Element element) {
            this.setCursor(element, 1, 0);
        }

        void setCursor(Element element, int position, int priority) {
            if (element != null) {
                if (this._element == null) {
                    this._element = element;
                    this._position = position;
                    this._priority = priority;
                } else if (priority > this._priority) {
                    this._element = element;
                    this._position = position;
                    this._priority = priority;
                }
            }
        }

        void positionCursor() {
            if (this._element != null) {
                this._view.documentPosition().jump(this._element, this._position, true, false);
                this._view.setInPrefix(false);
            }
        }
    }

    private static class PendingNode
    extends ListNode {
        Element _element;
        String _command;

        PendingNode(Element element, String command) {
            this._element = element;
            this._command = command;
        }
    }
}

