/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CompareCommand;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesParameter;
import com.ibm.lpex.core.View;

final class PrintLine {
    private Element _element;
    private int _compareFlag;
    private View view;
    private Element _startElement;
    private Element _stopElement;
    private boolean _visible;
    private boolean _compare;
    private boolean _mismatch;
    private int _mismatchState;
    private int[] _mismatchHeader;
    private Element _mismatchStartElement;
    private Element _mismatchStopElement;
    private static final int NONE = 0;
    private static final int ADDED = 1;
    private static final int DELETED = 2;
    private static final int LF = 0;
    private static final int HEADER = 1;
    private static final int ELEMENTS = 2;
    private String _styleAddedLines;
    private String _styleDeletedLines;

    PrintLine(View viewArg, Element startElement, Element stopElement, boolean visible, boolean compare) {
        this.view = viewArg;
        this._visible = visible;
        this._compare = compare;
        this._startElement = startElement;
        this._stopElement = stopElement;
        if (this._compare) {
            this._element = this._startElement;
            StyleAttributesParameter p = StyleAttributesParameter.getParameter();
            this._styleAddedLines = p.query(this.view, "addedLines");
            this._styleDeletedLines = p.query(this.view, "deletedLines");
            String toBground = StyleAttributes.background(this.view);
            p.set(this.view, "addedLines", StyleAttributes.convert("-1 -1 -1 255 255 255", "255 255 255", toBground));
            p.set(this.view, "deletedLines", StyleAttributes.convert("-1 -1 -1 255 255 255", "255 255 255", toBground));
        }
    }

    boolean next() {
        block10: {
            block11: {
                if (!this._compare) break block10;
                this._compareFlag = 0;
                if (!this._mismatch) break block11;
                if (this._mismatchState == 0) {
                    this._mismatchState = 1;
                    return true;
                }
                if (this._mismatchState == 1) {
                    this._mismatchState = 2;
                    this._element = null;
                }
                this._element = this._element == null ? this._mismatchStartElement : this._element.next();
                while (this._element != this._mismatchStopElement && this._element != this._stopElement) {
                    block12: {
                        block13: {
                            block14: {
                                if (this._visible && !this._element.visible(this.view)) break block12;
                                ElementView.MarkNode markNode = this._element.elementView((View)this.view)._firstMarkNode;
                                while (markNode != null && !(markNode.mark() instanceof CompareCommand.CompareMark)) {
                                    markNode = markNode._next;
                                }
                                if (markNode == null) break block13;
                                MarkList.Mark mark = markNode.mark();
                                if (!(mark instanceof CompareCommand.AddedLines)) break block14;
                                if (!this._visible && this._element.show()) break block12;
                                this._compareFlag = 1;
                                break block13;
                            }
                            if (!this._visible && this.view.markList().headerMark(this._element) != null) break block12;
                            this._compareFlag = 2;
                        }
                        return true;
                    }
                    this._element = this._element.next();
                }
            }
            this._mismatch = this.findMismatch();
            if (this._mismatch) {
                this._mismatchState = 0;
                return true;
            }
            this.dispose();
            return false;
        }
        this._element = this._element == null ? this._startElement : this._element.next();
        while (this._element != this._stopElement) {
            if (!this._visible && !this._element.show() || this._visible && this._element.visible(this.view)) {
                return true;
            }
            this._element = this._element.next();
        }
        return false;
    }

    private void dispose() {
        StyleAttributesParameter p = StyleAttributesParameter.getParameter();
        p.set(this.view, "addedLines", this._styleAddedLines);
        p.set(this.view, "deletedLines", this._styleDeletedLines);
    }

    private boolean findMismatch() {
        Element element = this._element;
        while (element != null && element != this._stopElement) {
            MarkList.Mark mark = this.isMismatchElement(element);
            if (mark != null) {
                this._mismatchHeader = new int[4];
                if (mark instanceof CompareCommand.DeletedLines) {
                    MarkList.Mark mark2;
                    this._mismatchHeader[0] = this.mismatchFirstLine(mark);
                    this._mismatchHeader[1] = this.mismatchCount(mark);
                    Element element2 = this._mismatchStopElement = mark._element2 != null ? mark._element2.next() : null;
                    if (this._mismatchStopElement != null && (mark2 = this.isMismatchElement(this._mismatchStopElement)) instanceof CompareCommand.AddedLines) {
                        this._mismatchHeader[2] = this.mismatchFirstLine(mark2);
                        this._mismatchHeader[3] = this.mismatchCount(mark2);
                        this._mismatchStopElement = mark2._element2 != null ? mark2._element2.next() : null;
                    }
                } else {
                    this._mismatchHeader[2] = this.mismatchFirstLine(mark);
                    this._mismatchHeader[3] = this.mismatchCount(mark);
                    this._mismatchStopElement = mark._element2 != null ? mark._element2.next() : null;
                }
                this._mismatchStartElement = element;
                return true;
            }
            element = element.next();
        }
        return false;
    }

    private MarkList.Mark isMismatchElement(Element element) {
        ElementView.MarkNode markNode = element.elementView((View)this.view)._firstMarkNode;
        while (markNode != null && !(markNode.mark() instanceof CompareCommand.CompareMark)) {
            markNode = markNode._next;
        }
        return markNode != null ? markNode.mark() : null;
    }

    private int mismatchFirstLine(MarkList.Mark mark) {
        return mark instanceof CompareCommand.DeletedLines ? ((CompareCommand.DeletedLines)mark).firstLine() : this.view.document().elementList().nonShowOrdinalOf(mark._element1);
    }

    private int mismatchCount(MarkList.Mark mark) {
        if (mark instanceof CompareCommand.DeletedLines) {
            return ((CompareCommand.DeletedLines)mark).count();
        }
        int count = 0;
        Element stopElement = mark._element2 != null ? mark._element2.next() : null;
        Element element = mark._element1;
        while (element != stopElement) {
            if (!element.show()) {
                ++count;
            }
            element = element.next();
        }
        return count;
    }

    String comparePrefix() {
        return this._compareFlag == 1 ? "+ " : (this._compareFlag == 2 ? "- " : "  ");
    }

    String lineNumbersText() {
        String lineNum = null;
        if (!this._compare || this._mismatchState == 2 && this._compareFlag != 2) {
            lineNum = this.view.lineNumbersText(this._element);
        }
        return lineNum;
    }

    String sequenceNumbersText() {
        String seqNum = null;
        if (!this._compare || this._mismatchState == 2) {
            seqNum = this.view.document().elementList().getSequenceNumbersDisplayString(this._element, this.view);
        }
        return seqNum;
    }

    String text() {
        String text = null;
        if (!this._compare || this._mismatchState == 2) {
            text = this._element.elementView(this.view).displayText();
        } else if (this._mismatchState == 1) {
            StringBuilder header = new StringBuilder("@@");
            if (this._mismatchHeader[0] != 0) {
                header.append(" -").append(this._mismatchHeader[0]).append(',').append(this._mismatchHeader[1]);
            }
            if (this._mismatchHeader[2] != 0) {
                header.append(" +").append(this._mismatchHeader[2]).append(',').append(this._mismatchHeader[3]);
            }
            text = header.append(" @@").toString();
        }
        return text;
    }

    String style() {
        String style = null;
        if (!this._compare || this._mismatchState == 2) {
            style = this._element.elementView(this.view).displayStyle().foreground();
        }
        return style;
    }
}

