/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.ParameterWordsDefault;
import com.ibm.lpex.core.View;

final class PopupParameter
extends ParameterWordsDefault {
    private static PopupParameter _parameter;
    private static final String EDIT_LINE_ITEM = "popup.hexEditLine hexEditLine ";
    private static final String SOURCE_SUBMENU = "beginSubmenu popup.sourceMenu separator endSubmenu";
    static final String INSERT_BIDI_ITEMS = " popup.insertLrm insertLtrMark popup.insertRlm insertRtlMark";
    private static final String VISUAL_EDIT_ITEM = " popup.visualEditLine visualEditLine";
    private static final String COMPARE_SUBMENU = " beginSubmenu popup.compareMenu popup.compareRefresh compareRefresh popup.compareNext compareNext popup.comparePrevious comparePrevious separator popup.compareLeadingBlanks compareLeadingBlanks popup.compareTrailingBlanks compareTrailingBlanks popup.compareAllBlanks compareAllBlanks popup.compareCase compareCase popup.compareComments compareComments popup.compareSequenceNumbers compareSequenceNumbers separator popup.comparePrint printCompare separator popup.compareClear compareClear endSubmenu separator";

    static PopupParameter getParameter() {
        if (_parameter == null) {
            _parameter = new PopupParameter();
        }
        return _parameter;
    }

    private PopupParameter() {
        super("popup", null);
    }

    @Override
    boolean setValue(View view, String value) {
        if (view != null) {
            view.setPopup(value);
        }
        return true;
    }

    @Override
    String installValue() {
        int i;
        Object installValue = super.installValue();
        if (LpexUtilities.getPlatform() == 0 && (i = ((String)installValue).indexOf(EDIT_LINE_ITEM)) >= 0 && (i = ((String)(installValue = ((String)installValue).substring(0, i) + ((String)installValue).substring(i + EDIT_LINE_ITEM.length()))).indexOf(SOURCE_SUBMENU)) >= 0) {
            installValue = ((String)installValue).substring(0, i) + ((String)installValue).substring(i + SOURCE_SUBMENU.length());
        }
        return installValue;
    }

    @Override
    String value(View view) {
        return view != null ? view.popup() : null;
    }

    String currentPopupMenu(View view) {
        boolean visualEditItem;
        String popup = this.currentValue(view);
        if (view == null) {
            return popup;
        }
        boolean insertBidiItems = view.nls().isSmartLogical();
        boolean bl = visualEditItem = LpexUtilities.getPlatform() == 1 && view.nls().isSourceBidi();
        if (insertBidiItems || visualEditItem || view.compareSession()) {
            int i;
            if (popup == null) {
                popup = "";
            }
            StringBuilder buffer = new StringBuilder(popup.length() + 512);
            buffer.append(popup);
            if (insertBidiItems || visualEditItem) {
                i = popup.indexOf("popup.sourceMenu");
                if (i >= 0) {
                    buffer.insert(i += "popup.sourceMenu".length(), " separator");
                    if (visualEditItem) {
                        buffer.insert(i, VISUAL_EDIT_ITEM);
                    }
                    if (insertBidiItems) {
                        buffer.insert(i, INSERT_BIDI_ITEMS);
                    }
                } else {
                    i = popup.indexOf("MARK-Source");
                    if (i >= 0) {
                        buffer.insert(i += "MARK-Source".length(), " endSubmenu separator");
                        if (visualEditItem) {
                            buffer.insert(i, VISUAL_EDIT_ITEM);
                        }
                        if (insertBidiItems) {
                            buffer.insert(i, INSERT_BIDI_ITEMS);
                        }
                        buffer.insert(i, " beginSubmenu popup.sourceMenu ");
                    }
                }
            }
            if (view.compareSession() && (i = popup.indexOf("MARK-Compare")) >= 0) {
                buffer.insert(i += "MARK-Compare".length(), COMPARE_SUBMENU);
            }
            popup = buffer.toString();
        }
        return popup;
    }
}

