/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.ParsePending;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class ParsePendingList
extends List {
    private View _view;
    private boolean _inParser;
    private boolean _parsing;
    private LpexParser _lpexParser;
    private String _parserName;
    private String _parserOverrideName;

    ParsePendingList(View view) {
        this._view = view;
    }

    LpexParser lpexParser() {
        return this._lpexParser;
    }

    boolean inParser() {
        return this._inParser;
    }

    String parser() {
        return this._parserName;
    }

    ParsePending find(Element element) {
        return element == null ? null : element.elementView(this._view).parsePending();
    }

    void setParsing(boolean parsing) {
        if (parsing != this._parsing) {
            this._parsing = parsing;
            if (!this._parsing) {
                this.clear();
            }
        }
    }

    private void initializeParser() {
        if (this._lpexParser != null && this._lpexParser instanceof LpexCommonParser) {
            this.setParsing(false);
            this._inParser = true;
            try {
                ((LpexCommonParser)this._lpexParser)._initializeParser();
            }
            catch (Throwable e) {
                String className = UpdateProfileCommand.ParserClassParameter.getParameter().currentValue(this._view, "parserClass." + this._parserName);
                String errorText = LpexResources.message("exception.parser", className);
                this._view.screen().setMessageText(errorText);
                LpexLog.log(this._view, errorText, e);
                this._lpexParser = null;
                this._parserName = null;
            }
            this._inParser = false;
            this.setParsing(true);
        }
    }

    void totalParse() {
        if (this._lpexParser != null && !this._inParser && this._view.document().elementList().count() > 0) {
            this.setParsing(false);
            this._inParser = true;
            try {
                this._lpexParser.totalParse();
            }
            catch (Throwable e) {
                String className = UpdateProfileCommand.ParserClassParameter.getParameter().currentValue(this._view, "parserClass." + this._parserName);
                String errorText = LpexResources.message("exception.parser", className);
                this._view.screen().setMessageText(errorText);
                LpexLog.log(this._view, errorText, e);
                this._lpexParser = null;
                this._parserName = null;
            }
            this._inParser = false;
            this.setParsing(true);
        }
    }

    void parse() {
        if (this._lpexParser == null || this._inParser) {
            return;
        }
        ParsePending parsePending = (ParsePending)this.first();
        if (parsePending == null) {
            return;
        }
        this._view.screen()._needsScreenShow = true;
        ElementList elementList = this._view.document().elementList();
        this._inParser = true;
        try {
            while (parsePending != null) {
                this._lpexParser.parse(elementList.ordinalOf(parsePending.element()));
                if (parsePending == this.first()) {
                    this.remove(parsePending);
                }
                parsePending = (ParsePending)this.first();
            }
        }
        catch (Throwable e) {
            String className = UpdateProfileCommand.ParserClassParameter.getParameter().currentValue(this._view, "parserClass." + this._parserName);
            String errorText = LpexResources.message("exception.parser", className);
            this._view.screen().setMessageText(errorText);
            LpexLog.log(this._view, errorText, e);
            this._lpexParser = null;
            this._parserName = null;
            this.clear();
        }
        this._inParser = false;
    }

    void add(Element element, int type) {
        if (!this._inParser && this._parsing) {
            ParsePending parsePending = this.find(element);
            if (parsePending == null) {
                parsePending = new ParsePending(element, type);
                this.addBefore(null, parsePending);
                element.elementView(this._view).setParsePending(parsePending);
            } else {
                parsePending.addType(type);
            }
        }
    }

    @Override
    List.Node remove(List.Node node) {
        Element element = ((ParsePending)node).element();
        element.elementView(this._view).setParsePending(null);
        return super.remove(node);
    }

    void elementRemoved(Element element) {
        ParsePending parsePending = this.find(element);
        if (parsePending != null) {
            this.remove(parsePending);
        }
    }

    void elementParsed(Element element) {
        ElementView elementView;
        ParsePending parsePending;
        if (element != null && (parsePending = (elementView = element.elementView(this._view)).parsePending()) != null) {
            elementView.setParsePending(null);
            super.remove(parsePending);
        }
    }

    void dispose() {
        if (this._lpexParser != null) {
            try {
                this._lpexParser.resetParser();
            }
            catch (Throwable e) {
                LpexLog.log(this._view, null, e);
            }
            this._lpexParser = null;
            this._parserName = null;
        }
        this.clear();
    }

    void updateProfile() {
        String className;
        this.dispose();
        String parserName = null;
        if (this._parserOverrideName != null) {
            parserName = this._parserOverrideName;
        } else if (!UpdateProfileCommand.NoParserParameter.getParameter().currentValue(this._view) && "associated".equals(parserName = UpdateProfileCommand.ParserParameter.getParameter().currentValue(this._view))) {
            parserName = this._view.document().getAssociatedParserName(this._view);
        }
        if (parserName != null && parserName.length() > 0 && (className = UpdateProfileCommand.ParserClassParameter.getParameter().currentValue(this._view, "parserClass." + parserName)) != null) {
            Class<?> parserClass = null;
            try {
                parserClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (parserClass == null) {
                parserClass = ClassLoaderList.loadClass(className, this._view);
            }
            if (parserClass == null) {
                this._view.setLpexMessageText("class.notFound", className);
            } else if (!LpexParser.class.isAssignableFrom(parserClass)) {
                this._view.setLpexMessageText("class.invalid", className, "LpexParser");
            } else {
                try {
                    Class[] parameterTypes = new Class[]{LpexView.class};
                    Constructor<?> parserConstructor = parserClass.getConstructor(parameterTypes);
                    Object[] arguments = new Object[]{this._view.lpexView()};
                    this._lpexParser = (LpexParser)parserConstructor.newInstance(arguments);
                }
                catch (InvocationTargetException e) {
                    String errorText = LpexResources.message("exception.parser", className);
                    this._view.screen().setMessageText(errorText);
                    LpexLog.log(this._view, errorText, e.getTargetException());
                }
                catch (Exception e) {
                    this._view.setLpexMessageText("class.invalid", className, "LpexParser");
                }
            }
        }
        this._parserName = this._lpexParser != null ? parserName : null;
        this.initializeParser();
    }

    void postUpdateProfile() {
        this._view.commandHandler().doCommand("parse all");
    }

    void setParserOverrideName(String name) {
        this._parserOverrideName = name;
        this.updateProfile();
    }
}

