/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterWordDefault
extends ParameterDefault {
    private String _hardCodedValue;
    private String _installValue;
    private boolean _installValueLoaded;
    private String _defaultValue;
    private boolean _defaultValueLoaded;

    ParameterWordDefault(String name, String hardCodedValue) {
        super(name);
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterWordDefault.this._installValueLoaded = false;
                if (ParameterWordDefault.this.defaultValue() == null) {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterWordDefault.this.value(view) == null) {
                                ParameterWordDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterWordDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterWordDefault.this.value(view) == null) {
                            ParameterWordDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    String installValue() {
        if (!this._installValueLoaded) {
            String value = Install.getString("install." + this.name());
            this._installValue = value == null || !this.isAcceptableValue(value) ? this._hardCodedValue : value;
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    private void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            this._defaultValue = Profile.getString("default." + this.name());
            if (this._defaultValue != null && !this.isAcceptableValue(this._defaultValue)) {
                this._defaultValue = null;
            }
            this._defaultValueLoaded = true;
        }
    }

    String defaultValue() {
        this.loadDefaultValue();
        return this._defaultValue;
    }

    boolean setDefaultValue(String value) {
        this._defaultValue = value;
        this._defaultValueLoaded = true;
        if (this._defaultValue != null) {
            Profile.putString("default." + this.name(), this._defaultValue);
        } else {
            Profile.remove("default." + this.name());
        }
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (this.value(view) == null) {
                    this.currentValueChanged(view);
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    String currentValue(View view) {
        String value = this.value(view);
        if (value == null && (value = this.defaultValue()) == null) {
            value = this.installValue();
        }
        return "null".equalsIgnoreCase(value) ? null : value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        String value = "null";
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            String string = value = token.equalsIgnoreCase("default") ? null : token;
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name(qualifier));
            }
            if (value != null && !this.isAcceptableValue(value)) {
                return CommandHandler.invalidParameter(view, value, "set " + this.name(qualifier));
            }
        }
        return this.setValue(view, value);
    }

    abstract boolean setValue(View var1, String var2);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        String value = "null";
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            String string = value = token.equalsIgnoreCase("install") ? null : token;
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name(qualifier));
            }
            if (value != null && !this.isAcceptableValue(value)) {
                return CommandHandler.invalidParameter(view, value, "set default." + this.name(qualifier));
            }
        }
        return this.setDefaultValue(value);
    }

    void currentValueChanged(View view) {
    }

    boolean isAcceptableValue(String value) {
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view == null) {
            return null;
        }
        String value = this.value(view);
        return value == null ? "default" : (value.equalsIgnoreCase("null") ? null : value);
    }

    abstract String value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return this.installValue();
    }

    @Override
    String queryDefault(String qualifier) {
        String value = this.defaultValue();
        return value == null ? "install" : (value.equalsIgnoreCase("null") ? null : value);
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return this.currentValue(view);
    }
}

