/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterStringDefault
extends ParameterDefault {
    private String _hardCodedValue;
    private String _installValue;
    private boolean _installValueLoaded;
    private String _defaultValue;
    private boolean _defaultValueLoaded;

    ParameterStringDefault(String name, String hardCodedValue) {
        super(name);
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterStringDefault.this._installValueLoaded = false;
                if (ParameterStringDefault.this.defaultValue() == null) {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterStringDefault.this.value(view) == null) {
                                ParameterStringDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterStringDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterStringDefault.this.value(view) == null) {
                            ParameterStringDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    String installValue() {
        if (!this._installValueLoaded) {
            String value = LpexStringTokenizer.removeQuotes(Install.getString("install." + this.name()));
            this._installValue = value == null ? this._hardCodedValue : value;
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    private void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            this._defaultValue = LpexStringTokenizer.removeQuotes(Profile.getString("default." + this.name()));
            this._defaultValueLoaded = true;
        }
    }

    String defaultValue() {
        this.loadDefaultValue();
        return this._defaultValue;
    }

    boolean setDefaultValue(String value) {
        this._defaultValue = value;
        this._defaultValueLoaded = true;
        if (this._defaultValue != null) {
            Profile.putString("default." + this.name(), LpexStringTokenizer.addQuotes(this._defaultValue));
        } else {
            Profile.remove("default." + this.name());
        }
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (this.value(view) == null) {
                    this.currentValueChanged(view);
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    String currentValue(View view) {
        String value = this.value(view);
        if (value == null && (value = this.defaultValue()) == null) {
            value = this.installValue();
        }
        return value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        String value = null;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("default")) {
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "set " + this.name());
                }
                value = LpexStringTokenizer.removeQuotes(token);
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
            }
        }
        return this.setValue(view, value);
    }

    abstract boolean setValue(View var1, String var2);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        String value = null;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("install")) {
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "set default." + this.name());
                }
                value = LpexStringTokenizer.removeQuotes(token);
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
            }
        }
        return this.setDefaultValue(value);
    }

    void currentValueChanged(View view) {
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            String value = this.value(view);
            return value == null ? "default" : LpexStringTokenizer.addQuotes(value);
        }
        return null;
    }

    abstract String value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return LpexStringTokenizer.addQuotes(this.installValue());
    }

    @Override
    String queryDefault(String qualifier) {
        String value = this.defaultValue();
        return value == null ? "install" : LpexStringTokenizer.addQuotes(value);
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return LpexStringTokenizer.addQuotes(this.currentValue(view));
    }
}

