/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.KeyedList;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterQuery;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterQualifierList
extends ParameterQuery {
    String _root;
    boolean ignoreCase = true;

    ParameterQualifierList(String name, String root, boolean ignoreCase) {
        super(name);
        this._root = root;
        this.ignoreCase = ignoreCase;
    }

    @Override
    boolean hasInstallSetting() {
        return true;
    }

    @Override
    boolean hasDefaultSetting() {
        return true;
    }

    @Override
    boolean hasCurrentSetting() {
        return true;
    }

    void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        KeyedList keyedList;
        if (view != null && (keyedList = this.value(view)) != null) {
            return keyedList.keyList();
        }
        return null;
    }

    abstract KeyedList value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return this.installValue().keyList();
    }

    KeyedList installValue() {
        KeyedList keyedList = new KeyedList();
        String installRoot = "install." + this._root;
        int installRootLength = installRoot.length();
        LpexStringTokenizer st = new LpexStringTokenizer(Install.getKeys());
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!key.startsWith(installRoot)) continue;
            String value = Install.getString(key);
            key = key.substring(installRootLength);
            keyedList.set(key, value, this.ignoreCase);
        }
        return keyedList;
    }

    @Override
    String queryDefault(String qualifier) {
        return this.defaultValue().keyList();
    }

    KeyedList defaultValue() {
        KeyedList keyedList = new KeyedList();
        String defaultRoot = "default." + this._root;
        int defaultRootLength = defaultRoot.length();
        LpexStringTokenizer st = new LpexStringTokenizer(Profile.getKeys());
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!key.startsWith(defaultRoot)) continue;
            String value = Profile.getString(key);
            key = key.substring(defaultRootLength);
            keyedList.set(key, value, this.ignoreCase);
        }
        return keyedList;
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return this.currentValue(view).keyList();
    }

    KeyedList currentValue(View view) {
        Object value;
        String key;
        KeyedList mergedKeyedList = new KeyedList();
        KeyedList keyedList = this.installValue();
        LpexStringTokenizer st = new LpexStringTokenizer(keyedList.keyList());
        while (st.hasMoreTokens()) {
            key = st.nextToken();
            value = keyedList.query(key, this.ignoreCase);
            mergedKeyedList.set(key, value, this.ignoreCase);
        }
        keyedList = this.defaultValue();
        st = new LpexStringTokenizer(keyedList.keyList());
        while (st.hasMoreTokens()) {
            key = st.nextToken();
            value = keyedList.query(key, this.ignoreCase);
            if ("null".equals(value)) {
                value = null;
            }
            mergedKeyedList.set(key, value, this.ignoreCase);
        }
        if (view != null && (keyedList = this.value(view)) != null) {
            st = new LpexStringTokenizer(keyedList.keyList());
            while (st.hasMoreTokens()) {
                key = st.nextToken();
                value = keyedList.query(key, this.ignoreCase);
                if ("null".equals(value)) {
                    value = null;
                }
                mergedKeyedList.set(key, value, this.ignoreCase);
            }
        }
        return mergedKeyedList;
    }
}

