/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterOnOffDefault
extends ParameterDefault {
    private boolean _hardCodedValue;
    private boolean _installValue;
    private boolean _installValueLoaded;
    private int _defaultValue;
    private boolean _defaultValueLoaded;

    ParameterOnOffDefault(String name, boolean hardCodedValue) {
        super(name);
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterOnOffDefault.this._installValueLoaded = false;
                if (ParameterOnOffDefault.this.defaultValue() == 3) {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterOnOffDefault.this.value(view) == 2) {
                                ParameterOnOffDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterOnOffDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterOnOffDefault.this.value(view) == 2) {
                            ParameterOnOffDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    boolean installValue() {
        if (!this._installValueLoaded) {
            String value = Install.getString("install." + this.name());
            this._installValue = value == null ? this._hardCodedValue : value.equalsIgnoreCase("on");
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    int defaultValue() {
        if (!this._defaultValueLoaded) {
            String value = Profile.getString("default." + this.name());
            this._defaultValue = value == null ? 3 : (value.equalsIgnoreCase("on") ? 1 : 0);
            this._defaultValueLoaded = true;
        }
        return this._defaultValue;
    }

    boolean setDefaultValue(int value) {
        if (!this._defaultValueLoaded || value != this._defaultValue) {
            this._defaultValue = value;
            this._defaultValueLoaded = true;
            if (this._defaultValue != 3) {
                Profile.putString("default." + this.name(), this._defaultValue == 1 ? "on" : "off");
            } else {
                Profile.remove("default." + this.name());
            }
            Document document = Document._firstDocument;
            while (document != null) {
                View view = document._firstView;
                while (view != null) {
                    if (this.value(view) == 2) {
                        this.currentValueChanged(view);
                    }
                    view = view._next;
                }
                document = document._next;
            }
        }
        return true;
    }

    boolean currentValue(View view) {
        int value = this.value(view);
        if (value == 2 && (value = this.defaultValue()) == 3) {
            return this.installValue();
        }
        return value == 1;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        int value = 2;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("on")) {
                value = 1;
            } else if (token.equalsIgnoreCase("off")) {
                value = 0;
            } else if (!token.equalsIgnoreCase("default")) {
                return CommandHandler.invalidParameter(view, token, "set " + this.name());
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
            }
        }
        return this.setValue(view, value);
    }

    abstract boolean setValue(View var1, int var2);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        int value = 3;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("on")) {
                value = 1;
            } else if (token.equalsIgnoreCase("off")) {
                value = 0;
            } else if (!token.equalsIgnoreCase("install")) {
                return CommandHandler.invalidParameter(view, token, "set default." + this.name());
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
            }
        }
        return this.setDefaultValue(value);
    }

    void currentValueChanged(View view) {
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            int value = this.value(view);
            return value == 1 ? "on" : (value == 0 ? "off" : "default");
        }
        return null;
    }

    abstract int value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return this.installValue() ? "on" : "off";
    }

    @Override
    String queryDefault(String qualifier) {
        int value = this.defaultValue();
        return value == 1 ? "on" : (value == 0 ? "off" : "install");
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return this.currentValue(view) ? "on" : "off";
    }
}

