/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterIntegerQuery;
import com.ibm.lpex.core.View;

abstract class ParameterIntegerOnly
extends ParameterIntegerQuery {
    ParameterIntegerOnly(String name) {
        super(name);
    }

    @Override
    boolean isQueryOnly(String qualifier) {
        return false;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        int value;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "set " + this.name(qualifier));
        }
        String token = st.nextToken();
        try {
            value = Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
        }
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name(qualifier));
        }
        return this.setValue(view, qualifier, value);
    }

    abstract boolean setValue(View var1, String var2, int var3);
}

