/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterCharacterQuery;
import com.ibm.lpex.core.View;

abstract class ParameterCharacterOnly
extends ParameterCharacterQuery {
    ParameterCharacterOnly(String name) {
        super(name);
    }

    @Override
    boolean isQueryOnly(String qualifier) {
        return false;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        char value;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "set " + this.name(qualifier));
        }
        String token = st.nextToken();
        if (token.length() > 1) {
            try {
                value = (char)Integer.decode(token).intValue();
            }
            catch (NumberFormatException e) {
                return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
            }
        } else {
            value = token.charAt(0);
        }
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name(qualifier));
        }
        return this.setValue(view, qualifier, value);
    }

    abstract boolean setValue(View var1, String var2, char var3);
}

