/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.TextFontMetrics;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;

final class MessageLine
extends Composite
implements ControlListener,
MenuListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
PaintListener,
SelectionListener {
    private LpexWindow _lpexWindow;
    private boolean _messageValid;
    private String _text;
    private Font _font;
    private Font _boldFont;
    private Font _italicFont;
    private Font _boldItalicFont;
    private int _textHeight;
    private int _spaceWidth;
    private StyleAttributes _styleAttributes;
    private Composite _messageLineText;
    private int _textStart;
    private boolean _showArrows;
    private Composite _arrows;
    private boolean _mouseOnRightArrow;
    private boolean _mouseOnLeftArrow;
    private Color _arrowEnabledColor;
    private Color _arrowDisabledColor;
    private Menu _popupMenu;
    private MenuItem _popupMenuItem;

    MessageLine(LpexWindow lpexWindow) {
        super((Composite)lpexWindow, 0);
        this._lpexWindow = lpexWindow;
        this.addControlListener(this);
        this.setLayout(new MessageLineLayout());
        this._messageLineText = new Composite((Composite)this, 786432);
        this._messageLineText.addPaintListener((PaintListener)this);
        this._popupMenu = new Menu((Control)this._messageLineText);
        this._popupMenuItem = new MenuItem(this._popupMenu, 0);
        this._popupMenuItem.setText(LpexResources.message("popup.copy"));
        LpexUtilities.setHelp(this._popupMenuItem, "com.ibm.lpex.popup_messageLine_copy_context");
        this._popupMenuItem.addSelectionListener((SelectionListener)this);
        this._popupMenu.addMenuListener((MenuListener)this);
        this._messageLineText.setMenu(this._popupMenu);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                MessageLine.this.handleDispose();
            }
        });
        this.initAccessible();
    }

    void handleDispose() {
        this.disposeFonts();
        if (this._popupMenu != null) {
            this._popupMenu.dispose();
        }
        this._popupMenu = null;
    }

    private void disposeFonts() {
        if (this._boldFont != null) {
            this._boldFont.dispose();
        }
        if (this._italicFont != null) {
            this._italicFont.dispose();
        }
        if (this._boldItalicFont != null) {
            this._boldItalicFont.dispose();
        }
        this._boldItalicFont = null;
        this._italicFont = null;
        this._boldFont = null;
    }

    private Font currentFont() {
        if (this._styleAttributes != null) {
            if (this._styleAttributes.boldItalic()) {
                if (this._boldItalicFont == null) {
                    this._boldItalicFont = this.deriveFont(3);
                }
                return this._boldItalicFont;
            }
            if (this._styleAttributes.bold()) {
                if (this._boldFont == null) {
                    this._boldFont = this.deriveFont(1);
                }
                return this._boldFont;
            }
            if (this._styleAttributes.italic()) {
                if (this._italicFont == null) {
                    this._italicFont = this.deriveFont(2);
                }
                return this._italicFont;
            }
        }
        return this._font;
    }

    private Font deriveFont(int style) {
        FontData[] fontDatas = this._font.getFont().getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(style);
            ++i;
        }
        return new Font((Device)this.getDisplay(), fontDatas);
    }

    Composite messageLineText() {
        return this._messageLineText;
    }

    private void createArrows() {
        if (this._arrows == null) {
            this._arrowEnabledColor = this.getDisplay().getSystemColor(21);
            this._arrowDisabledColor = this.getDisplay().getSystemColor(18);
            this._arrows = new Composite((Composite)this, 786432);
            this._arrows.setBackground(this.getDisplay().getSystemColor(19));
            this._arrows.addMouseListener((MouseListener)this);
            this._arrows.addMouseTrackListener((MouseTrackListener)this);
            this._arrows.addMouseMoveListener((MouseMoveListener)this);
            this._arrows.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    MessageLine.this.paintArrowsControl(e.gc);
                }
            });
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this._spaceWidth * 40, this._textHeight);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.updateScrollArrows();
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
        this.mouseMove(e);
    }

    public void mouseExit(MouseEvent e) {
        if (this._mouseOnRightArrow || this._mouseOnLeftArrow) {
            this._mouseOnLeftArrow = false;
            this._mouseOnRightArrow = false;
            this._arrows.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (e.y <= this._arrows.getSize().y / 2) {
            if (!this._mouseOnRightArrow) {
                this._mouseOnRightArrow = true;
                this._mouseOnLeftArrow = false;
                this._arrows.redraw();
            }
        } else if (!this._mouseOnLeftArrow) {
            this._mouseOnLeftArrow = true;
            this._mouseOnRightArrow = false;
            this._arrows.redraw();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.y <= this._arrows.getSize().y / 2) {
            this.scrollRight();
        } else {
            this.scrollLeft();
        }
    }

    public void menuShown(MenuEvent e) {
        this._popupMenuItem.setEnabled(this._text != null && this._text.length() != 0);
    }

    public void menuHidden(MenuEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        LpexUtilities.setClipboardContents(this._text, null);
    }

    void setText(String text) {
        if (this._text == null && text == null) {
            return;
        }
        if (this._text == null || !this._text.equals(text)) {
            this._text = text;
            this._textStart = 0;
            this._messageValid = false;
        }
    }

    boolean setFont(Font font, StyleAttributes styleAttributes) {
        boolean fontChanged = false;
        int oldTextHeight = this._textHeight;
        if (this._styleAttributes == null || !this._styleAttributes.equals(styleAttributes)) {
            this._messageLineText.setBackground(styleAttributes.backgroundColor().getColor());
            this._messageLineText.setForeground(styleAttributes.foregroundColor().getColor());
            if (this._styleAttributes == null || this._styleAttributes.bold() != styleAttributes.bold() || this._styleAttributes.italic() != styleAttributes.italic()) {
                fontChanged = true;
            }
            this._styleAttributes = styleAttributes;
            this._messageValid = false;
        }
        if (this._font == null || !this._font.equals(font)) {
            fontChanged = true;
            this._font = font;
            this.disposeFonts();
            this._messageValid = false;
        }
        if (fontChanged && this._font != null) {
            this._messageLineText.setFont(this.currentFont().getFont());
            GC g = new GC((Drawable)this._messageLineText);
            g.setFont(this.currentFont().getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            this._textHeight = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
            this._spaceWidth = this.getStringWidth(g, " ");
            g.dispose();
        }
        return fontChanged && oldTextHeight != this._textHeight && this.isVisible();
    }

    int getStringWidth(GC g, String s) {
        return s != null ? g.stringExtent((String)s).x : 0;
    }

    int getStringWidth(String s) {
        int width = 0;
        if (s != null && !this._messageLineText.isDisposed()) {
            GC g = new GC((Drawable)this._messageLineText);
            g.setFont(this.currentFont().getFont());
            width = this.getStringWidth(g, s);
            g.dispose();
        }
        return width;
    }

    void updateMessage() {
        if (!this._messageValid && this.getSize().y != 0) {
            this.updateScrollArrows();
            this._messageLineText.redraw();
        }
    }

    private void updateScrollArrows() {
        boolean showArrows;
        boolean bl = showArrows = this._textStart != 0 || this._text != null && this.getStringWidth(this._text) > this.getSize().x;
        if (this._showArrows != showArrows) {
            this._showArrows = showArrows;
            this.createArrows();
            this.layout();
        }
    }

    void scrollRight() {
        if (this.scrollRightAvailable()) {
            int messageLineTextWidth = this._messageLineText.getSize().x;
            int textWidth = this.getStringWidth(this._text);
            this._textStart -= messageLineTextWidth / 2;
            if (this._textStart + textWidth + 1 < messageLineTextWidth) {
                this._textStart = messageLineTextWidth - textWidth - 1;
            }
            if (!this.scrollRightAvailable()) {
                this._arrows.redraw();
            }
            this._messageLineText.redraw();
        }
    }

    void scrollLeft() {
        if (this.scrollLeftAvailable()) {
            this._textStart += this._messageLineText.getSize().x / 2;
            if (this._textStart > 0) {
                this._textStart = 0;
            }
            if (!this.scrollLeftAvailable()) {
                this.updateScrollArrows();
                this._arrows.redraw();
            }
            this._messageLineText.redraw();
        }
    }

    boolean scrollRightAvailable() {
        return this._textStart + this.getStringWidth(this._text) > this._messageLineText.getSize().x;
    }

    boolean scrollLeftAvailable() {
        return this._textStart != 0;
    }

    public void paintControl(PaintEvent e) {
        GC g = e.gc;
        if (this._styleAttributes != null) {
            Point size = this.getSize();
            g.fillRectangle(0, 0, size.x, size.y);
            if (this._text != null) {
                g.drawString(this._text, this._textStart, 0, true);
                if (this._styleAttributes.underline()) {
                    if (this._styleAttributes.effectsColor() != null) {
                        g.setForeground(this._styleAttributes.effectsColor().getColor());
                    }
                    g.drawLine(this._textStart, size.y - 1, this._textStart + this.getStringWidth(g, this._text), size.y - 1);
                }
                if (this._styleAttributes.squiggle()) {
                    if (this._styleAttributes.effectsColor() != null) {
                        g.setForeground(this._styleAttributes.effectsColor().getColor());
                    }
                    this.drawSquiggle(g, this._textStart, this._textStart + this.getStringWidth(g, this._text), size.y - 1);
                }
                if (this._styleAttributes.strikeout()) {
                    if (this._styleAttributes.effectsColor() != null) {
                        g.setForeground(this._styleAttributes.effectsColor().getColor());
                    }
                    int yPos = (size.y - 2) / 2 + 1;
                    g.drawLine(0, yPos, this._textStart + this.getStringWidth(g, this._text), yPos);
                }
            }
        }
        this._messageValid = true;
    }

    private void drawSquiggle(GC g, int left, int right, int height) {
        int WIDTH = 4;
        int HEIGHT = 3;
        int ascents = (right - left) / 4;
        int len = 4 * ascents + 2;
        int[] segments = new int[len];
        TextFontMetrics textFontMetrics = this._lpexWindow.getLpexView()._view.screen().textFontMetrics();
        int top = Math.min(height - 3, textFontMetrics.baseline() + 1);
        int bottom = top + 3 - 1;
        int i = 0;
        int a = 0;
        while (a < ascents) {
            segments[i] = left + 4 * a;
            segments[i + 1] = bottom;
            segments[i + 2] = segments[i] + 2;
            segments[i + 3] = top;
            ++a;
            i += 4;
        }
        segments[i] = left + 4 * ascents;
        segments[i + 1] = bottom;
        g.drawPolyline(segments);
    }

    private void paintArrowsControl(GC g) {
        Point size = this._arrows.getSize();
        g.fillRectangle(0, 0, size.x, size.y);
        int x1 = 3;
        int x2 = size.x - 3;
        int y1 = size.y / 3;
        int y2 = size.y - y1;
        if (this._mouseOnRightArrow && this.scrollRightAvailable()) {
            g.setForeground(this._arrowEnabledColor);
        } else {
            g.setForeground(this._arrowDisabledColor);
        }
        int[] rightArrow = new int[]{x1, y1 - 1, x2, y1 - 1, x2 - 2, y1 - 3, x2 - 2, y1 + 2, x2, y1, x1, y1};
        g.drawPolygon(rightArrow);
        if (this._mouseOnLeftArrow && this.scrollLeftAvailable()) {
            g.setForeground(this._arrowEnabledColor);
        } else {
            g.setForeground(this._arrowDisabledColor);
        }
        int[] leftArrow = new int[]{x2, y2, x1, y2, x1 + 2, y2 - 2, x1 + 2, y2 + 3, x1, y2 + 1, x2, y2 + 1};
        g.drawPolygon(leftArrow);
    }

    private void initAccessible() {
        this._messageLineText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameMessageLine");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.descMessageLine");
            }
        });
        this._messageLineText.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = MessageLine.this._text;
            }
        });
    }

    final class MessageLineLayout
    extends Layout {
        MessageLineLayout() {
        }

        protected Point computeSize(Composite messageLine, int wHint, int hHint, boolean flushCache) {
            return messageLine.computeSize(-1, -1, flushCache);
        }

        protected void layout(Composite messageLine, boolean flushCache) {
            Rectangle messageLineRect = messageLine.getClientArea();
            int width = messageLineRect.width;
            int height = messageLineRect.height;
            int arrowsWidth = 0;
            if (MessageLine.this._showArrows) {
                ScrollBar verticalScrollBar = MessageLine.this._lpexWindow.verticalScrollBar();
                if (verticalScrollBar != null) {
                    arrowsWidth = verticalScrollBar.getSize().x;
                }
                arrowsWidth = Math.max(12, arrowsWidth);
            }
            MessageLine.this._messageLineText.setBounds(0, 0, width - arrowsWidth, height);
            if (MessageLine.this._arrows != null) {
                MessageLine.this._arrows.setBounds(width - arrowsWidth, 0, arrowsWidth, height);
            }
        }
    }
}

