/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class MarkParameter
extends Parameter {
    private static MarkParameter _parameter;

    static MarkParameter getParameter() {
        if (_parameter == null) {
            _parameter = new MarkParameter();
        }
        return _parameter;
    }

    private MarkParameter() {
        super("mark.");
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        boolean sticky = false;
        boolean elementMark = false;
        int element1 = 0;
        int position1 = 0;
        if (view != null) {
            element1 = view.document().elementList().ordinalOf(view.documentPosition().element());
            position1 = view.documentPosition().position();
        }
        int element2 = element1;
        int position2 = position1;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("clear")) {
                MarkList.Mark mark;
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name(qualifier));
                }
                if (view != null && (mark = view.markList().find(qualifier)) != null) {
                    mark.clear();
                }
                return true;
            }
            if (token.equalsIgnoreCase("sticky")) {
                sticky = true;
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if (token != null && token.equalsIgnoreCase("element")) {
                elementMark = true;
                token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            int[] integerParameters = new int[4];
            int count = 0;
            while (token != null && (elementMark && count < 2 || !elementMark && count < 4)) {
                try {
                    integerParameters[count] = Integer.parseInt(token);
                    ++count;
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
                }
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if (token != null) {
                return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
            }
            if (elementMark) {
                if (count > 0) {
                    element1 = integerParameters[0] - (view != null ? view.document().linesBeforeStart() : 0);
                }
                element2 = count > 1 ? integerParameters[1] - (view != null ? view.document().linesBeforeStart() : 0) : element1;
            } else {
                if (count > 0) {
                    element1 = integerParameters[0] - (view != null ? view.document().linesBeforeStart() : 0);
                }
                int n = position1 = count > 1 ? integerParameters[1] : 1;
                element2 = count > 2 ? integerParameters[2] - (view != null ? view.document().linesBeforeStart() : 0) : element1;
                if (count > 3) {
                    position2 = integerParameters[3];
                } else {
                    int n2 = position2 = element1 == element2 ? position1 : 1;
                }
            }
        }
        if (view != null) {
            if (element2 < element1) {
                int swap = element2;
                element2 = element1;
                element1 = swap;
                swap = position2;
                position2 = position1;
                position1 = swap;
            } else if (element1 == element2 && position2 < position1) {
                int swap = position2;
                position2 = position1;
                position1 = swap;
            }
            ElementList elementList = view.document().elementList();
            Element e1 = elementList.elementAt(element1);
            Element e2 = elementList.elementAt(element2);
            if (e1 != null && e2 != null) {
                if (elementMark) {
                    view.markList().set(qualifier, e1, e2, sticky);
                } else {
                    view.markList().set(qualifier, e1, position1, e2, position2, sticky);
                }
            }
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        MarkList.Mark mark;
        if (view != null && (mark = view.markList().find(qualifier)) != null) {
            return mark.query();
        }
        return null;
    }
}

