/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionHandler;
import com.ibm.lpex.core.ActionUtilities;
import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.HelpCommand;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.KeyListenerList;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexCursorListener;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexDocumentLocationRunnable;
import com.ibm.lpex.core.LpexDocumentSectionListener;
import com.ibm.lpex.core.LpexFieldsProvider;
import com.ibm.lpex.core.LpexKeyListener;
import com.ibm.lpex.core.LpexMarkListener;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexViewListener;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.QueryCommand;
import com.ibm.lpex.core.View;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.themes.IThemeManager;

public class LpexView {
    View _view;
    UUID _lpexViewId = UUID.randomUUID();
    protected IThemeManager themeManager;
    protected IEclipsePreferences.IPreferenceChangeListener themeChangeListener = null;
    private static final String DARK_THEME_ECLIPSE_ID = "org.eclipse.e4.ui.css.theme.e4_dark";
    private static final String DEFAULT_THEME_ECLIPSE_ID = "org.eclipse.e4.ui.css.theme.e4_default";
    private static final String THEME_ID = "themeid";
    private static final String DEFAULT_THEME_ID = "DEFAULT";
    private static final String ECLIPSE_THEME_PLUGIN_ID = "org.eclipse.e4.ui.css.swt.theme";
    private static final String WORKBENCH_RENDERERS_PLUGIN_ID = "org.eclipse.e4.ui.workbench.renderers.swt";
    private static final String ENABLE_THEME_ID = "themeEnabled";
    private static final String DARK_PALETTE = "dark";
    private static final String ECLIPSE_PALETTE = "";
    private LpexDocumentListener adapter = null;
    private KeyListenerList _keyListenerList;

    public LpexView(String fileName, String fileEncoding, boolean updateProfile) {
        new Document(fileName, fileEncoding, this, updateProfile);
    }

    public LpexView(String fileName, boolean updateProfile) {
        this(fileName, null, updateProfile);
    }

    public LpexView(String fileName) {
        this(fileName, null, true);
    }

    public LpexView() {
        this(null, null, true);
    }

    public LpexView(boolean updateProfile) {
        this((String)null, updateProfile);
    }

    public LpexView(LpexView lpexView) throws ViewInstantiationException {
        this(lpexView, true);
    }

    public LpexView(LpexView lpexView, boolean updateProfile) throws ViewInstantiationException {
        if (lpexView == null || lpexView._view == null || lpexView._view.document().linesBeforeStart() != 0 || lpexView._view.document().linesAfterEnd() != 0) {
            throw new ViewInstantiationException();
        }
        new View(this, lpexView._view.document(), updateProfile);
    }

    public void dispose() {
        this.removeThemeChangeListener();
        if (this._view != null) {
            this._view.dispose();
            this._view = null;
        }
    }

    public boolean isDisposed() {
        return this._view == null;
    }

    public void setWindow(LpexWindow lpexWindow) {
        if (this._view != null) {
            this._view.setWindow(lpexWindow);
        }
    }

    public String getVisibleText() {
        View view = this._view;
        if (view == null) {
            return ECLIPSE_PALETTE;
        }
        StringBuilder text = new StringBuilder(1024);
        Element element = view.document().elementList().firstVisible(view);
        while (element != null) {
            if (element.length() != 0) {
                text.append(element.text());
            }
            text.append("\n");
            element = element.nextVisible(view);
        }
        return text.toString();
    }

    public LpexWindow window() {
        return this._view != null ? this._view.window() : null;
    }

    public UUID getLpexViewId() {
        return this._lpexViewId;
    }

    public LpexView[] getLpexViews() {
        return this._view != null ? this._view.getLpexViews() : new LpexView[]{};
    }

    public LpexNls nls() {
        return this._view != null ? this._view.nls() : null;
    }

    public void setText(String text) {
        if (this._view != null) {
            this._view.setBidiFormatted(false);
            this._view.document().setText(this._view, text);
        }
    }

    public String text() {
        return this._view != null ? this._view.document().text() : null;
    }

    public boolean load(Reader reader) {
        if (this._view != null) {
            this._view.setBidiFormatted(false);
            return this._view.document().load(this._view, reader);
        }
        return false;
    }

    public boolean save(Writer writer) {
        return this._view != null ? this._view.document().saveToWriter(writer) : false;
    }

    public void setParserOverrideName(String name) {
        if (this._view != null) {
            this._view.setParserOverrideName(name);
        }
    }

    public void setSaveWriter(Writer writer) {
        if (this._view != null) {
            this._view.setSaveWriter(writer);
        }
    }

    public LpexCommand defineCommand(String commandName, LpexCommand lpexCommand) {
        return this._view != null ? this._view.commandHandler().defineCommand(commandName, lpexCommand) : null;
    }

    public LpexCommand command(String commandName) {
        return this._view != null ? this._view.commandHandler().command(commandName) : null;
    }

    public boolean doDefaultCommand(String commandString) {
        return CommandHandler.doDefaultCommand(this._view, commandString);
    }

    public boolean doDefaultCommand(LpexDocumentLocation documentLocation, String commandString) {
        if (documentLocation == null) {
            return false;
        }
        return CommandHandler.doDefaultCommand(this._view, documentLocation, commandString);
    }

    public boolean doCommand(String commandString) {
        return this._view != null ? this._view.commandHandler().doCommand(commandString) : false;
    }

    public boolean doCommand(LpexDocumentLocation documentLocation, String commandString) {
        if (documentLocation == null) {
            return false;
        }
        return this._view != null ? this._view.commandHandler().doCommand(documentLocation, commandString) : false;
    }

    public int doIterateSubcommand(LpexDocumentLocation documentLocation, String command0String, String commandString, LpexDocumentLocationRunnable locationAction) {
        return documentLocation == null ? 0 : (this._view == null ? 0 : this._view.commandHandler().doIterateSubcommand(documentLocation, command0String, commandString, locationAction));
    }

    public static boolean doGlobalCommand(String commandString) {
        return CommandHandler.doDefaultCommand(commandString);
    }

    public LpexAction defineAction(String actionName, LpexAction lpexAction) {
        return this._view != null ? this._view.actionHandler().defineAction(actionName, lpexAction) : null;
    }

    public int actionId(String actionName) {
        return this._view != null ? this._view.actionHandler().id(actionName) : 0;
    }

    public LpexAction action(String actionName) {
        return this._view != null ? this._view.actionHandler().action(actionName) : null;
    }

    public void doDefaultAction(int actionId) {
        ActionUtilities.doDefaultAction(this._view, actionId);
    }

    public boolean defaultActionAvailable(int actionId) {
        return ActionUtilities.defaultActionAvailable(this._view, actionId);
    }

    public void doAction(int actionId) {
        if (this._view != null) {
            this._view.actionHandler().doAction(actionId);
        }
    }

    public void triggerAction(int actionId) {
        if (this._view != null) {
            this._view.actionHandler().triggerAction(actionId);
        }
    }

    public void triggerAction(int actionId, boolean record) {
        if (this._view != null) {
            this._view.actionHandler().triggerAction(actionId, record);
        }
    }

    public boolean actionAvailable(int actionId) {
        return this._view != null ? this._view.actionHandler().actionAvailable(actionId) : false;
    }

    public boolean actionChecked(int actionId) {
        return this._view != null ? this._view.actionHandler().actionChecked(actionId) : false;
    }

    public String actionKey(int actionId) {
        return this._view != null ? this._view.actionHandler().keyString(actionId) : null;
    }

    public String actionKeyText(int actionId) {
        return this._view != null ? this._view.actionHandler().keyText(actionId) : null;
    }

    public static String keyText(String keyString) {
        return ActionHandler.keyText(keyString);
    }

    public boolean keyAssigned(String keyString) {
        String temp;
        String string = temp = this._view != null ? this._view.actionHandler().keyActionString(keyString) : null;
        return temp != null && !temp.equals("nullAction");
    }

    public int elements() {
        return this._view != null ? this._view.document().elementList().count() : 0;
    }

    public void jump(int element, int position) {
        if (this._view != null) {
            this._view.documentPosition().jump(this.getElement(element), position);
        }
    }

    public void jump(LpexDocumentLocation documentLocation) {
        if (this._view != null) {
            this._view.documentPosition().jump(documentLocation);
        }
    }

    public LpexParser parser() {
        return this._view != null ? this._view.parsePendingList().lpexParser() : null;
    }

    public int parsePending(int element) {
        return this._view == null ? 0 : this._view.parsePending(this.getElement(element));
    }

    public void elementParsed(int element) {
        if (this._view != null) {
            this._view.parsePendingList().elementRemoved(this._view.document().elementList().elementAt(element));
        }
    }

    public String elementText(int element) {
        Element e = this.getElement(element);
        return e != null ? e.text() : null;
    }

    public String elementFullText(int element) {
        Element e = this.getElement(element);
        return e != null ? e.fullText() : null;
    }

    public String lineFullText(int line) {
        return this._view != null ? this._view.document().elementList().lineFullText(line) : null;
    }

    public void setElementText(int element, String text) {
        CommandHandler.doDefaultCommand(this._view, new LpexDocumentLocation(element, 1), "set text " + text);
    }

    public boolean show(int element) {
        Element e = this.getElement(element);
        return e != null ? e.show() : false;
    }

    public boolean viewShow(int element) {
        Element e = this.getElement(element);
        return e != null ? e.show() && e.elementView(this._view).show() : false;
    }

    public String elementStyle(int element) {
        Element e = this.getElement(element);
        return e != null ? e.elementView(this._view).style() : null;
    }

    public void setElementStyle(int element, String style) {
        Element e = this.getElement(element);
        if (e != null) {
            e.elementView(this._view).setStyle(style);
        }
    }

    public long elementClasses(int element) {
        Element e = this.getElement(element);
        return e != null ? e.elementView(this._view).classes() & 0x1FFFFFFFFFFFFFFEL : 0L;
    }

    public void setElementClasses(int element, long classes) {
        Element e = this.getElement(element);
        if (e != null) {
            e.elementView(this._view).setClasses(classes);
        }
    }

    public long registerClass(String className) {
        return this._view != null ? this._view.classes().register(className) : 0L;
    }

    public long classMask(String classNames) {
        return this._view != null ? this._view.classes().mask(classNames) : 0L;
    }

    public int currentElement() {
        return this._view == null ? 0 : this._view.document().elementList().ordinalOf(this._view.documentPosition().element());
    }

    public int currentPosition() {
        return this._view == null ? 0 : this._view.documentPosition().position();
    }

    public LpexDocumentLocation documentLocation() {
        return this._view != null ? this._view.documentPosition().documentLocation() : new LpexDocumentLocation(0, 0);
    }

    public LpexDocumentLocation documentLocation(int charOffset, int eolLength) {
        return this._view != null ? this._view.documentLocation(charOffset, eolLength) : new LpexDocumentLocation(0, 0);
    }

    public int charOffset(LpexDocumentLocation documentLocation, int eolLength) {
        return this._view != null && documentLocation != null ? this._view.charOffset(documentLocation, eolLength) : 0;
    }

    public LpexView lpexView(String documentName) {
        return this._view != null ? this._view.lpexView(documentName) : null;
    }

    public void setBlockInstance(LpexView lpexView) {
        if (this._view != null) {
            this._view.setBlockInstance(lpexView._view);
        }
    }

    public LpexView getBlockView() {
        return this._view == null ? null : (this._view.block().view() != null ? this._view.block().view().lpexView() : null);
    }

    public String query(String parameter) {
        return QueryCommand.query(parameter, this._view, this._view != null ? this._view.documentPosition().documentLocation() : null);
    }

    public int queryInt(String parameter) {
        String value = this.query(parameter);
        return value != null ? Integer.parseInt(value) : -1;
    }

    public boolean queryOn(String parameter) {
        String value = this.query(parameter);
        return value != null && value.equals("on");
    }

    public String query(String parameter, LpexDocumentLocation documentLocation) {
        return QueryCommand.query(parameter, this._view, documentLocation);
    }

    public int queryInt(String parameter, LpexDocumentLocation documentLocation) {
        String value = this.query(parameter, documentLocation);
        return value != null ? Integer.parseInt(value) : -1;
    }

    public boolean queryOn(String parameter, LpexDocumentLocation documentLocation) {
        String value = this.query(parameter, documentLocation);
        return value != null && value.equals("on");
    }

    public int elementOfRow(int row) {
        return this._view != null ? this._view.document().elementList().ordinalOf(this._view.screen().element(row)) : 0;
    }

    public int elementOfLine(int line) {
        return this._view != null ? this._view.document().elementList().elementOfLine(line) : 0;
    }

    public int lineOfElement(int element) {
        return this._view != null ? this._view.document().elementList().lineOfElement(element) : 0;
    }

    public String deletedMarkName(int markId) {
        return this._view != null ? this._view.markList().deletedMarkName(markId) : null;
    }

    public static String globalQuery(String parameter) {
        return QueryCommand.query(parameter, null, null);
    }

    private Element getElement(int element) {
        return this._view == null ? null : this._view.document().elementList().elementAt(element);
    }

    public String getDeletedText() {
        return this._view.document().undo().getCurrentDeletedChanges();
    }

    public boolean setLinesOutsideDocumentSection(int linesBeforeStart, int linesAfterEnd) {
        return this._view == null ? false : this._view.document().setLinesOutsideDocumentSection(this._view, linesBeforeStart, linesAfterEnd);
    }

    public int linesBeforeStart() {
        return this._view != null ? this._view.document().linesBeforeStart() : 0;
    }

    public int linesAfterEnd() {
        return this._view != null ? this._view.document().linesAfterEnd() : 0;
    }

    public void setFieldsProvider(LpexFieldsProvider fieldsProvider) {
        if (this._view != null) {
            this._view.setFieldsProvider(fieldsProvider);
        }
    }

    public void addLpexViewListener(LpexViewListener viewListener) {
        if (this._view != null) {
            this._view.listenerList().addListener(viewListener);
        }
    }

    public void removeLpexViewListener(LpexViewListener viewListener) {
        if (this._view != null) {
            this._view.listenerList().removeListener(viewListener);
        }
    }

    public void addLpexCursorListener(LpexCursorListener cursorListener) {
        if (this._view != null) {
            this._view.cursorListenerList().addListener(cursorListener);
        }
    }

    public void removeLpexCursorListener(LpexCursorListener cursorListener) {
        if (this._view != null) {
            this._view.cursorListenerList().removeListener(cursorListener);
        }
    }

    public void addLpexMarkListener(int markId, LpexMarkListener markListener) {
        MarkList.Mark mark;
        MarkList.Mark mark2 = mark = this._view != null ? this._view.markList().find(markId) : null;
        if (mark != null) {
            mark.addListener(markListener);
        }
    }

    public void removeLpexMarkListener(int markId, LpexMarkListener markListener) {
        if (this._view != null) {
            this._view.markList().removeListener(markId, markListener);
        }
    }

    public void removeLpexMarkListener(LpexMarkListener markListener) {
        if (this._view != null) {
            this._view.markList().removeListener(markListener);
        }
    }

    public void addLpexDocumentListener(LpexDocumentListener documentListener) {
        if (this._view != null) {
            this._view.document().documentListenerList().addListener(documentListener);
        }
    }

    public void appendLpexDocumentListener(LpexDocumentListener documentListener) {
        if (this._view != null) {
            this._view.document().documentListenerList().appendListener(documentListener);
        }
    }

    public void removeLpexDocumentListener(LpexDocumentListener documentListener) {
        if (this._view != null) {
            this._view.document().documentListenerList().removeListener(documentListener);
        }
    }

    public void addLpexDocumentAdjustListener(LpexDocumentListener documentAdjustListener) {
        if (this._view != null) {
            this._view.document().documentAdjustListenerList().addListener(documentAdjustListener);
        }
    }

    public void removeLpexDocumentAdjustListener(LpexDocumentListener documentAdjustListener) {
        if (this._view != null) {
            this._view.document().documentAdjustListenerList().removeListener(documentAdjustListener);
        }
    }

    public void addLpexDocumentSectionListener(LpexDocumentSectionListener sectionListener) {
        if (this._view != null) {
            this._view.document().documentSectionListenerList().addListener(sectionListener);
        }
    }

    public void removeLpexDocumentSectionListener(LpexDocumentSectionListener sectionListener) {
        if (this._view != null) {
            this._view.document().documentSectionListenerList().removeListener(sectionListener);
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        ClassLoaderList.setClassLoader(classLoader);
    }

    public static void extendInstallProfile(Properties extension) {
        Install.loadExtension(extension);
    }

    public static String getLpexHelpPage(String lpexItem) {
        return HelpCommand.getLpexHelpPage(lpexItem);
    }

    public void setOwnerDrawMargin(boolean ownerDraw) {
        if (this._view != null) {
            this._view.screen().setOwnerDrawMargin(ownerDraw);
        }
    }

    public void addLpexKeyListener(LpexKeyListener keyListener) {
        if (keyListener != null) {
            if (this._keyListenerList == null) {
                this._keyListenerList = new KeyListenerList();
            }
            this._keyListenerList.addListener(keyListener);
        }
    }

    public void removeLpexKeyListener(LpexKeyListener keyListener) {
        boolean noMoreListeners;
        if (this._keyListenerList != null && (noMoreListeners = this._keyListenerList.removeListener(keyListener))) {
            this._keyListenerList = null;
        }
    }

    KeyListenerList keyListenerList() {
        return this._keyListenerList;
    }

    void triggerKeyListeners(Event event) {
        if (this._keyListenerList != null) {
            this._keyListenerList.keyPressed(event);
        }
    }

    public void setFont(org.eclipse.swt.graphics.Font swtFont) {
        if (this._view != null) {
            Font font = new Font(swtFont);
            this._view.screen().setFont(font);
        }
    }

    public org.eclipse.swt.graphics.Font getFont() {
        return this._view != null ? this._view.screen().currentFont().getFont() : null;
    }

    public boolean isViewBidiFormatted() {
        return this._view.isBidiFormatted();
    }

    public void setAdapter(LpexDocumentListener listener) {
        this.adapter = listener;
    }

    public LpexDocumentListener getAdapter() {
        return this.adapter;
    }

    public void setBaseEncoding(String fileEncoding) {
        this._view.document().setFileEncoding(fileEncoding, false);
    }

    public void addThemeChangeListener() {
        if (this.themeChangeListener == null) {
            this.themeChangeListener = new InternalLpexViewThemePreferenceChangeListener();
            InstanceScope.INSTANCE.getNode(ECLIPSE_THEME_PLUGIN_ID).addPreferenceChangeListener(this.themeChangeListener);
        }
    }

    public void removeThemeChangeListener() {
        if (this.themeChangeListener != null) {
            InstanceScope.INSTANCE.getNode(ECLIPSE_THEME_PLUGIN_ID).removePreferenceChangeListener(this.themeChangeListener);
        }
        this.themeChangeListener = null;
    }

    protected void updatePalette(String selectedPalette) {
        this.doDefaultCommand("set default.updateProfile.palette " + selectedPalette);
    }

    protected void updateProfile() {
        this.doDefaultCommand("updateProfile");
    }

    protected void screenShowView() {
        this.doDefaultCommand("screenShow view");
    }

    protected class InternalLpexViewThemePreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public InternalLpexViewThemePreferenceChangeListener() {
            if (LpexView.this.queryOn("current.useTheme")) {
                this.initializePaletteToTheme();
            }
        }

        private String getCurrentTheme() {
            IEclipsePreferences theme_prefs = InstanceScope.INSTANCE.getNode(LpexView.WORKBENCH_RENDERERS_PLUGIN_ID);
            String curTheme = theme_prefs.get(LpexView.ENABLE_THEME_ID, LpexView.DEFAULT_THEME_ID);
            if (curTheme.equals(LpexView.DEFAULT_THEME_ID)) {
                curTheme = Display.isSystemDarkTheme() ? LpexView.DARK_THEME_ECLIPSE_ID : LpexView.DEFAULT_THEME_ID;
            } else if (curTheme.equals("false")) {
                curTheme = LpexView.DEFAULT_THEME_ID;
            } else {
                theme_prefs = InstanceScope.INSTANCE.getNode(LpexView.ECLIPSE_THEME_PLUGIN_ID);
                curTheme = theme_prefs.get(LpexView.THEME_ID, LpexView.DEFAULT_THEME_ID);
            }
            return curTheme;
        }

        private void updatePaletteWithTheme(String theme) {
            if (theme != null) {
                if (LpexView.DARK_THEME_ECLIPSE_ID.equals(theme)) {
                    LpexView.this.updatePalette(LpexView.DARK_PALETTE);
                } else {
                    LpexView.this.updatePalette(LpexView.ECLIPSE_PALETTE);
                }
            }
        }

        private void initializePaletteToTheme() {
            String curTheme = this.getCurrentTheme();
            this.updatePaletteWithTheme(curTheme);
            LpexView.this.updateProfile();
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent arg0) {
            if (LpexView.THEME_ID.equals(arg0.getKey()) && arg0.getNewValue() != null && LpexView.this.queryOn("current.useTheme")) {
                this.updatePaletteWithTheme((String)arg0.getNewValue());
                LpexView.this.updateProfile();
                LpexView.this.screenShowView();
            }
        }
    }

    public static class ViewInstantiationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ViewInstantiationException() {
        }

        public ViewInstantiationException(String message) {
            super(message);
        }
    }
}

