/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.LpexPlugin;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.LpexInternalUtilities;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.SplitWindowParameters;
import com.ibm.lpex.core.View;
import com.ibm.lpex.core.ViewListenerList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public final class LpexUtilities {
    private static boolean _bidiChecked;
    private static boolean _isBidi;
    private static boolean is64bit;
    private static Class[] params_AddLL;
    private static Method m_AddLL;
    private static Object[] arg_AddLL;
    private static Class[] params_RemoveLL;
    private static Method m_RemoveLL;
    private static Object[] arg_RemoveLL;
    private static Class bidiUtilClass;
    private static IWorkbench _runningWorkbench;

    static {
        is64bit = false;
        params_AddLL = null;
        m_AddLL = null;
        arg_AddLL = null;
        params_RemoveLL = null;
        m_RemoveLL = null;
        arg_RemoveLL = null;
        bidiUtilClass = null;
        is64bit = System.getProperty("os.arch").contains("64");
        try {
            bidiUtilClass = Class.forName("org.eclipse.swt.internal.BidiUtil");
            if (is64bit) {
                params_AddLL = new Class[]{Long.TYPE, Runnable.class};
                params_RemoveLL = new Class[]{Long.TYPE};
            } else {
                params_AddLL = new Class[]{Integer.TYPE, Runnable.class};
                params_RemoveLL = new Class[]{Integer.TYPE};
            }
            m_AddLL = bidiUtilClass.getMethod("addLanguageListener", params_AddLL);
            m_RemoveLL = bidiUtilClass.getMethod("removeLanguageListener", params_RemoveLL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            _runningWorkbench = PlatformUI.getWorkbench();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private LpexUtilities() {
    }

    public static int getPlatform() {
        return 1;
    }

    static boolean isMac() {
        return "carbon".equals(SWT.getPlatform());
    }

    static String getHardcodedValueStyleSelection() {
        Color[] colors = new Color[2];
        Display display = Display.getCurrent();
        if (display != null) {
            colors[0] = display.getSystemColor(27);
            colors[1] = display.getSystemColor(26);
        } else {
            Display.getDefault().syncExec((Runnable)new GetSelectionColors(colors));
        }
        return new StringBuilder(32).append(colors[0].getRed()).append(' ').append(colors[0].getGreen()).append(' ').append(colors[0].getBlue()).append(' ').append(colors[1].getRed()).append(' ').append(colors[1].getGreen()).append(' ').append(colors[1].getBlue()).append(' ').toString();
    }

    static void beep() {
        Display.getDefault().beep();
    }

    static void setClipboardContents(String text, String rtfText) {
        Clipboard clipboard;
        block4: {
            clipboard = new Clipboard(Display.getDefault());
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                if (rtfText == null) {
                    clipboard.setContents((Object[])new String[]{text}, new Transfer[]{plainTextTransfer});
                } else {
                    clipboard.setContents((Object[])new String[]{rtfText, text}, new Transfer[]{RTFTransfer.getInstance(), plainTextTransfer});
                }
            }
            catch (SWTError error) {
                if (error.code == 2002) break block4;
                throw error;
            }
        }
        clipboard.dispose();
    }

    static String getClipboardContents() {
        TextTransfer transfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String text = (String)clipboard.getContents((Transfer)transfer);
        clipboard.dispose();
        return text;
    }

    static boolean isTextInClipboard() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TransferData[] available = clipboard.getAvailableTypes();
        boolean enabled = false;
        int i = 0;
        while (i < available.length) {
            if (TextTransfer.getInstance().isSupportedType(available[i])) {
                enabled = true;
                break;
            }
            ++i;
        }
        clipboard.dispose();
        return enabled;
    }

    static String fileDialog(View view, String title, boolean saving, String defaultFile) {
        Shell frame;
        Shell shell = frame = view != null && view.window() != null ? view.window().getShell() : null;
        if (frame == null) {
            return defaultFile;
        }
        FileDialog fileDialog = new FileDialog(frame, saving ? 8192 : 4096);
        fileDialog.setText(title);
        if (defaultFile != null) {
            fileDialog.setFileName(defaultFile);
        }
        String fileName = fileDialog.open();
        fileDialog = null;
        return fileName;
    }

    static String getVersion() {
        String version = null;
        String build = null;
        Package lpex = Package.getPackage("com.ibm.lpex.core");
        if (lpex != null) {
            version = lpex.getSpecificationVersion();
            build = lpex.getImplementationVersion();
        }
        if (LpexPlugin.getDefault() != null) {
            version = LpexPlugin.getDefault().getBundle().getVersion().toString();
            build = null;
        }
        if (version == null) {
            version = "3.6.0";
        }
        String query = "LPEX " + version;
        if (build != null) {
            query = query + " (build " + build + ")";
        }
        return query;
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    static void viewListenerListUpdateProfile(ViewListenerList viewListenerList) {
        Display display = Display.getCurrent();
        if (display != null) {
            viewListenerList.fireUpdateProfile();
        } else {
            Display.getDefault().syncExec((Runnable)new ViewListenerListUpdateProfile(viewListenerList));
        }
    }

    static void setImeInputMethod(LpexView lpexView) {
        lpexView.window().getShell().setImeInputMode(18);
    }

    public static Widget commandLineFocusWidget(LpexView lpexView) {
        LpexWindow lpexWindow = lpexView != null && lpexView._view != null ? lpexView._view.window() : null;
        return lpexWindow != null ? ((CommandLine)lpexWindow.commandLine()).inputFocusWidget() : null;
    }

    static boolean isBidi() {
        if (!_bidiChecked) {
            _bidiChecked = true;
            String nativeEncoding = LpexNls.getNativeEncoding();
            if (LpexNls.isBidiEncoding(nativeEncoding) && LpexNls.isValidEncoding(nativeEncoding)) {
                try {
                    _isBidi = BidiUtil.isBidiPlatform();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return _isBidi;
    }

    static void setKeyboardLanguage(int newKeyboardDirection) {
        int newLanguage;
        int current = BidiUtil.getKeyboardLanguage();
        if (newKeyboardDirection == 1) {
            if (current == 1) {
                return;
            }
            newLanguage = 1;
        } else {
            if (current == 0) {
                return;
            }
            newLanguage = 0;
        }
        BidiUtil.setKeyboardLanguage((int)newLanguage);
    }

    static int getKeyboardLanguage() {
        return BidiUtil.getKeyboardLanguage() == 1 ? 1 : 0;
    }

    static void addLanguageListener(Control control, Runnable runnable) {
        Class<?> control_class = control.getClass();
        try {
            Field field = control_class.getField("handle");
            arg_AddLL = is64bit ? new Object[]{field.getLong(control), runnable} : new Object[]{field.getInt(control), runnable};
            m_AddLL.invoke(null, arg_AddLL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void removeLanguageListener(Control control) {
        Class<?> control_class = control.getClass();
        try {
            Field field = control_class.getField("handle");
            arg_RemoveLL = is64bit ? new Object[]{field.getLong(control)} : new Object[]{field.getInt(control)};
            m_RemoveLL.invoke(null, arg_RemoveLL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getUserHomeDirectory() {
        return LpexInternalUtilities.getUserHomeDirectory();
    }

    public static String fontDataToString(FontData[] fontData) {
        StringBuilder sb = new StringBuilder(80);
        if (fontData != null) {
            int i = 0;
            while (i < fontData.length) {
                if (fontData[i] != null) {
                    if (sb.length() != 0) {
                        sb.append(';');
                    }
                    sb.append(fontData[i].toString());
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static FontData[] fontDataFromString(String fontDataString) {
        if (fontDataString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(fontDataString, ";");
        int numTokens = tokenizer.countTokens();
        FontData[] fontData = new FontData[numTokens];
        try {
            int i = 0;
            while (i < numTokens) {
                fontData[i] = new FontData(tokenizer.nextToken());
                ++i;
            }
        }
        catch (IllegalArgumentException x) {
            return null;
        }
        return fontData;
    }

    static void setSplitWindowOrientationParm(View view, String value) {
        Composite parent;
        LpexWindow lpexWindow;
        if (view != null && (lpexWindow = view.window()) != null && !lpexWindow.isDisposed() && (parent = lpexWindow.getParent()) != null && parent instanceof LpexMultiWindow) {
            ((LpexMultiWindow)parent).setOrientationParm(value);
        }
    }

    static String splitWindowOrientationParm(View view) {
        Composite parent;
        LpexWindow lpexWindow;
        String value = null;
        if (view != null && (lpexWindow = view.window()) != null && !lpexWindow.isDisposed() && (parent = lpexWindow.getParent()) != null && parent instanceof LpexMultiWindow) {
            value = ((LpexMultiWindow)parent).orientationParm();
        }
        return value;
    }

    static void splitWindowOrientationChanged(View view) {
        Composite parent;
        LpexWindow lpexWindow;
        if (view != null && (lpexWindow = view.window()) != null && !lpexWindow.isDisposed() && (parent = lpexWindow.getParent()) != null && parent instanceof LpexMultiWindow) {
            String orientation = SplitWindowParameters.OrientationParameter.getParameter().currentValue(view);
            ((LpexMultiWindow)parent).setOrientation(orientation);
        }
    }

    static String getLookAndFeels() {
        return null;
    }

    static String getLookAndFeel() {
        return null;
    }

    static boolean setLookAndFeel(String lookAndFeelName) {
        return false;
    }

    public static void setHelp(MenuItem menuItem, String contextHelpId) {
        if (_runningWorkbench != null && contextHelpId != null) {
            _runningWorkbench.getHelpSystem().setHelp(menuItem, contextHelpId);
        }
    }

    public static void setHelp(Control control, String contextHelpId) {
        if (_runningWorkbench != null && contextHelpId != null) {
            _runningWorkbench.getHelpSystem().setHelp(control, contextHelpId);
        }
    }

    static class GetSelectionColors
    implements Runnable {
        Color[] _colors;

        GetSelectionColors(Color[] colors) {
            this._colors = colors;
        }

        @Override
        public void run() {
            Display display = Display.getCurrent();
            this._colors[0] = display.getSystemColor(27);
            this._colors[1] = display.getSystemColor(26);
        }
    }

    static class ViewListenerListUpdateProfile
    implements Runnable {
        ViewListenerList _viewListenerList;

        ViewListenerListUpdateProfile(ViewListenerList viewListenerList) {
            this._viewListenerList = viewListenerList;
        }

        @Override
        public void run() {
            this._viewListenerList.fireUpdateProfile();
        }
    }
}

