/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActiveWindowListenerList;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexActiveWindowListener;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.TitleLine;
import com.ibm.lpex.core.View;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class LpexMultiWindow
extends SashForm {
    private static final int MAX_WINDOWS = 5;
    private String _splitWindowOrientationParm;
    private List _windows = new List();
    private LpexWindow _focusWindow;
    private LpexWindow _lastFocusWindow;
    private ActiveWindowListenerList _activeWindowListenerList;

    public LpexMultiWindow(Composite parent, int style) {
        super(parent, style);
        this.setOrientation(LpexView.globalQuery("current.splitWindow.orientation"));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LpexMultiWindow.this.handleDisposed();
            }
        });
    }

    public LpexWindow newWindow(LpexView lpexView, int style) {
        if (this._windows.first() != null && this.count() >= this.getMaxWindows()) {
            return null;
        }
        LpexWindow newLpexWindow = this.createLpexWindow(style);
        newLpexWindow.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                LpexMultiWindow.this.handleLpexWindowFocusGained((LpexWindow)e.widget);
            }

            public void focusLost(FocusEvent e) {
                LpexMultiWindow.this.handleLpexWindowFocusLost((LpexWindow)e.widget);
            }
        });
        newLpexWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LpexMultiWindow.this.handleLpexWindowDisposed(e);
            }
        });
        this._windows.append(new WindowNode(newLpexWindow));
        if (lpexView != null) {
            lpexView.setWindow(newLpexWindow);
            lpexView.addLpexViewListener(new LpexViewAdapter(){

                @Override
                public void renamed(LpexView view) {
                    LpexMultiWindow.this.updateTitleName(view.window());
                }
            });
        }
        this.layout();
        this.updateTitles();
        return newLpexWindow;
    }

    public LpexWindow createLpexWindow(int style) {
        return new LpexWindow((Composite)this, style);
    }

    private void handleLpexWindowFocusGained(LpexWindow lpexWindow) {
        if (this.getMaximizedControl() != null && this.getMaximizedControl() != lpexWindow) {
            this.setMaximizedControl(null);
        }
        this._focusWindow = lpexWindow;
        this.updateTitleActive(lpexWindow);
        if (this._lastFocusWindow != lpexWindow) {
            this.newActiveWindow(lpexWindow);
            this._lastFocusWindow = lpexWindow;
        }
    }

    private void handleLpexWindowFocusLost(LpexWindow lpexWindow) {
        this._focusWindow = null;
        this.updateTitleActive(lpexWindow);
    }

    public void addActiveWindowListener(LpexActiveWindowListener activeWindowListener) {
        if (this._activeWindowListenerList == null) {
            this._activeWindowListenerList = new ActiveWindowListenerList();
        }
        this._activeWindowListenerList.addListener(activeWindowListener);
    }

    public void removeActiveWindowListener(LpexActiveWindowListener activeWindowListener) {
        if (this._activeWindowListenerList != null) {
            this._activeWindowListenerList.removeListener(activeWindowListener);
        }
    }

    private void newActiveWindow(LpexWindow lpexWindow) {
        if (this._activeWindowListenerList != null) {
            this._activeWindowListenerList.activeWindowChanged(lpexWindow);
        }
    }

    public boolean setFocus() {
        LpexWindow lpexWindow = this._lastFocusWindow != null ? this._lastFocusWindow : this.getFirstWindow();
        return LpexUtilities.okToUse((Widget)lpexWindow) ? lpexWindow.setFocus() : false;
    }

    /*
     * Unable to fully structure code
     */
    private void updateTitles() {
        block3: {
            node = (WindowNode)this._windows.first();
            if (node == null) {
                return;
            }
            if (node.next() != null) ** GOTO lbl14
            node.lpexWindow().titleLine().setVisible(false);
            break block3;
lbl-1000:
            // 1 sources

            {
                lpexWindow = node.lpexWindow();
                this.updateTitleActive(lpexWindow);
                this.updateTitleName(lpexWindow);
                if (!lpexWindow.titleLine().getVisible()) {
                    lpexWindow.titleLine().setVisible(true);
                    lpexWindow.layout();
                }
                node = (WindowNode)node.next();
lbl14:
                // 2 sources

                ** while (node != null)
            }
        }
    }

    private void updateTitleName(LpexWindow lpexWindow) {
        if (lpexWindow != null && !lpexWindow.isDisposed()) {
            View view;
            Object title = "";
            View view2 = view = lpexWindow.getLpexView() != null ? lpexWindow.getLpexView()._view : null;
            if (view != null) {
                title = view.document().sourceName();
                if (title == null && (title = view.document().name()) == null) {
                    title = LpexResources.message("untitledDocument", view.document().id());
                }
                title = (String)title + ": " + view.id();
            }
            ((TitleLine)lpexWindow.titleLine()).setText((String)title);
        }
    }

    private void updateTitleActive(LpexWindow lpexWindow) {
        ((TitleLine)lpexWindow.titleLine()).setActive(lpexWindow == this._focusWindow);
    }

    public LpexWindow getFirstWindow() {
        WindowNode firstNode = (WindowNode)this._windows.first();
        return firstNode != null && !firstNode.removePending() ? firstNode.lpexWindow() : null;
    }

    public LpexWindow getWindow() {
        return this._focusWindow != null ? this._focusWindow : this.getFirstWindow();
    }

    public LpexView getActiveView() {
        LpexWindow activeWindow = this._lastFocusWindow != null && !this._lastFocusWindow.isDisposed() ? this._lastFocusWindow : this.getFirstWindow();
        return activeWindow != null && !activeWindow.isDisposed() ? activeWindow.getLpexView() : null;
    }

    public LpexWindow getWindow(int x, int y) {
        if (x >= 0 && y >= 0) {
            List.Node node = this._windows.first();
            while (node != null) {
                if (!node.removePending()) {
                    LpexWindow lpexWindow = ((WindowNode)node).lpexWindow();
                    Rectangle bounds = lpexWindow.getBounds();
                    if (x >= bounds.x && x <= bounds.x + bounds.width && y >= bounds.y && y <= bounds.y + bounds.height) {
                        return lpexWindow;
                    }
                }
                node = node.next();
            }
        }
        return null;
    }

    public LpexWindow[] getWindows() {
        LpexWindow[] array = new LpexWindow[this.count()];
        int i = 0;
        WindowNode node = (WindowNode)this._windows.first();
        while (node != null) {
            if (!node.removePending()) {
                array[i++] = node.lpexWindow();
            }
            node = (WindowNode)node.next();
        }
        return array;
    }

    public int getMaxWindows() {
        return 5;
    }

    private int count() {
        int count = 0;
        List.Node node = this._windows.first();
        while (node != null) {
            if (!node.removePending()) {
                ++count;
            }
            node = node.next();
        }
        return count;
    }

    private WindowNode find(LpexWindow lpexWindow) {
        WindowNode node = (WindowNode)this._windows.first();
        while (node != null && node.lpexWindow() != lpexWindow) {
            node = (WindowNode)node.next();
        }
        return node;
    }

    void setOrientationParm(String newOrientationParm) {
        this._splitWindowOrientationParm = newOrientationParm;
    }

    String orientationParm() {
        return this._splitWindowOrientationParm;
    }

    void setOrientation(String newOrientation) {
        this.setOrientation("horizontal".equals(newOrientation) ? 512 : 256);
    }

    void toggleMaximize(LpexWindow lpexWindow) {
        if (this.getMaximizedControl() != null) {
            this.setMaximizedControl(null);
        } else {
            View view;
            View view2 = view = lpexWindow.getLpexView() != null ? lpexWindow.getLpexView()._view : null;
            if (view != null && view.screen().scroll() != 0) {
                view.screen().setScroll(0);
            }
            this.setMaximizedControl((Control)lpexWindow);
        }
    }

    public void closeWindow(LpexWindow lpexWindow) {
        WindowNode node = this.find(lpexWindow);
        if (node != null) {
            LpexView lpexView;
            WindowNode nextWindowNode = (WindowNode)node.next();
            if (this.getMaximizedControl() == lpexWindow) {
                this.setMaximizedControl(null);
            }
            if ((lpexView = lpexWindow.getLpexView()) != null) {
                lpexView.dispose();
            }
            lpexWindow.dispose();
            if (nextWindowNode == null) {
                nextWindowNode = (WindowNode)this._windows.first();
            }
            if (nextWindowNode != null) {
                LpexWindow lw;
                if (!(lpexWindow != this._focusWindow && lpexWindow != this._lastFocusWindow || (lw = nextWindowNode.lpexWindow()) == null || lw.isDisposed())) {
                    lw.setFocus();
                }
            } else {
                this.newActiveWindow(null);
            }
            this.updateTitles();
            this.layout();
        }
    }

    private void handleLpexWindowDisposed(DisposeEvent e) {
        WindowNode node = this.find((LpexWindow)((Object)e.getSource()));
        if (node != null) {
            this._windows.remove(node);
        }
    }

    private void handleDisposed() {
        this._windows.beginScanning();
        WindowNode node = (WindowNode)this._windows.first();
        while (node != null) {
            LpexView lpexView = node.lpexWindow().getLpexView();
            if (lpexView != null) {
                lpexView.dispose();
            }
            node = (WindowNode)node.next();
        }
        this._windows.endScanning();
        this._windows.clear();
        if (this._activeWindowListenerList != null) {
            this._activeWindowListenerList.clear();
        }
    }

    private static class WindowNode
    extends ListNode {
        private LpexWindow _lpexWindow;

        WindowNode(LpexWindow lpexWindow) {
            this._lpexWindow = lpexWindow;
        }

        LpexWindow lpexWindow() {
            return this._lpexWindow;
        }
    }
}

