/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.View;

public final class LpexMatch {
    private static final String DEFAULT_BRA = "({[<\u00ab\u2039\u2329\u27e8\u3008\u300a";
    private static final String DEFAULT_KET = ")}]>\u00bb\u203a\u232a\u27e9\u3009\u300b";

    private LpexMatch() {
    }

    public static LpexDocumentLocation match(LpexView lpexView, LpexDocumentLocation loc) {
        return LpexMatch.match(lpexView, loc, false);
    }

    public static LpexDocumentLocation match(LpexView lpexView, LpexDocumentLocation loc, boolean noisy) {
        char match;
        int dir;
        int i = loc.position - 1;
        if (i < 0) {
            return null;
        }
        if (lpexView == null) {
            return null;
        }
        View view = lpexView._view;
        ElementList elementList = view.document().elementList();
        Element element = elementList.elementAt(loc.element);
        if (element == null) {
            return null;
        }
        if (element.show()) {
            return null;
        }
        String text = element.text();
        int len = text.length();
        if (i >= len) {
            return null;
        }
        char bracket = text.charAt(i);
        int j = DEFAULT_BRA.indexOf(bracket);
        if (j >= 0) {
            dir = 1;
            match = DEFAULT_KET.charAt(j);
        } else {
            j = DEFAULT_KET.indexOf(bracket);
            if (j >= 0) {
                match = DEFAULT_BRA.charAt(j);
                dir = -1;
            } else {
                if (noisy) {
                    view.setLpexMessageText("match.char", String.valueOf(bracket));
                }
                return null;
            }
        }
        String style = element.elementView(view).style();
        int fnt = style.length() > i ? (int)style.charAt(i) : 33;
        int nesting = 0;
        while (true) {
            if (!(dir > 0 ? i >= len : i < 0)) {
                int ft;
                char ch = text.charAt(i);
                int n = ft = style.length() > i ? (int)style.charAt(i) : 33;
                if (ft == fnt && ch == bracket) {
                    ++nesting;
                } else if (ft == fnt && ch == match && --nesting == 0) {
                    return new LpexDocumentLocation(elementList.ordinalOf(element), i + 1);
                }
                i += dir;
                continue;
            }
            Element element2 = element = dir > 0 ? element.nextNonShow() : element.prevNonShow();
            if (element == null) break;
            text = element.text();
            style = element.elementView(view).style();
            len = text.length();
            i = dir > 0 ? 0 : len - 1;
        }
        if (noisy) {
            view.setLpexMessageText(dir > 0 ? "match.end" : "match.start");
        }
        return null;
    }
}

