/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.LpexPlugin;
import com.ibm.lpex.core.LpexInternalUtilities;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.View;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class LpexLog {
    private static String _name;

    private LpexLog() {
    }

    static String name() {
        if (_name == null) {
            _name = LpexInternalUtilities.getUserHomeDirectory() + File.separator + "Editor.log";
        }
        return _name;
    }

    static boolean setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        if (name != null) {
            File log;
            block5: {
                try {
                    log = new File(name);
                    if (!log.isDirectory() && (!log.exists() || log.canWrite())) break block5;
                    return false;
                }
                catch (Exception x) {
                    return false;
                }
            }
            name = log.getCanonicalPath();
        }
        _name = name;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void logMessageText(View view, String messageText) {
        if (messageText == null) return;
        if (messageText.length() <= 0) return;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(LpexLog.name(), true);
                try {
                    block21: {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
                        try {
                            try (PrintWriter log = new PrintWriter(osw);){
                                log.print("!ENTRY ");
                                log.println(DateFormat.getInstance().format(new Date()));
                                if (view != null) {
                                    log.print("!VIEW ");
                                    log.println(LpexLog.viewName(view));
                                }
                                log.print("!MESSAGETEXT ");
                                log.println(messageText);
                                log.println();
                                log.flush();
                                log.close();
                            }
                            if (osw == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (osw == null) throw throwable;
                            osw.close();
                            throw throwable;
                        }
                        osw.close();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception x) {
            System.err.println("** " + String.valueOf(new Date()) + " Unrecoverable error while writing to the editor log:");
            System.err.println(messageText);
        }
    }

    public static void log(String message) {
        LpexLog.log(null, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(View view, String message) {
        LpexLog.logToEclipse(view, message, null);
        if (message == null) return;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(LpexLog.name(), true);
                try {
                    block21: {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
                        try {
                            try (PrintWriter log = new PrintWriter(osw);){
                                log.print("!ENTRY ");
                                log.println(DateFormat.getInstance().format(new Date()));
                                if (view != null) {
                                    log.print("!VIEW ");
                                    log.println(LpexLog.viewName(view));
                                }
                                log.print("!MESSAGE ");
                                log.println(message);
                                log.println();
                                log.flush();
                                log.close();
                            }
                            if (osw == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (osw == null) throw throwable;
                            osw.close();
                            throw throwable;
                        }
                        osw.close();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception x) {
            System.err.println("** " + String.valueOf(new Date()) + " Unrecoverable error while writing to the editor log:");
            System.err.println(message);
        }
    }

    public static void log(Throwable throwable) {
        LpexLog.log(null, null, throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void log(View view, String message, Throwable throwable) {
        LpexLog.logToEclipse(view, message, throwable);
        try {
            Throwable throwable2 = null;
            Object var4_6 = null;
            try {
                FileOutputStream fos = new FileOutputStream(LpexLog.name(), true);
                try {
                    block24: {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
                        try {
                            try (PrintWriter log = new PrintWriter(osw);){
                                log.print("!ENTRY ");
                                log.println(DateFormat.getInstance().format(new Date()));
                                if (view != null) {
                                    log.print("!VIEW ");
                                    log.println(LpexLog.viewName(view));
                                }
                                if (message != null) {
                                    log.print("!MESSAGE ");
                                    log.println(message);
                                }
                                if (throwable != null) {
                                    if (throwable.getMessage() != null) {
                                        log.print("!MESSAGE ");
                                        log.println(throwable.getMessage());
                                    }
                                    log.println("!STACK");
                                    throwable.printStackTrace(log);
                                }
                                log.println();
                                log.flush();
                                log.close();
                            }
                            if (osw == null) break block24;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (osw == null) throw throwable2;
                            osw.close();
                            throw throwable2;
                        }
                        osw.close();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    if (fos == null) throw throwable2;
                    fos.close();
                    throw throwable2;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                    throw throwable2;
                }
                if (throwable2 == throwable5) throw throwable2;
                throwable2.addSuppressed(throwable5);
                throw throwable2;
            }
        }
        catch (Exception x) {
            System.err.println("** " + String.valueOf(new Date()) + " Unrecoverable error while writing to the editor log:");
            if (throwable == null) return;
            throwable.printStackTrace();
        }
    }

    private static void logToEclipse(View view, String message, Throwable throwable) {
        StringBuilder fullMessage = new StringBuilder();
        if (message != null) {
            fullMessage.append(message);
        }
        if (view != null) {
            if (fullMessage.length() > 0) {
                fullMessage.append('\n');
            }
            fullMessage.append("!VIEW ");
            fullMessage.append(LpexLog.viewName(view));
        }
        if (throwable == null) {
            LpexPlugin.getDefault().getLog().log((IStatus)new Status(2, "com.ibm.lpex", fullMessage.toString(), null));
        } else {
            LpexPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.lpex", fullMessage.toString(), throwable));
        }
    }

    private static String viewName(View view) {
        Object title = "";
        if (view != null) {
            title = view.document().sourceName();
            if (title == null && (title = view.document().name()) == null) {
                title = LpexResources.message("untitledDocument", view.document().id());
            }
            if (view.documentViews() > 1) {
                title = (String)title + ":" + view.id();
            }
        }
        return title;
    }
}

