/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionUtilities;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexConstants;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.ParseAfterEveryKeyParameter;
import com.ibm.lpex.core.PopupParameter;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesParameter;
import com.ibm.lpex.core.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;

public abstract class LpexCommonParser
implements LpexParser,
LpexConstants {
    private boolean _initialized;
    private boolean _totalParsed;
    protected LpexView view;
    private LpexView _lpexView;
    private View _view;
    private ParserMessage _messages;
    private ParserMessage _lastMessage;
    private DocMessage _docMessages;
    private DocMessage _lastDocMessage;
    private ParserRange _parserRanges;
    private DocRange _docRanges;
    private long _classMessage;
    private boolean _tokenHighlight;
    private boolean _errorMessages;
    private boolean _autoIndent;
    private boolean _maintainBidiMarks;
    private StringBuilder _styles;
    private ArrayList<String> _installStyleAttributes;
    public static final String CLASS_MESSAGE = "Message";
    public static final char STYLE_MESSAGE = 'M';
    public static final String LANGUAGE_CCPP = "CPP";
    public static final String LANGUAGE_CICS = "CICS";
    public static final String LANGUAGE_CL = "CL";
    public static final String LANGUAGE_COBOL = "COBOL";
    public static final String LANGUAGE_COBOL400 = "COBOL400";
    public static final String LANGUAGE_COBOLILE = "COBOLILE";
    public static final String LANGUAGE_DLI = "DLI";
    public static final String LANGUAGE_DDS = "DDS";
    public static final String LANGUAGE_FORTRAN = "Fortran";
    public static final String LANGUAGE_HLASM = "HLASM";
    public static final String LANGUAGE_HTML = "HTML";
    public static final String LANGUAGE_JAVA = "Java";
    public static final String LANGUAGE_JCL = "JCL";
    public static final String LANGUAGE_LISP = "Lisp";
    public static final String LANGUAGE_PERL = "Perl";
    public static final String LANGUAGE_PLI = "PLI";
    public static final String LANGUAGE_REXX = "REXX";
    public static final String LANGUAGE_RPG = "RPG";
    public static final String LANGUAGE_RPGLEFIXED = "RPGLEFIXED";
    public static final String LANGUAGE_RPGLEFREE = "RPGLEFREE";
    public static final String LANGUAGE_SABRETALK = "SabreTalk";
    public static final String LANGUAGE_SQL = "SQL";
    public static final String LANGUAGE_XMI = "XMI";
    public static final String LANGUAGE_XML = "XML";
    public static final String LANGUAGE_XSL = "XSL";
    public static final String PROTOKEY_EMPTY = "proto.%EMPTY%";
    public static final String STYLE_NAME = "styleName.";
    public static final String BACKGROUND_COLOR = "255 255 255";
    public final String ATTRIBUTES_DEFAULT;
    public static final String ATTRIBUTES_COMMENT = "0 112 112 255 255 255";
    public static final String ATTRIBUTES_COMMENT1 = "0 112 112 255 255 255";
    public static final String ATTRIBUTES_COMMENT_KEYWORD = "0 160 160 255 255 255";
    public static final String ATTRIBUTES_ERROR = "-1 -1 -1 255 255 255 255 0 0 squiggle";
    public static final String ATTRIBUTES_ERROR1 = "0 0 170 255 255 255 255 0 0 squiggle";
    public static final String ATTRIBUTES_KEYWORD = "0 0 255 255 255 255";
    public static final String ATTRIBUTES_KEYWORD1 = "0 0 205 255 255 255";
    public static final String ATTRIBUTES_LIBRARY = "0 0 128 255 255 255";
    public static final String ATTRIBUTES_NUMERAL = "128 0 0 255 255 255";
    public static final String ATTRIBUTES_STRING = "128 0 128 255 255 255";
    public static final String ATTRIBUTES_STRING1 = "189 89 189 255 255 255";
    public static final String ATTRIBUTES_DIRECTIVE = "0 0 255 255 255 255 underline";
    public static final String ATTRIBUTES_NONSOURCE = "192 192 192 255 255 255";
    public static final int LEXER_RC_OK = 0;
    public static final int LEXER_RC_EOF = 1;
    public static final int LEXER_RC_END = 2;
    public static final int LEXER_RC_MORE = 4;
    public static final int POPUP_TOP = 0;
    public static final int POPUP_FILTERVIEW = 1;
    public static final int POPUP_SOURCE = 2;
    public static final int POPUP_END = 3;

    public abstract void parseAll();

    public abstract void parseElement(int var1);

    protected LpexCommonParser(LpexView lpexView) {
        this.view = lpexView;
        this._lpexView = lpexView;
        this._view = this._lpexView._view;
        this.ATTRIBUTES_DEFAULT = LpexPaletteAttributes.convert(this._lpexView.query("styleAttributes.parserDefault"), LpexPaletteAttributes.background(this._lpexView), BACKGROUND_COLOR);
        this._view.styleAttributesList().set('M', StyleAttributes.getStyleAttributes(this._lpexView.query("styleAttributes.parserMessage")));
        this._classMessage = this._lpexView.registerClass(CLASS_MESSAGE);
    }

    private void internalInit() {
        this._errorMessages = !"off".equals(this.getProperty("view.errorMessages"));
        this._autoIndent = !"off".equals(this.getProperty("view.autoIndent"));
        this._tokenHighlight = !"off".equals(this.getProperty("view.tokenHighlight"));
        this._maintainBidiMarks = "on".equals(this.getProperty("view.maintainBidiMarks"));
        this.setWordIterOptions(this.getProperty("view.wordBreaks"));
        String parseAfterEveryKey = this.getProperty("view.parseAfterEveryKey");
        if ("bidi".equals(parseAfterEveryKey)) {
            String string = parseAfterEveryKey = LpexUtilities.isBidi() ? "on" : null;
        }
        if (parseAfterEveryKey == null) {
            parseAfterEveryKey = "default";
        }
        ParseAfterEveryKeyParameter.getParameter().set(this._view, null, parseAfterEveryKey);
        this.defineActions();
    }

    private void completeInternalInit() {
        this.definePopup();
    }

    private void defineActions() {
        this._lpexView.defineAction("blockMarkWord", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                LpexCommonParser.this.blockMarkWord();
            }

            @Override
            public boolean available(LpexView v) {
                return v.defaultActionAvailable(58);
            }
        });
        this._lpexView.defineAction("findMatch", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                LpexCommonParser.this.findMatch();
            }

            @Override
            public boolean available(LpexView v) {
                return v.defaultActionAvailable(111);
            }
        });
        this._lpexView.defineAction("match", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                v._view.ensureIsParsed();
                LpexDocumentLocation loc = v.documentLocation();
                LpexDocumentLocation match = LpexCommonParser.this.matchToken(loc);
                if (match != null && (match.element != loc.element || match.position != loc.position)) {
                    v._view.block().clear();
                    v._view.block().set(2, v._view);
                    v._view.commandHandler().doCommand(match, "block set");
                } else {
                    v.doDefaultAction(141);
                }
            }

            @Override
            public boolean available(LpexView v) {
                return v.defaultActionAvailable(141);
            }
        });
        this._lpexView.defineAction("indentText", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                int currentPosition = v.queryInt("displayPosition");
                if (currentPosition > 0) {
                    int currentElement = v.currentElement();
                    LpexCommonParser.this._view.setIgnoreFields();
                    LpexCommonParser.this.indentText(currentElement, LpexCommonParser.this.getTextIndent(currentElement));
                    LpexCommonParser.this._view.resetIgnoreFields();
                    v.doDefaultCommand("set displayPosition " + currentPosition);
                }
            }

            @Override
            public boolean available(LpexView v) {
                return true;
            }
        });
        this._lpexView.defineAction("newLine", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                LpexCommonParser.this.newLine();
            }

            @Override
            public boolean available(LpexView v) {
                return v.defaultActionAvailable(143);
            }
        });
        this._lpexView.defineAction("openLine", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                LpexCommonParser.this.openLine();
            }

            @Override
            public boolean available(LpexView v) {
                return v.defaultActionAvailable(148);
            }
        });
        this._lpexView.defineAction("splitLine", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                LpexCommonParser.this.splitLine();
            }

            @Override
            public boolean available(LpexView v) {
                return v.defaultActionAvailable(194);
            }
        });
        this._lpexView.defineAction("proto", new LpexAction(){

            @Override
            public void doAction(LpexView v) {
                LpexCommonParser.this.proto();
            }

            @Override
            public boolean available(LpexView v) {
                return !v._view.readonly() && v._view.documentPosition().element() != null;
            }
        });
        if (!this._lpexView.keyAssigned("c-r.t")) {
            this._view.actionHandler().defineKeyAction("c-r.t", "proto");
        }
        if (!this._lpexView.keyAssigned("c-r.c")) {
            this._view.actionHandler().defineKeyAction("c-r.c", "proto");
        }
    }

    private void definePopup() {
        String topItems = this.getPopupItems(0);
        String filterItems = this.getPopupItems(1);
        String sourceItems = this.getPopupItems(2);
        String endItems = this.getPopupItems(3);
        if (topItems != null || filterItems != null || sourceItems != null || endItems != null) {
            int i;
            String popup = PopupParameter.getParameter().currentValue(this._view);
            if (popup == null) {
                popup = "";
            }
            StringBuilder buffer = new StringBuilder(popup.length() + 320);
            buffer.append(popup);
            if (sourceItems != null) {
                i = popup.indexOf("popup.sourceMenu");
                if (i >= 0) {
                    buffer.insert(i += "popup.sourceMenu".length(), sourceItems).insert(i, ' ');
                } else {
                    i = popup.indexOf("MARK-Source");
                    if (i >= 0) {
                        buffer.insert(i += "MARK-Source".length(), " endSubmenu separator").insert(i, sourceItems).insert(i, " beginSubmenu popup.sourceMenu ");
                    }
                }
            }
            if (filterItems != null) {
                i = popup.indexOf("popup.filterViewMenu");
                if (i >= 0) {
                    buffer.insert(i += "popup.filterViewMenu".length(), filterItems).insert(i, ' ');
                } else {
                    i = popup.indexOf("popup.showAll");
                    if (i >= 0) {
                        buffer.insert(i, " endSubmenu ").insert(i, filterItems).insert(i, "beginSubmenu popup.filterViewMenu ");
                    } else {
                        buffer.append(" beginSubmenu popup.filterViewMenu ").append(filterItems).append(" endSubmenu");
                    }
                }
            }
            if (endItems != null) {
                buffer.append(" separator ").append(endItems);
            }
            if (topItems != null) {
                buffer.insert(0, ' ').insert(0, topItems);
            }
            this._view.setPopup(buffer.toString());
        }
    }

    public final LpexView lpexView() {
        return this._lpexView;
    }

    void _initializeParser() {
        if (!this._initialized) {
            this.internalInit();
            this.initParser();
            this.completeInternalInit();
            this._initialized = true;
        }
    }

    @Override
    public final void totalParse() {
        if (!this._initialized || this._lpexView.elements() == 0) {
            return;
        }
        this.parseAll();
        this.displayEmbeddedMessages();
        this._totalParsed = true;
    }

    @Override
    public final void parse(int element) {
        if (element == 0 || this._view.document().elementList().first() == null) {
            return;
        }
        this.parseElement(element);
        this.displayEmbeddedMessages();
    }

    @Override
    public final void resetParser() {
        this.terminateParser();
        this._styles = null;
        if (this._installStyleAttributes != null) {
            this._installStyleAttributes.clear();
            this._installStyleAttributes = null;
        }
        this.clearEmbeddedMessages();
    }

    public String getLanguage() {
        return null;
    }

    public String getLanguage(LpexDocumentLocation loc) {
        return this.getLanguage();
    }

    public ResourceBundle getProfile() {
        return null;
    }

    @Override
    public String getProperty(String key) {
        String property = this.internalGetProperty(key);
        if (property == null && key != null && key.length() == STYLE_NAME.length() + 1 && key.startsWith(STYLE_NAME)) {
            property = this.getStyleName(key.charAt(STYLE_NAME.length()));
        }
        return property;
    }

    private String internalGetProperty(String key) {
        String property = null;
        if (key != null) {
            String lang = this.getLanguage();
            boolean viewQuery = key.startsWith("view.");
            if (viewQuery) {
                key = key.substring("view.".length());
            }
            if (viewQuery && lang != null && (property = this._view.parserProperties().get(lang + "." + key)) != null) {
                return property;
            }
            if (viewQuery || key.startsWith("document.")) {
                if (!viewQuery) {
                    key = key.substring("document.".length());
                }
                if (lang != null && (property = this._view.document().parserProperties().get(lang + "." + key)) != null) {
                    return property;
                }
            }
            if (lang != null && (property = Profile.getString(lang + "." + key)) != null) {
                return property;
            }
            ResourceBundle profile = this.getProfile();
            if (profile != null) {
                try {
                    return profile.getString(key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return property;
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            return;
        }
        String lang = this.getLanguage();
        if (key.startsWith("view.")) {
            key = key.substring("view.".length());
            if (lang != null) {
                HashMap<String, String> viewParserProperties = this._view.parserProperties();
                if (value == null) {
                    viewParserProperties.remove(lang + "." + key);
                } else {
                    viewParserProperties.put(lang + "." + key, value);
                }
            }
            this.internalPropertySet(key);
        } else if (key.startsWith("document.")) {
            key = key.substring("document.".length());
            if (lang != null) {
                HashMap<String, String> documentParserProperties = this._view.document().parserProperties();
                if (value == null) {
                    documentParserProperties.remove(lang + "." + key);
                } else {
                    documentParserProperties.put(lang + "." + key, value);
                }
            }
            View v = this._view.document()._firstView;
            while (v != null) {
                LpexParser lpexParser = v.parsePendingList().lpexParser();
                if (lpexParser instanceof LpexCommonParser) {
                    LpexCommonParser parser = (LpexCommonParser)lpexParser;
                    if (lang != null && lang.equals(parser.getLanguage()) || lang == null && this.getClass().equals(parser.getClass())) {
                        parser.internalPropertySet(key);
                    }
                }
                v = v._next;
            }
        } else {
            if (lang != null) {
                Profile.putString(lang + "." + key, value);
            }
            Document document = Document._firstDocument;
            while (document != null) {
                View v = document._firstView;
                while (v != null) {
                    LpexParser lpexParser = v.parsePendingList().lpexParser();
                    if (lpexParser instanceof LpexCommonParser) {
                        LpexCommonParser parser = (LpexCommonParser)lpexParser;
                        if (lang != null && lang.equals(parser.getLanguage()) || lang == null && this.getClass().equals(parser.getClass())) {
                            parser.internalPropertySet(key);
                        }
                    }
                    v = v._next;
                }
                document = document._next;
            }
        }
    }

    private void internalPropertySet(String key) {
        if ("maintainBidiMarks".equals(key)) {
            boolean oldMaintainBidiMarks = this._maintainBidiMarks;
            this._maintainBidiMarks = "on".equals(this.getProperty("view.maintainBidiMarks"));
            if (this._totalParsed && this._maintainBidiMarks != oldMaintainBidiMarks) {
                this.totalParse();
            }
        } else if ("wordBreaks".equals(key)) {
            this.setWordIterOptions(this.getProperty("view.wordBreaks"));
        } else if ("autoIndent".equals(key)) {
            this._autoIndent = !"off".equals(this.getProperty("view.autoIndent"));
        } else if ("errorMessages".equals(key)) {
            this._errorMessages = !"off".equals(this.getProperty("view.errorMessages"));
        } else if ("parseAfterEveryKey".equals(key)) {
            String parseAfterEveryKey = this.getProperty("view.parseAfterEveryKey");
            if ("bidi".equals(parseAfterEveryKey)) {
                String string = parseAfterEveryKey = LpexUtilities.isBidi() ? "on" : null;
            }
            if (parseAfterEveryKey == null) {
                parseAfterEveryKey = "default";
            }
            ParseAfterEveryKeyParameter.getParameter().set(this._view, null, parseAfterEveryKey);
        }
        this.propertySet(key);
    }

    protected void propertySet(String key) {
    }

    private void setWordIterOptions(String wordBreaks) {
        int wordIterOptions = 0;
        if (wordBreaks != null) {
            LpexStringTokenizer st = new LpexStringTokenizer(wordBreaks);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("caseChange".equals(token)) {
                    wordIterOptions |= 0x10;
                    continue;
                }
                if ("defineChars".equals(token)) {
                    wordIterOptions |= 1;
                    continue;
                }
                if ("fieldStart".equals(token)) {
                    wordIterOptions |= 4;
                    continue;
                }
                if ("nonWordChars".equals(token)) {
                    wordIterOptions |= 0x20;
                    continue;
                }
                if (!"styleChange".equals(token)) continue;
                wordIterOptions |= 8;
            }
        }
        this._view.setWordIterOptions(wordIterOptions);
    }

    protected String getPopupItems(int popupLocation) {
        return null;
    }

    protected void initParser() {
    }

    protected void terminateParser() {
    }

    public boolean isPrimaryParser() {
        View v = this._view.document()._firstView;
        while (v != null) {
            if (v == this._view) {
                return true;
            }
            if (v.parsePendingList().lpexParser() != null) {
                return false;
            }
            v = v._next;
        }
        return false;
    }

    private void proto() {
        int s;
        int e;
        Object key;
        if (this._view.readonly()) {
            return;
        }
        LpexDocumentLocation loc = this._lpexView.documentLocation();
        if (loc.element == 0 || this._lpexView.show(loc.element)) {
            return;
        }
        String text = this._lpexView.elementText(loc.element);
        if (this._lpexView.elements() == 1 && text.trim().length() == 0) {
            key = PROTOKEY_EMPTY;
            e = 0;
            s = 0;
        } else {
            if (text.length() == 0) {
                return;
            }
            s = loc.position - 1;
            if (s >= text.length()) {
                s = text.length() - 1;
            }
            e = s;
            if (s >= 0 && this.isTokenDelimiter(text.charAt(s))) {
                --s;
            }
            while (s >= 0 && (text.charAt(s) == ' ' || text.charAt(s) == '\t')) {
                --s;
            }
            if (s < 0) {
                s = e;
                while (s < text.length() && (text.charAt(s) == ' ' || text.charAt(s) == '\t')) {
                    ++s;
                }
                if (s >= text.length()) {
                    return;
                }
                e = s;
            } else {
                e = s + 1;
                while (s >= 0 && text.charAt(s) != ' ' && text.charAt(s) != '\t' && !this.isTokenDelimiter(text.charAt(s))) {
                    --s;
                }
                ++s;
            }
            while (e < text.length() && text.charAt(e) != ' ' && text.charAt(e) != '\t' && !this.isTokenDelimiter(text.charAt(e))) {
                ++e;
            }
            key = "proto." + text.substring(s, e);
        }
        String p = this.getProperty((String)key);
        if (p == null || p.length() == 0) {
            p = Profile.getString((String)key);
        }
        if (p == null || p.length() == 0) {
            return;
        }
        this.expandProtoKeyword(s, e, p);
    }

    protected void expandProtoKeyword(int s, int e, String p) {
        LpexDocumentLocation loc = this._lpexView.documentLocation();
        loc.position = ++s;
        String text = this._lpexView.elementText(loc.element);
        boolean origLine = true;
        int j = -1;
        this._view.commandHandler().doCommand("undo check");
        if (e + 1 > s) {
            this._lpexView.doDefaultCommand(loc, "deleteText " + text.length());
        }
        int s1 = this._lpexView.queryInt("displayPosition", loc);
        int i = p.indexOf(10);
        while (true) {
            Object pp = p.substring(0, i == -1 ? p.length() : i);
            int n = loc.position = origLine ? s : s1;
            if (j == -1 && (j = ((String)pp).indexOf(63)) != -1) {
                pp = ((String)pp).substring(0, j) + (this._view.insertMode() ? "" : " ") + ((String)pp).substring(j + 1);
                this._lpexView.doDefaultCommand(loc, "insertText " + (String)pp);
                this._lpexView.jump(loc.element, j + (origLine ? s : s1));
            } else {
                this._lpexView.doDefaultCommand(loc, "insertText " + (String)pp);
            }
            if (i == -1) break;
            this._lpexView.doDefaultCommand(loc, "insert");
            p = p.substring(i + 1);
            origLine = false;
            i = p.indexOf(10);
        }
        if (e < text.length()) {
            this._lpexView.doDefaultCommand(loc, "insertText " + text.substring(e));
        }
    }

    public String getToken(LpexDocumentLocation loc) {
        LpexDocumentLocation s;
        if (loc == null) {
            return null;
        }
        Block block = this._view.block();
        View docView = block.view();
        if (docView != null && docView.lpexView() == this._lpexView) {
            int topElement = docView.document().elementList().ordinalOf(block.topElement());
            int bottomElement = docView.document().elementList().ordinalOf(block.bottomElement());
            if (loc.element == topElement && loc.position == block.topPosition() || loc.element == bottomElement && loc.position == block.bottomPosition()) {
                return block.selectedText();
            }
        }
        if ((s = this.tokenBegin(loc)) == null) {
            return null;
        }
        LpexDocumentLocation e = this.tokenEnd(loc);
        return this._lpexView.elementText(loc.element).substring(s.position - 1, e.position);
    }

    public LpexDocumentLocation getTokenLocation(LpexDocumentLocation loc) {
        LpexDocumentLocation s;
        if (loc == null) {
            return null;
        }
        Block block = this._view.block();
        View docView = block.view();
        if (docView != null && docView.lpexView() == this._lpexView) {
            int topElement = docView.document().elementList().ordinalOf(block.topElement());
            int bottomElement = docView.document().elementList().ordinalOf(block.bottomElement());
            int topPosition = block.topPosition();
            if (loc.element == topElement && loc.position == topPosition || loc.element == bottomElement && loc.position == block.bottomPosition()) {
                return new LpexDocumentLocation(topElement, topPosition);
            }
        }
        return (s = this.tokenBegin(loc)) != null ? s : new LpexDocumentLocation(loc);
    }

    public String getLshToken() {
        return this.getToken(this._lpexView.documentLocation());
    }

    protected void blockMarkWord() {
        this._view.block().clear();
        LpexDocumentLocation loc = this._lpexView.documentLocation();
        LpexDocumentLocation s = this.tokenBegin(loc);
        if (s == null) {
            return;
        }
        LpexDocumentLocation e = this.tokenEnd(loc);
        String type = this._lpexView.query("current.block.defaultType");
        if ("element".equals(type)) {
            type = "stream";
        }
        if ("stream".equals(type)) {
            ++e.position;
        }
        this._lpexView.jump(e);
        this._lpexView.doDefaultCommand(s, "block set " + type);
        this._lpexView.doDefaultCommand("block set");
    }

    private void findMatch() {
        this._view.ensureIsParsed();
        LpexDocumentLocation loc = this._view.documentPosition().documentLocation();
        LpexDocumentLocation match = this.matchToken(loc);
        if (match != null && (match.element != loc.element || match.position != loc.position)) {
            LpexDocumentLocation jumpTo = this.tokenBegin(match);
            this._view.documentPosition().jump(jumpTo != null ? jumpTo : match);
        } else {
            ActionUtilities.doDefaultAction(this._view, 111);
        }
    }

    protected LpexDocumentLocation tokenBegin(LpexDocumentLocation loc) {
        if (loc == null) {
            return null;
        }
        String text = this._lpexView.elementText(loc.element);
        if (text == null) {
            return null;
        }
        int s = loc.position - 1;
        if (s >= text.length() || text.charAt(s) == ' ' || text.charAt(s) == '\t') {
            return null;
        }
        if (this.isTokenDelimiter(text.charAt(s))) {
            return new LpexDocumentLocation(loc);
        }
        String style = this._lpexView.elementStyle(loc.element);
        int tokenStyle = style.length() > s ? (int)style.charAt(s) : 33;
        while (--s >= 0) {
            char ch = text.charAt(s);
            if (ch == ' ' || ch == '\t' || this.isTokenDelimiter(ch) || tokenStyle != (style.length() > s ? (int)style.charAt(s) : 33)) break;
        }
        return new LpexDocumentLocation(loc.element, s + 2);
    }

    protected LpexDocumentLocation tokenEnd(LpexDocumentLocation loc) {
        if (loc == null) {
            return null;
        }
        String text = this._lpexView.elementText(loc.element);
        if (text == null) {
            return null;
        }
        int s = loc.position - 1;
        if (s >= text.length() || text.charAt(s) == ' ' || text.charAt(s) == '\t') {
            return null;
        }
        if (this.isTokenDelimiter(text.charAt(s))) {
            return new LpexDocumentLocation(loc);
        }
        String style = this._lpexView.elementStyle(loc.element);
        int tokenStyle = style.length() > s ? (int)style.charAt(s) : 33;
        int e = s + 1;
        while (e < text.length()) {
            char ch = text.charAt(e);
            if (ch == ' ' || ch == '\t' || this.isTokenDelimiter(ch) || tokenStyle != (style.length() > e ? (int)style.charAt(e) : 33)) break;
            ++e;
        }
        return new LpexDocumentLocation(loc.element, e);
    }

    protected LpexDocumentLocation matchToken(LpexDocumentLocation loc) {
        return null;
    }

    public boolean isDebuggable(int line) {
        return true;
    }

    public boolean isTokenDelimiter(char c) {
        return false;
    }

    public boolean isWordCharacter(int element, int position) {
        String t;
        Element e;
        if (position > 0 && (e = this._view.document().elementList().elementAt(element)) != null && position <= (t = e.text()).length()) {
            return Character.isLetterOrDigit(t.codePointAt(position - 1));
        }
        return false;
    }

    public int cursorIndent(int element) {
        if (!this._autoIndent) {
            return 1;
        }
        String p = this._lpexView.elementText(element);
        if (p == null) {
            return 1;
        }
        if (p.trim().length() == 0) {
            do {
                if (--element >= 1) continue;
                return 1;
            } while (this._lpexView.show(element) || (p = this._lpexView.elementText(element)).trim().length() <= 0);
        }
        int i = 0;
        while (p.charAt(i) == ' ' || p.charAt(i) == '\t') {
            ++i;
        }
        return this._lpexView.queryInt("displayPosition", new LpexDocumentLocation(element, i + 1));
    }

    public String getTextIndent(int element) {
        String p;
        while (true) {
            if (--element < 1) {
                return "";
            }
            if (this._lpexView.show(element)) continue;
            p = this._lpexView.elementText(element);
            if (p == null) {
                return "";
            }
            if (p.trim().length() > 0) break;
        }
        int i = 0;
        while (p.charAt(i) == ' ' || p.charAt(i) == '\t') {
            ++i;
        }
        return p.substring(0, i);
    }

    protected void newLine() {
        int ep0 = this._lpexView.currentElement();
        ActionUtilities.doDefaultAction(this._view, 143);
        int ep = this._lpexView.currentElement();
        if (ep != ep0) {
            this._lpexView.doDefaultCommand("set displayPosition " + this.cursorIndent(ep));
        }
    }

    protected void openLine() {
        ActionUtilities.doDefaultAction(this._view, 148);
        int ep = this._lpexView.currentElement();
        this._lpexView.jump(ep, this.indentText(ep));
    }

    protected void splitLine() {
        Element element0 = this._view.documentPosition().element();
        int ep0 = this._view.document().elementList().ordinalOf(element0);
        ActionUtilities.doDefaultAction(this._view, 194);
        int ep = this._lpexView.currentElement();
        if (this._lpexView.lineOfElement(ep) == this._lpexView.lineOfElement(ep0) + 1) {
            this._lpexView.jump(ep, this.indentText(ep));
        } else {
            Element element = element0.nextNonShow();
            if (element != null && element.text().trim().length() != 0) {
                int indent = this.indentText(this._view.document().elementList().ordinalOf(element));
                this._view.ensureIsParsed();
                if (element.visible(this._view)) {
                    this._view.documentPosition().jump(element, indent);
                }
            }
        }
    }

    public int indentText(int element) {
        return this.indentText(element, this._autoIndent ? this.getTextIndent(element) : "");
    }

    public int indentText(int element, int desiredIndent) {
        String blanks;
        if (--desiredIndent <= 0) {
            return this.indentText(element, "");
        }
        if (desiredIndent == 1) {
            blanks = " ";
        } else if (desiredIndent == 2) {
            blanks = "  ";
        } else if (desiredIndent == 3) {
            blanks = "   ";
        } else if (desiredIndent == 4) {
            blanks = "    ";
        } else {
            StringBuilder sb = new StringBuilder(desiredIndent);
            while (desiredIndent > 0) {
                sb.append(' ');
                --desiredIndent;
            }
            blanks = sb.toString();
        }
        return this.indentText(element, blanks);
    }

    public int indentText(int element, String desiredIndent) {
        String p = this._lpexView.elementText(element);
        if (p == null) {
            return 1;
        }
        if (desiredIndent == null) {
            desiredIndent = "";
        }
        int i = 0;
        while (i < p.length() && (p.charAt(i) == ' ' || p.charAt(i) == '\t')) {
            ++i;
        }
        String indent = p.substring(0, i);
        if (!indent.equals(desiredIndent)) {
            Element e = this._view.document().elementList().elementAt(element);
            if (i > 0) {
                this._view.deleteText(e, 1, i);
            }
            this._view.insertText(e, 1, desiredIndent);
        }
        return desiredIndent.length() + 1;
    }

    public String getCommentStyleCharacters() {
        return null;
    }

    public final void setStyle(String styles, String installAttributes) {
        if (styles != null) {
            StyleAttributes noAttributes = null;
            if (!this._tokenHighlight) {
                String attributes = LpexPaletteAttributes.convert(this.ATTRIBUTES_DEFAULT, BACKGROUND_COLOR, LpexPaletteAttributes.background(this._lpexView));
                noAttributes = StyleAttributes.getStyleAttributes(attributes);
            }
            StyleAttributes installStyleAttributes = StyleAttributes.getStyleAttributes(installAttributes);
            int i = 0;
            while (i < styles.length()) {
                char styleCharacter = styles.charAt(i++);
                this.recordStyle(styleCharacter, installAttributes);
                StyleAttributes styleAttributes = this._tokenHighlight ? this.getStyleAttributes(styleCharacter) : noAttributes;
                this._view.styleAttributesList().set(styleCharacter, styleAttributes == null ? installStyleAttributes : styleAttributes);
            }
        }
    }

    public final void setStyle(char[] styles, String installAttributes) {
        if (styles != null) {
            StyleAttributes noAttributes = null;
            if (!this._tokenHighlight) {
                String attributes = LpexPaletteAttributes.convert(this.ATTRIBUTES_DEFAULT, BACKGROUND_COLOR, LpexPaletteAttributes.background(this._lpexView));
                noAttributes = StyleAttributes.getStyleAttributes(attributes);
            }
            StyleAttributes installStyleAttributes = StyleAttributes.getStyleAttributes(installAttributes);
            int i = 0;
            while (i < styles.length) {
                char styleCharacter = styles[i++];
                this.recordStyle(styleCharacter, installAttributes);
                StyleAttributes styleAttributes = this._tokenHighlight ? this.getStyleAttributes(styleCharacter) : noAttributes;
                this._view.styleAttributesList().set(styleCharacter, styleAttributes == null ? installStyleAttributes : styleAttributes);
            }
        }
    }

    public final void setStyle(char styleCharacter, String installAttributes) {
        StyleAttributes noAttributes = null;
        if (!this._tokenHighlight) {
            String attributes = LpexPaletteAttributes.convert(this.ATTRIBUTES_DEFAULT, BACKGROUND_COLOR, LpexPaletteAttributes.background(this._lpexView));
            noAttributes = StyleAttributes.getStyleAttributes(attributes);
        }
        StyleAttributes installStyleAttributes = StyleAttributes.getStyleAttributes(installAttributes);
        this.recordStyle(styleCharacter, installAttributes);
        StyleAttributes styleAttributes = this._tokenHighlight ? this.getStyleAttributes(styleCharacter) : noAttributes;
        this._view.styleAttributesList().set(styleCharacter, styleAttributes == null ? installStyleAttributes : styleAttributes);
    }

    private void recordStyle(char styleCharacter, String installAttributes) {
        if (this._styles == null) {
            this._styles = new StringBuilder(32);
        }
        int i = 0;
        while (i < this._styles.length()) {
            if (this._styles.charAt(i) == styleCharacter) {
                return;
            }
            ++i;
        }
        if (this._installStyleAttributes == null) {
            this._installStyleAttributes = new ArrayList(32);
        }
        this._styles.append(styleCharacter);
        this._installStyleAttributes.add(installAttributes);
    }

    private StyleAttributes getStyleAttributes(char styleCharacter) {
        String attributes = this.getProperty("style." + styleCharacter);
        if (attributes != null) {
            String background = this.getProperty("styles.backgroundColor");
            attributes = LpexPaletteAttributes.convert(attributes, background != null ? background : BACKGROUND_COLOR, LpexPaletteAttributes.background(this._lpexView));
            return StyleAttributes.getStyleAttributes(attributes);
        }
        return null;
    }

    public String getStyles() {
        return this._styles != null ? this._styles.toString() : null;
    }

    public ArrayList<String> getInstallStyleAttributes() {
        return this._installStyleAttributes;
    }

    public String getStyleName(char styleCharacter) {
        String styleName = this.internalGetProperty(STYLE_NAME + styleCharacter);
        return styleName != null ? styleName : LpexResources.message(this.getLanguage() + ".styleName." + styleCharacter);
    }

    public String styleString(char style, int len) {
        if (len <= 0) {
            return "";
        }
        if (len == 1) {
            return String.valueOf(style);
        }
        StringBuilder sb = new StringBuilder(len);
        while (len > 0) {
            sb.append(style);
            --len;
        }
        return sb.toString();
    }

    public void lineComment(String text, boolean comment) {
        Element lastElement;
        Element firstElement;
        if (text == null || text.length() == 0) {
            return;
        }
        if (this._view == this._view.block().view()) {
            firstElement = this._view.block().topElement();
            lastElement = this._view.block().bottomElement();
        } else {
            lastElement = firstElement = this._view.documentPosition().element();
        }
        if (firstElement == null) {
            return;
        }
        if (lastElement != null) {
            lastElement = lastElement.nextVisible(this._view);
        }
        String text1 = null;
        int index = text.indexOf(0);
        if (index >= 0) {
            text1 = text.substring(index + 1);
            if (text1.length() == 0) {
                text1 = null;
            }
            text = text.substring(0, index);
        }
        this._view.commandHandler().doCommand("undo check");
        LpexDocumentLocation loc = new LpexDocumentLocation(1, 1);
        Element element = firstElement;
        while (element != null && element != lastElement) {
            if (!element.show()) {
                loc.element = this._view.document().elementList().ordinalOf(element);
                if (comment) {
                    loc.position = 1;
                    this._lpexView.doCommand(loc, "insertText " + text);
                } else {
                    loc.position = this.trimLeadingPosition(element.text());
                    if (element.text().indexOf(text) == loc.position - 1) {
                        this._lpexView.doCommand(loc, "deleteText " + text.length());
                    } else if (text1 != null && element.text().indexOf(text1) == loc.position - 1) {
                        this._lpexView.doCommand(loc, "deleteText " + text1.length());
                    }
                }
            }
            element = element.nextVisible(this._view);
        }
        this._view.commandHandler().doCommand("undo check");
    }

    private int trimLeadingPosition(String s) {
        int i = 0;
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return i + 1;
    }

    protected final boolean defineFilterAction(String actionName, String includedClasses) {
        return this.defineFilterAction(actionName, includedClasses, null);
    }

    protected final boolean defineFilterAction(String actionName, String includedClasses, String excludedClasses) {
        final long includedClassesMask = this._view.classes().mask(includedClasses);
        final long excludedClassesMask = this._view.classes().mask(excludedClasses);
        if (excludedClassesMask == includedClassesMask) {
            return false;
        }
        this._view.actionHandler().defineAction(actionName, new LpexBaseAction(){

            @Override
            public void doAction(LpexView lpexView) {
                lpexView._view.setIncludedClasses(includedClassesMask == 0L ? -1L : includedClassesMask);
                lpexView._view.setExcludedClasses(excludedClassesMask);
                lpexView._view.screen().show();
            }

            @Override
            public boolean checkable() {
                return true;
            }

            @Override
            public boolean checked(LpexView lpexView) {
                return lpexView._view.queryIncludedClasses() == includedClassesMask && lpexView._view.queryExcludedClasses() == excludedClassesMask;
            }
        });
        return true;
    }

    protected final void addMessage(int element, String text) {
        this.addMessage(element, text, this._classMessage, 'M');
    }

    protected final void addMessage(int element, String text, long messageClass) {
        this.addMessage(element, text, messageClass, 'M');
    }

    protected final void addMessage(int element, String text, long messageClass, char messageStyle) {
        if (this._errorMessages && text != null && element >= 0) {
            new ParserMessage(element, text, messageClass, messageStyle);
        }
    }

    protected final void addDocumentMessage(int element, String text, String messageClass, char messageStyle) {
        if (text != null && element >= 0) {
            new ParserMessage(element, text, this._view.classes().mask(messageClass), messageStyle);
            new DocMessage(element, text, messageClass, messageStyle);
        }
    }

    public static boolean copyDocumentMessages(LpexView targetView, int sourceViewId, String messageClass) {
        if (targetView == null || targetView._view == null) {
            return false;
        }
        View target = targetView._view;
        View source = target.document()._firstView;
        while (source != null && source.id() != sourceViewId) {
            source = source._next;
        }
        if (source == null || source == target) {
            return false;
        }
        long srcMessageClasses = source.classes().mask(messageClass);
        DocumentPosition.Preserve preserve = target.documentPosition().preserve();
        boolean forceAllVisible = target.setForceAllVisible(true);
        Element e = target.document().elementList().last();
        while (e != null) {
            long srcMsgClass;
            ElementView srcElementView;
            Element prev = e.prev();
            if (e.show() && (srcElementView = e.elementView(source)).show() && (srcMsgClass = srcElementView.classes() & srcMessageClasses) != 0L) {
                Element msgElement = new Element(target);
                msgElement.setText(target, e.text());
                target.insertShowElement(e, msgElement);
                ElementView msgElementView = msgElement.elementView(target);
                String style = srcElementView.style();
                if (style.length() > 0) {
                    LpexCommonParser.ensureStyleDefined(style.charAt(0), source, target);
                    msgElementView.setStyle(style);
                }
                msgElementView.setClasses(target.classes().register(source.classes().name(srcMsgClass)));
            }
            e = prev;
        }
        target.setForceAllVisible(forceAllVisible);
        preserve.restore();
        target.documentPosition().disposePreserve(preserve);
        return true;
    }

    protected final void removeMessages(int fromElement, int toElement) {
        this.removeMessages(fromElement, toElement, this._classMessage);
    }

    protected final void removeMessages(int fromElement, int toElement, long messageClass) {
        if (fromElement < 0) {
            fromElement = 0;
        }
        long mask = 1L;
        int i = 0;
        while (i < 64) {
            if ((messageClass & mask) != 0L) {
                ParserRange dr = this._parserRanges;
                while (dr != null && dr._messageClass != messageClass) {
                    dr = (ParserRange)dr._next;
                }
                if (dr == null) {
                    dr = new ParserRange(messageClass);
                }
                dr.extend(fromElement, toElement);
            }
            mask <<= 1;
            ++i;
        }
    }

    protected final void removeDocumentMessages(int fromElement, int toElement, String messageClass) {
        if (fromElement < 0) {
            fromElement = 0;
        }
        this.removeMessages(fromElement, toElement, this._view.classes().mask(messageClass));
        String[] msgClasses = LpexStringTokenizer.split(messageClass);
        int i = 0;
        while (i < msgClasses.length) {
            DocRange dr = this._docRanges;
            while (dr != null && !dr._messageClass.equals(msgClasses[i])) {
                dr = (DocRange)dr._next;
            }
            if (dr == null) {
                dr = new DocRange(msgClasses[i]);
            }
            dr.extend(this._view.document().elementList().lineOfElement(fromElement), this._view.document().elementList().lineOfElement(toElement));
            ++i;
        }
    }

    private void displayEmbeddedMessages() {
        this.displayMessages(this._view);
        View v = this._view.document()._firstView;
        while (v != null) {
            if (v != this._view) {
                this.displayMessages(v);
            }
            v = v._next;
        }
        this.clearEmbeddedMessages();
    }

    private void clearEmbeddedMessages() {
        this._lastMessage = null;
        this._messages = null;
        this._parserRanges = null;
        this._lastDocMessage = null;
        this._docMessages = null;
        this._docRanges = null;
    }

    private void displayMessages(View currentView) {
        Message m;
        Range ranges;
        Message lastMessage;
        Message messages;
        boolean docMessages;
        boolean bl = docMessages = currentView != this._view;
        if (docMessages) {
            messages = this._docMessages;
            lastMessage = this._lastDocMessage;
            ranges = this._docRanges;
        } else {
            messages = this._messages;
            lastMessage = this._lastMessage;
            ranges = this._parserRanges;
        }
        int from = -1;
        int to = 0;
        if (messages != null) {
            from = lastMessage.element();
            to = messages.element();
        }
        ElementList elementList = currentView.document().elementList();
        int elements = elementList.count();
        Range dr = ranges;
        while (dr != null) {
            if (from == -1 || dr.fromElement() < from) {
                from = dr.fromElement();
            }
            int toElement = dr.toElement();
            while (toElement < elements && currentView.lpexView().show(toElement + 1)) {
                ++toElement;
            }
            if (toElement > to) {
                to = toElement;
            }
            dr = dr._next;
        }
        if (from == -1) {
            return;
        }
        if (to > elements) {
            to = elements;
        }
        int lm = (m = messages) != null ? m.element() : -1;
        DocumentPosition.Preserve preserve = currentView.documentPosition().preserve();
        boolean forceAllVisible = currentView.setForceAllVisible(true);
        int i = to;
        while (i >= from) {
            Element e = elementList.elementAt(i);
            if (e == null) {
                while (lm == 0 && m != null) {
                    currentView.documentPosition().jump(elementList.nonShowElementAt(1), 1, false);
                    Element msgElement = new Element(currentView);
                    msgElement.setText(currentView, m._text);
                    currentView.insertElementBefore(msgElement);
                    msgElementView = msgElement.elementView(currentView);
                    msgClass = docMessages ? this.ensureMessageDefined(currentView, m) : ((ParserMessage)m)._messageClass;
                    msgElementView.setStyle(this.styleString(m._messageStyle, m._text.length()));
                    msgElementView.setClasses(msgClass);
                    m = m._next;
                    int n = lm = m != null ? m.element() : -1;
                }
            } else if (!e.show()) {
                while (i == lm && m != null) {
                    Element msgElement = new Element(currentView);
                    msgElement.setText(currentView, m._text);
                    currentView.insertShowElement(e, msgElement);
                    msgElementView = msgElement.elementView(currentView);
                    msgClass = docMessages ? this.ensureMessageDefined(currentView, m) : ((ParserMessage)m)._messageClass;
                    msgElementView.setStyle(this.styleString(m._messageStyle, m._text.length()));
                    msgElementView.setClasses(msgClass);
                    m = m._next;
                    int n = lm = m != null ? m.element() : -1;
                }
            } else {
                boolean deletable;
                boolean bl2 = deletable = docMessages ? this.deletableDocMessage(currentView, e) : this.deletableMessage(e);
                if (deletable) {
                    currentView.deleteElement(e);
                }
            }
            --i;
        }
        currentView.setForceAllVisible(forceAllVisible);
        preserve.restore();
        currentView.documentPosition().disposePreserve(preserve);
    }

    private long ensureMessageDefined(View targetView, Message docMessage) {
        LpexCommonParser.ensureStyleDefined(docMessage._messageStyle, this._view, targetView);
        return targetView.classes().register(((DocMessage)docMessage)._messageClass);
    }

    private static void ensureStyleDefined(char styleChar, View sourceView, View targetView) {
        String style;
        StyleAttributesParameter parm = StyleAttributesParameter.getParameter();
        if (parm.query(targetView, style = String.valueOf(styleChar)) == null) {
            parm.set(targetView, style, LpexPaletteAttributes.convert(parm.query(sourceView, style), sourceView, targetView));
        }
    }

    private boolean deletableMessage(Element e) {
        ElementView elementView = e.elementView(this._view);
        if (elementView.show()) {
            ParserRange dr = this._parserRanges;
            while (dr != null) {
                if (e._ordinal >= dr.fromElement() && (dr._messageClass & elementView.classes()) != 0L) {
                    int textElementOfEOrdinal;
                    if (e._ordinal <= dr.toElement()) {
                        return true;
                    }
                    Element textElementOfE = e.prevNonShow();
                    int n = textElementOfEOrdinal = textElementOfE == null ? 0 : textElementOfE._ordinal;
                    if (textElementOfEOrdinal <= dr.toElement()) {
                        return true;
                    }
                }
                dr = (ParserRange)dr._next;
            }
        }
        return false;
    }

    private boolean deletableDocMessage(View v, Element e) {
        ElementView elementView = e.elementView(v);
        if (elementView.show()) {
            int lineOrdinal = v.document().elementList().nonShowOrdinalOf(e);
            DocRange dr = this._docRanges;
            while (dr != null) {
                if (lineOrdinal >= dr.fromLine() && lineOrdinal <= dr.toLine() && (v.classes().mask(dr._messageClass) & elementView.classes()) != 0L) {
                    return true;
                }
                dr = (DocRange)dr._next;
            }
        }
        return false;
    }

    public String getBidiStyle(int element, String style) {
        return style;
    }

    protected void upperCaseElements(LpexView lpexView) {
        if (lpexView != null) {
            lpexView.doDefaultCommand(lpexView.documentLocation(), "parse");
            if (lpexView.queryOn("block.inView") && lpexView.queryOn("block.anythingSelected")) {
                int topElement = lpexView.queryInt("block.topElement");
                int bottomElement = lpexView.queryInt("block.bottomElement");
                int topPosition = lpexView.queryInt("block.topPosition");
                int bottomPosition = lpexView.queryInt("block.bottomPosition");
                if (topElement == 1 && topElement == lpexView.elements() && topPosition == 0 && bottomPosition == 0) {
                    this.upperCaseAllElements(lpexView);
                }
                this.upperCaseElement(lpexView, topElement, bottomElement, topPosition, bottomPosition);
            } else {
                this.upperCaseAllElements(lpexView);
            }
        }
    }

    protected void upperCaseAllElements(LpexView lpexView) {
        if (lpexView != null) {
            int currentElement = lpexView.currentElement();
            int endElement = lpexView.elements();
            boolean elementChanged = false;
            int element = 1;
            while (element <= endElement) {
                if (!lpexView.show(element)) {
                    char[] _elementStringArray = lpexView.elementText(element).toCharArray();
                    char[] _elementStyleArray = lpexView.elementStyle(element).toCharArray();
                    int arrayLength = Math.min(_elementStyleArray.length, _elementStringArray.length);
                    int elementArrayPosition = 0;
                    while (elementArrayPosition < arrayLength) {
                        elementChanged |= this.uppercaseCharacterInElement(lpexView, element, _elementStyleArray, _elementStringArray, elementArrayPosition);
                        ++elementArrayPosition;
                    }
                    if (elementChanged) {
                        String strElement = _elementStringArray.length > 0 && _elementStringArray[_elementStringArray.length - 1] == '\u0000' ? new String(_elementStringArray, 0, _elementStringArray.length - 1) : new String(_elementStringArray);
                        lpexView.setElementText(element, strElement);
                        if (currentElement == element) {
                            int caretPosition = Math.min(lpexView.currentPosition(), strElement.length() + 1);
                            lpexView.doDefaultCommand("set position " + caretPosition);
                        }
                        elementChanged = false;
                    }
                }
                ++element;
            }
        }
    }

    protected void upperCaseElement(LpexView lpexView, int startElement, int endElement, int topPosition, int bottomPosition) {
        if (lpexView != null) {
            int currentElement = lpexView.currentElement();
            boolean elementChanged = false;
            int element = startElement;
            while (element <= endElement) {
                if (!lpexView.show(element)) {
                    char[] _elementStringArray = lpexView.elementText(element).toCharArray();
                    char[] _elementStyleArray = lpexView.elementStyle(element).toCharArray();
                    int arrayLength = Math.min(_elementStyleArray.length, _elementStringArray.length);
                    boolean startBlockSelection = true;
                    int elementArrayPosition = 0;
                    while (elementArrayPosition < arrayLength) {
                        if (element == startElement && startBlockSelection && topPosition > 0) {
                            elementArrayPosition = topPosition - 1;
                            startBlockSelection = false;
                        }
                        if (element == endElement && bottomPosition > 0 && elementArrayPosition == bottomPosition - 1) break;
                        if (elementArrayPosition >= 0 && elementArrayPosition < arrayLength) {
                            elementChanged |= this.uppercaseCharacterInElement(_elementStyleArray, _elementStringArray, elementArrayPosition);
                        }
                        ++elementArrayPosition;
                    }
                    if (elementChanged) {
                        String strElement = _elementStringArray.length > 0 && _elementStringArray[_elementStringArray.length - 1] == '\u0000' ? new String(_elementStringArray, 0, _elementStringArray.length - 1) : new String(_elementStringArray);
                        lpexView.setElementText(element, strElement);
                        if (currentElement == element) {
                            int caretPosition = Math.min(this.view.currentPosition(), strElement.length() + 1);
                            lpexView.doDefaultCommand("set position " + caretPosition);
                        }
                        elementChanged = false;
                    }
                }
                ++element;
            }
        }
    }

    protected boolean uppercaseCharacterInElement(LpexView lpexView, int currentElement, char[] styleArray, char[] stringArray, int arrayPosition) {
        return this.uppercaseCharacterInElement(styleArray, stringArray, arrayPosition);
    }

    protected boolean uppercaseCharacterInElement(char[] styleArray, char[] stringArray, int arrayPosition) {
        return this.baseUppercaseCharacterInElement(styleArray, stringArray, arrayPosition);
    }

    protected boolean baseUppercaseCharacterInElement(char[] styleArray, char[] stringArray, int arrayPosition) {
        boolean changed;
        if (styleArray == null || stringArray == null || arrayPosition < 0 || arrayPosition >= styleArray.length || arrayPosition >= stringArray.length) {
            return false;
        }
        char charAtPosition = stringArray[arrayPosition];
        Object text = "" + charAtPosition;
        char charAfterUpperCase = ((String)(text = ((String)text).toUpperCase())).charAt(0);
        boolean bl = changed = charAtPosition != charAfterUpperCase;
        if (changed) {
            stringArray[arrayPosition] = charAfterUpperCase;
        }
        return changed;
    }

    public static void setDocumentElementText(LpexView view, int iElement, String pstrElement) {
        String strCurrent;
        String strElement = pstrElement;
        if (strElement.charAt(strElement.length() - 1) == '\u0000') {
            StringBuffer strb = new StringBuffer(strElement);
            strb.setLength(strElement.length() - 1);
            strElement = strb.toString();
        }
        if ((strCurrent = view.elementText(iElement)) != null && !strCurrent.equals(strElement)) {
            if (view.currentElement() == iElement) {
                int iCursorPosition = Math.min(view.currentPosition(), strElement.length() + 1);
                view.setElementText(iElement, strElement);
                view.doDefaultCommand("set position " + Integer.toString(iCursorPosition));
            } else {
                view.setElementText(iElement, strElement);
            }
        }
    }

    private final class DocMessage
    extends Message {
        String _messageClass;

        DocMessage(int element, String text, String messageClass, char messageStyle) {
            this._ordinal = LpexCommonParser.this.lpexView()._view.document().elementList().lineOfElement(element);
            this._text = text;
            this._messageClass = messageClass;
            this._messageStyle = messageStyle;
            DocMessage prev = null;
            Message m = LpexCommonParser.this._docMessages;
            while (m != null && this._ordinal < m._ordinal) {
                prev = m;
                m = m._next;
            }
            if (prev == null) {
                this._next = LpexCommonParser.this._docMessages;
                LpexCommonParser.this._docMessages = this;
            } else {
                this._next = prev._next;
                prev._next = this;
            }
            if (this._next == null) {
                LpexCommonParser.this._lastDocMessage = this;
            }
        }

        @Override
        int element() {
            return LpexCommonParser.this.lpexView()._view.document().elementList().elementOfLine(this._ordinal);
        }
    }

    private final class DocRange
    extends Range {
        String _messageClass;

        DocRange(String messageClass) {
            this._messageClass = messageClass;
            this._next = LpexCommonParser.this._docRanges;
            LpexCommonParser.this._docRanges = this;
        }

        int fromLine() {
            return this._from;
        }

        int toLine() {
            return this._to;
        }

        @Override
        int fromElement() {
            return LpexCommonParser.this.lpexView()._view.document().elementList().elementOfLine(this._from);
        }

        @Override
        int toElement() {
            return LpexCommonParser.this.lpexView()._view.document().elementList().elementOfLine(this._to);
        }
    }

    private abstract class Message {
        Message _next;
        protected int _ordinal;
        String _text;
        char _messageStyle;

        private Message() {
        }

        abstract int element();
    }

    private final class ParserMessage
    extends Message {
        long _messageClass;

        ParserMessage(int element, String text, long messageClass, char messageStyle) {
            this._ordinal = element;
            this._text = text;
            this._messageClass = messageClass;
            this._messageStyle = messageStyle;
            ParserMessage prev = null;
            Message m = LpexCommonParser.this._messages;
            while (m != null && this._ordinal < m._ordinal) {
                prev = m;
                m = m._next;
            }
            if (prev == null) {
                this._next = LpexCommonParser.this._messages;
                LpexCommonParser.this._messages = this;
            } else {
                this._next = prev._next;
                prev._next = this;
            }
            if (this._next == null) {
                LpexCommonParser.this._lastMessage = this;
            }
        }

        @Override
        int element() {
            return this._ordinal;
        }
    }

    private final class ParserRange
    extends Range {
        long _messageClass;

        ParserRange(long messageClass) {
            this._messageClass = messageClass;
            this._next = LpexCommonParser.this._parserRanges;
            LpexCommonParser.this._parserRanges = this;
        }

        @Override
        int fromElement() {
            return this._from;
        }

        @Override
        int toElement() {
            return this._to;
        }
    }

    private abstract class Range {
        Range _next;
        protected int _from = -1;
        protected int _to;

        private Range() {
        }

        void extend(int from, int to) {
            if (this._from == -1 || from < this._from) {
                this._from = from;
            }
            if (to > this._to) {
                this._to = to;
            }
        }

        abstract int fromElement();

        abstract int toElement();
    }
}

