/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.View;

final class LoadCommand {
    LoadCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        String fileEncoding = null;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("encoding") && !token.equalsIgnoreCase("enc")) {
                return CommandHandler.invalidParameter(view, token, "load");
            }
            if (!st.hasMoreTokens()) {
                return CommandHandler.incomplete(view, "load");
            }
            fileEncoding = st.nextToken();
            if ("\"\"".equalsIgnoreCase(fileEncoding)) {
                fileEncoding = "";
            } else if (!LpexNls.isValidEncoding(fileEncoding)) {
                return CommandHandler.invalidParameter(view, fileEncoding, "load");
            }
        }
        if (view != null) {
            view.document().load(view, fileEncoding);
        }
        return true;
    }
}

