/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

class List {
    private Node _first;
    private Node _last;
    private int _scanning;
    private boolean _removePending;

    List() {
    }

    final Node first() {
        return this._first;
    }

    final Node last() {
        return this._last;
    }

    final void prepend(Node node) {
        this.addAfter(null, node);
    }

    final void addAfter(Node prev, Node node) {
        if (node != null) {
            Node next;
            if (prev == null) {
                next = this._first;
                this._first = node;
            } else {
                next = prev.next();
                prev.setNext(node);
            }
            node.setPrev(prev);
            node.setNext(next);
            if (next != null) {
                next.setPrev(node);
            } else {
                this._last = node;
            }
        }
    }

    final void append(Node node) {
        this.addBefore(null, node);
    }

    final void addBefore(Node next, Node node) {
        if (node != null) {
            Node prev;
            if (next == null) {
                prev = this._last;
                this._last = node;
            } else {
                prev = next.prev();
                next.setPrev(node);
            }
            node.setNext(next);
            node.setPrev(prev);
            if (prev != null) {
                prev.setNext(node);
            } else {
                this._first = node;
            }
        }
    }

    Node remove(Node node) {
        if (this._scanning > 0) {
            node.setRemovePending();
            this._removePending = true;
            return null;
        }
        Node prev = node.prev();
        Node next = node.next();
        if (prev != null) {
            prev.setNext(next);
        } else {
            this._first = next;
        }
        if (next != null) {
            next.setPrev(prev);
        } else {
            this._last = prev;
        }
        node.setNext(null);
        node.setPrev(null);
        return node;
    }

    final void beginScanning() {
        ++this._scanning;
    }

    final void endScanning() {
        if (this._scanning > 0) {
            --this._scanning;
            if (this._scanning == 0 && this._removePending) {
                this._removePending = false;
                Node next = null;
                Node node = this.first();
                while (node != null) {
                    next = node.next();
                    if (node.removePending()) {
                        this.remove(node);
                    }
                    node = next;
                }
            }
        }
    }

    void clear() {
        while (this.first() != null) {
            this.remove(this.first());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Node next = null;
        Node node = this.first();
        while (node != null) {
            next = node.next();
            buf.append(node.toString());
            node = next;
        }
        return buf.toString();
    }

    static interface Node {
        public Node next();

        public void setNext(Node var1);

        public Node prev();

        public void setPrev(Node var1);

        public boolean removePending();

        public void setRemovePending();
    }
}

