/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterCharacterDefault;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;

final class LineNumbersParameters {
    private static final int LENGTH = 1;
    private static final int PAD = 2;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("length", 1), new TableNode("pad", 2)};

    static {
        TableNode.sort(_parameters);
    }

    LineNumbersParameters() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return LengthParameter.getParameter();
                }
                case 2: {
                    return PadParameter.getParameter();
                }
            }
        }
        return null;
    }

    static final class LengthParameter
    extends ParameterIntegerDefault {
        private static LengthParameter _parameter;

        static LengthParameter getParameter() {
            if (_parameter == null) {
                _parameter = new LengthParameter();
            }
            return _parameter;
        }

        private LengthParameter() {
            super("lineNumbers.length", 6);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean isAcceptableValue(int value) {
            return value > 0 && value <= 20;
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                boolean changed = view._lineNumbersLengthParm != value;
                view._lineNumbersLengthParm = value;
                view._useDefaultLineNumbersLength = useDefaultValue;
                if (changed) {
                    this.currentValueChanged(view);
                }
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            view.lineNumbersChanged();
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view._useDefaultLineNumbersLength : true;
        }

        @Override
        int value(View view) {
            return view != null ? view._lineNumbersLengthParm : 0;
        }
    }

    static final class PadParameter
    extends ParameterCharacterDefault {
        private static PadParameter _parameter;

        static PadParameter getParameter() {
            if (_parameter == null) {
                _parameter = new PadParameter();
            }
            return _parameter;
        }

        private PadParameter() {
            super("lineNumbers.pad", '0');
        }

        @Override
        boolean set(View view, String qualifier, String parameters) {
            if (parameters != null && parameters.length() == 1 && parameters.charAt(0) == ' ') {
                parameters = "0x20";
            }
            return super.set(view, qualifier, parameters);
        }

        @Override
        boolean setValue(View view, String qualifier, char value) {
            if (view != null) {
                if (value != '\u0000' && value < ' ') {
                    return CommandHandler.invalidParameter(view, String.valueOf(value), "set " + this.name());
                }
                char oldValue = this.currentValue(view);
                view._lineNumbersPadParm = value;
                if (oldValue != this.currentValue(view)) {
                    this.currentValueChanged(view);
                }
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            view.lineNumbersChanged();
        }

        @Override
        char value(View view) {
            return view != null ? view._lineNumbersPadParm : (char)'\u0000';
        }
    }
}

