/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;

final class KeyedList
extends List {
    KeyedList() {
    }

    private Object query(String key) {
        KeyedNode keyedNode;
        if (key != null && (keyedNode = this.find(key)) != null) {
            return keyedNode._value;
        }
        return null;
    }

    Object query(String key, boolean ignoreKeyCase) {
        KeyedNode keyedNode;
        if (!ignoreKeyCase) {
            return this.query(key);
        }
        if (key != null && (keyedNode = this.findIgnoreKeyCase(key)) != null) {
            return keyedNode._value;
        }
        return null;
    }

    void set(String key, Object value) {
        this.set(key, value, true);
    }

    void set(String key, Object value, boolean ignoreCase) {
        if (key != null) {
            KeyedNode keyedNode = null;
            KeyedNode keyedNode2 = keyedNode = ignoreCase ? this.findIgnoreKeyCase(key) : this.find(key);
            if (keyedNode != null) {
                if (value == null) {
                    this.remove(keyedNode);
                } else {
                    keyedNode._value = value;
                }
            } else if (value != null) {
                keyedNode = new KeyedNode(key, value);
                this.addAfter(null, keyedNode);
            }
        }
    }

    String keyList() {
        this.sort();
        StringBuilder keyList = null;
        KeyedNode keyedNode = (KeyedNode)this.first();
        while (keyedNode != null) {
            if (keyList == null) {
                keyList = new StringBuilder(512);
            }
            if (keyList.length() > 0) {
                keyList.append(' ');
            }
            keyList.append(keyedNode._key);
            keyedNode = (KeyedNode)keyedNode.next();
        }
        return keyList != null ? keyList.toString() : "";
    }

    private KeyedNode find(String key) {
        if (key != null) {
            KeyedNode keyedNode = (KeyedNode)this.first();
            while (keyedNode != null) {
                if (key.equals(keyedNode._key)) {
                    return keyedNode;
                }
                keyedNode = (KeyedNode)keyedNode.next();
            }
        }
        return null;
    }

    private KeyedNode findIgnoreKeyCase(String key) {
        if (key != null) {
            KeyedNode keyedNode = (KeyedNode)this.first();
            while (keyedNode != null) {
                if (key.equalsIgnoreCase(keyedNode._key)) {
                    return keyedNode;
                }
                keyedNode = (KeyedNode)keyedNode.next();
            }
        }
        return null;
    }

    private void sort() {
        boolean swap;
        do {
            swap = false;
            KeyedNode keyedNode = (KeyedNode)this.first();
            while (keyedNode != null) {
                KeyedNode next = (KeyedNode)keyedNode.next();
                if (next != null && keyedNode._key.compareTo(next._key) > 0) {
                    this.remove(keyedNode);
                    this.addAfter(next, keyedNode);
                    keyedNode = next;
                    swap = true;
                }
                keyedNode = (KeyedNode)keyedNode.next();
            }
        } while (swap);
    }

    private static final class KeyedNode
    extends ListNode {
        String _key;
        Object _value;

        KeyedNode(String key, Object value) {
            this._key = key;
            this._value = value;
        }
    }
}

