/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexKeyListener;
import org.eclipse.swt.widgets.Event;

final class KeyListenerList
extends List {
    KeyListenerList() {
    }

    void addListener(LpexKeyListener listener) {
        if (this.find(listener) == null) {
            this.addAfter(null, new ListenerNode(listener));
        }
    }

    boolean removeListener(LpexKeyListener listener) {
        ListenerNode node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
        return this.first() == null;
    }

    void keyPressed(Event event) {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            node.listener().keyPressed(event);
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    ListenerNode find(LpexKeyListener listener) {
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (node.listener() == listener && !node.removePending()) {
                return node;
            }
            node = (ListenerNode)node.next();
        }
        return null;
    }

    private static class ListenerNode
    extends ListNode {
        private LpexKeyListener _listener;

        ListenerNode(LpexKeyListener listener) {
            this._listener = listener;
        }

        LpexKeyListener listener() {
            return this._listener;
        }
    }
}

