/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexUtilities;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

final class Install {
    private static Properties _properties;
    private static String _name;
    private static boolean _loaded;
    private static List _listeners;

    static {
        _listeners = new List();
    }

    private Install() {
    }

    static String name() {
        if (_name != null) {
            return _name;
        }
        if (LpexUtilities.getPlatform() == 0) {
            return "com.ibm.lpex.core.Install";
        }
        return "Install";
    }

    static void setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        _name = name;
        _loaded = false;
        List.Node node = _listeners.first();
        while (node != null) {
            ((ListenerNode)node).listener().profileChanged();
            node = node.next();
        }
    }

    private static void load() {
        if (!_loaded) {
            Object var2_7;
            Throwable throwable;
            String fileName;
            _properties = new Properties();
            if (LpexUtilities.getPlatform() == 0) {
                fileName = Install.name().replace('.', '/') + ".properties";
                try {
                    _properties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName));
                    _loaded = true;
                }
                catch (Exception exception) {}
            } else {
                fileName = Install.name() + ".properties";
                try {
                    throwable = null;
                    var2_7 = null;
                    try (InputStream installStream = Install.class.getResourceAsStream(fileName);){
                        _properties.load(installStream);
                        _loaded = true;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!_loaded) {
                fileName = Install.name() + ".properties";
                try {
                    throwable = null;
                    var2_7 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(fileName);){
                        _properties.load(fileInputStream);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            _loaded = true;
        }
    }

    static void loadExtension(Properties extension) {
        if (extension != null) {
            Install.load();
            Enumeration<?> extensionKeys = extension.propertyNames();
            while (extensionKeys.hasMoreElements()) {
                String value;
                String key = (String)extensionKeys.nextElement();
                if (!key.startsWith("install.") || (value = extension.getProperty(key)) == null || value.length() <= 0) continue;
                _properties.setProperty(key, value);
            }
        }
    }

    static String getString(String key) {
        Install.load();
        return _properties.getProperty(key);
    }

    static int getInteger(String key, int defaultValue) {
        Install.load();
        String value = _properties.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static String getKeys() {
        Install.load();
        StringBuilder keys = new StringBuilder(6464);
        Enumeration<?> propertyNames = _properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            if (keys.length() != 0) {
                keys.append(' ');
            }
            keys.append(propertyNames.nextElement());
        }
        return keys.toString();
    }

    static void addProfileChangedListener(ProfileChangedListener listener) {
        _listeners.addAfter(null, new ListenerNode(listener));
    }

    private static class ListenerNode
    extends ListNode {
        private ProfileChangedListener _listener;

        ListenerNode(ProfileChangedListener listener) {
            this._listener = listener;
        }

        ProfileChangedListener listener() {
            return this._listener;
        }
    }

    static interface ProfileChangedListener {
        public void profileChanged();
    }
}

