/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.View;

final class InputCommand {
    InputCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.noParameters(view, "input");
        }
        String token = st.nextToken();
        if (LpexStringTokenizer.isInvalidQuotedString(token)) {
            return CommandHandler.invalidQuotedParameter(view, token, "input");
        }
        token = LpexStringTokenizer.removeQuotes(token);
        String labelText = "";
        String text = "";
        String command = null;
        if (!st.hasMoreTokens()) {
            command = token;
        } else {
            labelText = token;
            token = st.nextToken();
            if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                return CommandHandler.invalidQuotedParameter(view, token, "input");
            }
            token = LpexStringTokenizer.removeQuotes(token);
            if (!st.hasMoreTokens()) {
                command = token;
            } else {
                text = token;
                token = st.nextToken();
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "input");
                }
                command = LpexStringTokenizer.removeQuotes(token);
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "input");
                }
            }
        }
        if (view != null && view.window() != null) {
            CommandLine commandLine = (CommandLine)view.window().commandLine();
            commandLine.setForceVisible(true);
            commandLine.setInput(view, labelText, text, command);
            commandLine.setMode(4);
            view.window().commandLineRequestFocus();
        }
        return true;
    }
}

