/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Color;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.SaveCommand;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.View;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

final class HtmlWriter {
    View _view;
    String _eol;
    BufferedWriter _bufferedWriter;

    HtmlWriter(View view) {
        this._view = view;
    }

    boolean writeFile(String fileName, boolean visible, boolean block, boolean lineNumbers) {
        boolean anchors = true;
        this._eol = SaveCommand.LineSeparatorParameter.getParameter().currentEol(this._view);
        this._bufferedWriter = null;
        int lastLine = 0;
        try {
            try {
                Element stopElement;
                if (fileName == null || ((String)fileName).trim().length() == 0) {
                    fileName = this._view.document().name();
                    if (fileName == null) {
                        fileName = LpexResources.message("untitledDocument", this._view.document().id());
                    }
                    fileName = (String)fileName + ".html";
                }
                fileName = new File((String)fileName).getCanonicalPath();
                this._bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File((String)fileName)), "UTF8"));
                ElementList elementList = this._view.document().elementList();
                int startElement = 1;
                int endElement = elementList.count();
                if (block && this._view.block().view() == this._view) {
                    Element bottomElement;
                    Element topElement = this._view.block().topElement();
                    if (topElement != null) {
                        startElement = elementList.ordinalOf(topElement);
                    }
                    if ((bottomElement = this._view.block().bottomElement()) != null) {
                        endElement = elementList.ordinalOf(bottomElement);
                    }
                }
                if ((stopElement = elementList.elementAt(endElement)) != null) {
                    stopElement = stopElement.next();
                }
                this.writeHeader((String)fileName);
                StyleAttributes defaultStyle = this._view.screen().styleAttributes(4);
                StyleAttributes lineNumberStyle = this._view.screen().styleAttributes(12);
                int linesBeforeStart = this._view.document().linesBeforeStart();
                this._view.document().elementList().validateNonShowOrdinals();
                int lineNumberLength = lineNumbers ? Math.max(String.valueOf(endElement).length(), 2) : 0;
                String text = null;
                Element e = elementList.elementAt(startElement);
                while (e != stopElement) {
                    if (!visible && !e.show() || visible && e.visible(this._view)) {
                        int line;
                        if (anchors && (line = e.nonShowOrdinal() + linesBeforeStart) != lastLine) {
                            this._bufferedWriter.write("<a name=\"line" + line + "\"></a>");
                            lastLine = line;
                        }
                        if (lineNumbers) {
                            this.writeToken(this._view.lineNumbersText(e, lineNumberLength, false, ' '), lineNumberStyle);
                            this._bufferedWriter.write(32);
                        }
                        text = e.elementView(this._view).displayText();
                        int textLength = text.length();
                        String style = e.elementView(this._view).displayStyle().foreground();
                        int len = style.length() > textLength ? style.length() : textLength;
                        int i = 0;
                        while (i < len) {
                            String subText;
                            StyleAttributes styleAttributes = null;
                            if (style.length() > i) {
                                styleAttributes = this._view.styleAttributesList().find(style.charAt(i));
                            }
                            if (styleAttributes == null) {
                                styleAttributes = defaultStyle;
                            }
                            int subTextLength = 1;
                            while (i + subTextLength < len) {
                                StyleAttributes styleAttributesNext = null;
                                if (style.length() > i + subTextLength) {
                                    styleAttributesNext = this._view.styleAttributesList().find(style.charAt(i + subTextLength));
                                }
                                if (styleAttributesNext == null) {
                                    styleAttributesNext = defaultStyle;
                                }
                                if (!styleAttributes.equals(styleAttributesNext)) break;
                                ++subTextLength;
                            }
                            if (i + subTextLength <= textLength) {
                                subText = text.substring(i, i + subTextLength);
                            } else {
                                subText = i < textLength ? text.substring(i) : "";
                                StringBuilder buffer = new StringBuilder(subText);
                                int originalLength = buffer.length();
                                buffer.setLength(len);
                                int j = originalLength;
                                while (j < len) {
                                    buffer.setCharAt(j, ' ');
                                    ++j;
                                }
                                subText = buffer.toString();
                            }
                            if (styleAttributes.foregroundColor().equals(defaultStyle.backgroundColor())) {
                                styleAttributes = defaultStyle;
                            }
                            this.writeToken(subText, styleAttributes);
                            i += subTextLength;
                        }
                        this.newLine();
                    }
                    e = e.next();
                }
                this._bufferedWriter.write("</pre></body></html>");
            }
            catch (IOException e) {
                this._view.setLpexMessageText("file.errorWriting", (String)fileName);
                if (this._bufferedWriter != null) {
                    try {
                        this._bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (this._bufferedWriter != null) {
                try {
                    this._bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private void newLine() throws IOException {
        if (this._eol == null) {
            this._bufferedWriter.newLine();
        } else {
            this._bufferedWriter.write(this._eol, 0, this._eol.length());
        }
    }

    private void writeHeader(String fileName) throws IOException {
        String title = fileName;
        if (title.endsWith(".html")) {
            title = title.substring(0, title.length() - 5);
        } else if (title.endsWith(".htm")) {
            title = title.substring(0, title.length() - 4);
        }
        StyleAttributes defaultStyle = this._view.screen().styleAttributes(4);
        this._bufferedWriter.write("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
        this.newLine();
        this._bufferedWriter.write("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><title>");
        this._bufferedWriter.write(title);
        this._bufferedWriter.write("</title></head><body bgcolor=\"#");
        this._bufferedWriter.write(HtmlWriter.getRGBAsHtml(defaultStyle.backgroundColor()));
        this._bufferedWriter.write("\"><pre>");
        this.newLine();
    }

    private void writeToken(String text, StyleAttributes styleAttributes) throws IOException {
        boolean isAllSpaces = true;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) != ' ') {
                isAllSpaces = false;
                break;
            }
            ++i;
        }
        if (isAllSpaces) {
            i = 0;
            while (i < text.length()) {
                this._bufferedWriter.write(32);
                ++i;
            }
            return;
        }
        StringBuilder sb = new StringBuilder(text.length() + 48);
        sb.append("<font color=\"#");
        HtmlWriter.appendRGBAsHtml(sb, styleAttributes.foregroundColor());
        sb.append("\">");
        if (styleAttributes.underline()) {
            sb.append("<u>");
        }
        if (styleAttributes.strikeout()) {
            sb.append("<s>");
        }
        if (styleAttributes.bold()) {
            sb.append("<b>");
        }
        if (styleAttributes.italic()) {
            sb.append("<i>");
        }
        int i2 = 0;
        while (i2 < text.length()) {
            char c = text.charAt(i2);
            if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else {
                sb.append(c);
            }
            ++i2;
        }
        if (styleAttributes.italic()) {
            sb.append("</i>");
        }
        if (styleAttributes.bold()) {
            sb.append("</b>");
        }
        if (styleAttributes.strikeout()) {
            sb.append("</s>");
        }
        if (styleAttributes.underline()) {
            sb.append("</u>");
        }
        sb.append("</font>");
        this._bufferedWriter.write(sb.toString());
    }

    private static String getRGBAsHtml(Color c) {
        return HtmlWriter.appendRGBAsHtml(new StringBuilder(8), c).toString();
    }

    private static StringBuilder appendRGBAsHtml(StringBuilder sb, Color c) {
        int i = c.getRed();
        if (i < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(i));
        i = c.getGreen();
        if (i < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(i));
        i = c.getBlue();
        if (i < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(i));
        return sb;
    }
}

