/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.preferences.HostCharacterMapping;
import com.ibm.lpex.alef.preferences.HostCharacterUtil;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterWordsDefault;
import com.ibm.lpex.core.View;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class HostCharMappingParameter
extends ParameterWordsDefault {
    private static HostCharMappingParameter _parameter;

    static HostCharMappingParameter getParameter() {
        if (_parameter == null) {
            _parameter = new HostCharMappingParameter();
        }
        return _parameter;
    }

    private HostCharMappingParameter() {
        super("hostCharMapping", HostCharacterUtil.buildHostCharMappingListString(HostCharacterUtil.defaultMappingList, null));
    }

    @Override
    boolean setValue(View view, String value) {
        if (view == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            String codePointStr;
            String codePageStr;
            if (st.hasMoreTokens() && !HostCharacterUtil.isSupportedCodePageString(codePageStr = st.nextToken())) {
                CommandHandler.invalidParameter(view, codePageStr, "set " + this.name());
                return false;
            }
            if (st.hasMoreTokens() && !HostCharacterUtil.isSupportedCodePointString(codePointStr = st.nextToken())) {
                CommandHandler.invalidParameter(view, codePointStr, "set " + this.name());
                return false;
            }
            if (!st.hasMoreTokens()) continue;
            String substituteStr = st.nextToken();
            try {
                char c = HostCharacterUtil.getCharByHexString(substituteStr);
                HostCharacterUtil.isSupportedHostChar(c);
            }
            catch (Exception e) {
                CommandHandler.invalidParameter(view, substituteStr, "set " + this.name());
                return false;
            }
        }
        view.setHostCharMapping(HostCharacterUtil.getHostCharMappingList(value));
        return true;
    }

    String value(View view, String codePage) {
        if (view == null) {
            return null;
        }
        List<HostCharacterMapping> list = view.getHostCharMapping();
        if (list == null) {
            return null;
        }
        return HostCharacterUtil.buildHostCharMappingListString(list, codePage);
    }

    @Override
    void currentValueChanged(View view) {
        view.hostCharMappingChanged();
    }

    @Override
    String value(View view) {
        return null;
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return this.value(view, qualifier);
    }

    @Override
    String queryInstall(String qualifier) {
        return this.installValue(qualifier);
    }

    String installValue(String codePage) {
        return HostCharacterUtil.buildHostCharMappingListString(HostCharacterUtil.defaultMappingList, codePage);
    }

    @Override
    String queryDefault(String qualifier) {
        String value = this.defaultValue(qualifier);
        return value == null || value.equals("") ? "install" : value;
    }

    String defaultValue(String qualifier) {
        String value = this.defaultValue();
        List<HostCharacterMapping> list = HostCharacterUtil.parseHostCharMappingString(value);
        return HostCharacterUtil.buildHostCharMappingListString(list, qualifier);
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return this.setValue(view, "");
        }
        String token = st.nextToken();
        if (!st.hasMoreTokens() && token.equalsIgnoreCase("default")) {
            return this.setValue(view, "");
        }
        StringBuilder value = new StringBuilder(512);
        value.append(token);
        while (st.hasMoreTokens()) {
            value.append(' ').append(st.nextToken());
        }
        String mapString = this.value(view, null);
        LinkedList<HostCharacterMapping> list = new LinkedList();
        list = HostCharacterUtil.parseHostCharMappingString(mapString);
        Boolean result = true;
        result = HostCharacterUtil.updateMappingList(value, list);
        if (!result.booleanValue()) {
            CommandHandler.invalidParameter(view, parameters, "set " + this.name());
        } else {
            mapString = HostCharacterUtil.buildHostCharMappingListString(list, null);
        }
        return this.setValue(view, mapString);
    }

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return this.setDefaultValue("");
        }
        String token = st.nextToken();
        if (!st.hasMoreTokens() && token.equalsIgnoreCase("install")) {
            return this.setDefaultValue(null);
        }
        StringBuilder value = new StringBuilder(512);
        value.append(token);
        while (st.hasMoreTokens()) {
            value.append(' ').append(st.nextToken());
        }
        String mapString = this.defaultValue();
        List<HostCharacterMapping> list = HostCharacterUtil.parseHostCharMappingString(mapString);
        Boolean result = true;
        result = HostCharacterUtil.updateMappingList(value, list);
        if (!result.booleanValue()) {
            CommandHandler.invalidParameter(view, parameters, "set " + this.name());
        } else {
            mapString = HostCharacterUtil.buildHostCharMappingListString(list, null);
        }
        return this.setDefaultValue(mapString);
    }
}

