/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class HexParameter
extends Parameter {
    private static HexParameter _parameter;

    static HexParameter getParameter() {
        if (_parameter == null) {
            _parameter = new HexParameter();
        }
        return _parameter;
    }

    private HexParameter() {
        super("hex");
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        Element element;
        if (view != null && documentLocation != null && (element = view.document().elementList().elementAt(documentLocation.element)) != null) {
            char c = '\u0000';
            String text = element.text();
            if (text.length() > 0 && text.length() >= documentLocation.position) {
                c = text.charAt(documentLocation.position - 1);
                if (Character.isHighSurrogate(c)) {
                    if (text.length() == documentLocation.position || !Character.isLowSurrogate(text.charAt(documentLocation.position))) {
                        return Integer.toHexString(c) + " (??????)";
                    }
                    return Integer.toHexString(c) + " (" + Integer.toHexString(text.codePointAt(documentLocation.position - 1)) + ")";
                }
                if (Character.isLowSurrogate(c)) {
                    if (documentLocation.position == 1 || !Character.isHighSurrogate(text.charAt(documentLocation.position - 2))) {
                        return Integer.toHexString(c) + " (??????)";
                    }
                    return Integer.toHexString(c) + " (" + Integer.toHexString(text.codePointAt(documentLocation.position - 2)) + ")";
                }
            }
            return Integer.toHexString(c);
        }
        return null;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        Element element;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "set " + this.name());
        }
        StringBuilder newChars = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int newCharInt = Integer.parseInt(token, 16);
                newChars.appendCodePoint(newCharInt);
            }
            catch (Exception e) {
                return CommandHandler.invalidParameter(view, token, "set " + this.name());
            }
        }
        if (view != null && (element = view.documentPosition().element()) != null) {
            String text = element.text();
            int position = view.documentPosition().position();
            if (position <= text.length()) {
                view.deleteText(Character.charCount(text.codePointAt(position - 1)));
            }
            view.insertText(newChars.toString());
        }
        return true;
    }
}

