/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

final class HelpCommand {
    private static Properties _helpPages;

    HelpCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        if (view != null) {
            view.setLpexMessageText("command.notAvailable", "help");
        }
        return true;
    }

    static String getLpexHelpPage(String parameters) {
        HelpCommand.loadHelpCommandHelpMap();
        String helpPage = null;
        String commandString = parameters.trim().toLowerCase().replace(' ', '.');
        int index = -1;
        while (helpPage == null && commandString != null) {
            helpPage = _helpPages.getProperty(commandString);
            if (helpPage != null) continue;
            index = commandString.lastIndexOf(46);
            if (index >= 0) {
                helpPage = _helpPages.getProperty(commandString.substring(index + 1));
                commandString = commandString.substring(0, index);
                continue;
            }
            commandString = null;
        }
        return helpPage == null ? _helpPages.getProperty("default_help") : helpPage;
    }

    static String getLpexHelpTopic(String parameters) {
        HelpCommand.loadHelpCommandHelpMap();
        return _helpPages.getProperty(parameters.trim().toLowerCase());
    }

    private static void loadHelpCommandHelpMap() {
        if (_helpPages == null) {
            _helpPages = HelpCommand.loadHelpMap("HelpCommand.properties");
            LpexStringTokenizer st = new LpexStringTokenizer(Profile.getKeys());
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                if (!key.startsWith("helpTopic.")) continue;
                _helpPages.setProperty(key.substring("helpTopic.".length()), Profile.getString(key));
            }
        }
    }

    static void updateHelpCommandHelpTopic(String key, String value) {
        if (_helpPages != null && key != null) {
            if (value != null) {
                _helpPages.setProperty(key, value);
            } else {
                _helpPages.remove(key);
            }
        }
    }

    private static Properties loadHelpMap(String fileName) {
        Properties helpProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(fileName);){
                helpProperties.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            try {
                Throwable throwable = null;
                Object var4_11 = null;
                try (InputStream helpStream = HelpCommand.class.getResourceAsStream(fileName);){
                    helpProperties.load(helpStream);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return helpProperties;
    }
}

