/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.RealColumnNumbersParameter;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.View;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

final class FormatLine
extends Composite {
    private boolean _formatValid;
    private String _text;
    private String _displayText;
    private int _displayTextX;
    private int _firstCol;
    private int _boundsStartCol;
    private int _boundsEndCol;
    private int _column;
    private int _columnX;
    private int _columnWidth;
    private int _width;
    private Font _font;
    private Font _boldFont;
    private Font _italicFont;
    private Font _boldItalicFont;
    private int _textHeight;
    private int _spaceWidth = 1;
    private StyleAttributes _styleAttributes;
    private int _scroll;
    private int _margin;
    private int _horizontalTrim;
    private int _insertCursorWidth;

    FormatLine(LpexWindow lpexWindow) {
        super((Composite)lpexWindow, 786432);
        this._horizontalTrim = -lpexWindow.textWindow().computeTrim((int)0, (int)0, (int)0, (int)0).x;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FormatLine.this.paintComponent(e.gc);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                FormatLine.this.handleDispose();
            }
        });
        this.initAccessible();
    }

    void handleDispose() {
        this.disposeFonts();
    }

    private void disposeFonts() {
        if (this._boldFont != null) {
            this._boldFont.dispose();
        }
        if (this._italicFont != null) {
            this._italicFont.dispose();
        }
        if (this._boldItalicFont != null) {
            this._boldItalicFont.dispose();
        }
        this._boldItalicFont = null;
        this._italicFont = null;
        this._boldFont = null;
    }

    private Font currentFont() {
        if (this._styleAttributes != null) {
            if (this._styleAttributes.boldItalic()) {
                if (this._boldItalicFont == null) {
                    this._boldItalicFont = this.deriveFont(3);
                }
                return this._boldItalicFont;
            }
            if (this._styleAttributes.bold()) {
                if (this._boldFont == null) {
                    this._boldFont = this.deriveFont(1);
                }
                return this._boldFont;
            }
            if (this._styleAttributes.italic()) {
                if (this._italicFont == null) {
                    this._italicFont = this.deriveFont(2);
                }
                return this._italicFont;
            }
        }
        return this._font;
    }

    private Font deriveFont(int style) {
        FontData[] fontDatas = this._font.getFont().getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(style);
            ++i;
        }
        return new Font((Device)this.getDisplay(), fontDatas);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height = 0;
        int width = 0;
        if (this._font != null) {
            width = this._spaceWidth;
            height = this._textHeight + 1;
        }
        return new Point(width, height);
    }

    public void invalidateFormat() {
        this._formatValid = false;
    }

    private void paintComponent(GC g) {
        if (this._styleAttributes != null) {
            Point size = this.getSize();
            if (this._width != size.x) {
                this._width = size.x;
                this._formatValid = false;
            }
            this._firstCol = this._scroll / this._spaceWidth;
            if (this.getParent() instanceof LpexWindow) {
                LpexWindow window = (LpexWindow)this.getParent();
                int realCol = RealColumnNumbersParameter.getRealColumnNumber(window.getLpexView()._view, this._firstCol + 1) - 1;
                if (this._firstCol != realCol) {
                    this._firstCol = realCol;
                    this._formatValid = false;
                }
            }
            int x = this._margin + this._horizontalTrim - this._scroll % this._spaceWidth;
            if (!this._formatValid) {
                this._displayText = this._text == null || this._text.length() == 0 ? FormatLine.ruler(this._firstCol, this._firstCol + this._width / this._spaceWidth + 1) : (this._firstCol < this._text.length() ? this._text.substring(this._firstCol) : "");
                this._displayTextX = x;
            }
            boolean paintEmphasis = false;
            int startX = 0;
            int endX = 0;
            if (this._boundsStartCol > 0 && this._styleAttributes.effectsColor() != null) {
                int startCol = this._boundsStartCol - this._firstCol - 1;
                int endCol = this._boundsEndCol - this._firstCol;
                if (startCol >= 0) {
                    startX = startCol < this._displayText.length() ? x + g.stringExtent((String)this._displayText.substring((int)0, (int)startCol)).x : this._width;
                }
                if (startX < this._width) {
                    if (endCol >= 0) {
                        endX = endCol < this._displayText.length() ? x + g.stringExtent((String)this._displayText.substring((int)0, (int)endCol)).x : this._width;
                    }
                    paintEmphasis = endX > 0;
                }
            }
            g.setBackground(this._styleAttributes.backgroundColor().getColor());
            if (paintEmphasis) {
                if (startX < this._margin + this._horizontalTrim) {
                    startX = this._margin + this._horizontalTrim;
                }
                g.fillRectangle(0, 0, startX, size.y);
                g.fillRectangle(endX - startX + 1, 0, this._width - (endX - startX), size.y);
                g.setBackground(this._styleAttributes.effectsColor().getColor());
                g.fillRectangle(startX, 0, endX - startX, size.y);
            } else {
                g.fillRectangle(0, 0, this._width, size.y);
            }
            g.setClipping(this._margin + this._horizontalTrim, 0, this._width - (this._margin + this._horizontalTrim), size.y);
            g.setForeground(this._styleAttributes.foregroundColor().getColor());
            g.drawString(this._displayText, x, 0, true);
            if (this._column == 0) {
                if (this._firstCol == 0) {
                    this._columnX = x;
                    this._columnWidth = this._insertCursorWidth == 1 ? 1 : 2;
                    g.setBackground(this._styleAttributes.foregroundColor().getColor());
                    g.fillRectangle(this._columnX, 0, this._columnWidth, size.y);
                } else {
                    this._columnWidth = 0;
                }
            } else if (this._column > 0) {
                int col = this._column - this._firstCol - 1;
                if (col >= 0 && col < this._displayText.length()) {
                    this._columnX = x + g.stringExtent((String)this._displayText.substring((int)0, (int)col)).x;
                    this._columnWidth = g.stringExtent((String)this._displayText.substring((int)col, (int)(col + 1))).x;
                    g.setBackground(this._styleAttributes.foregroundColor().getColor());
                    g.fillRectangle(this._columnX, 0, this._columnWidth, size.y);
                    g.setForeground(this._styleAttributes.backgroundColor().getColor());
                    g.drawString(this._displayText.substring(col, col + 1), this._columnX, 0, true);
                } else {
                    this._columnWidth = 0;
                }
            }
        }
        this._formatValid = true;
    }

    private static String ruler(int firstCol, int lastCol) {
        if (firstCol == 0 && lastCol <= 110) {
            return "----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+---10----+---11-";
        }
        StringBuilder sb = new StringBuilder(112);
        int firstNumber = firstCol + 1;
        int indent = firstCol % 10;
        if (indent != 0) {
            sb.append(FormatLine.tenRulerColumns(firstNumber - indent).substring(indent));
            firstNumber += 10 - indent;
        }
        int i = firstNumber;
        while (i <= lastCol) {
            sb.append(FormatLine.tenRulerColumns(i));
            i += 10;
        }
        return sb.toString();
    }

    private static String tenRulerColumns(int beginCol) {
        if (beginCol < 91) {
            return "----+----" + (beginCol / 10 + 1);
        }
        if (beginCol < 991) {
            return "----+---" + (beginCol / 10 + 1);
        }
        StringBuilder sb = new StringBuilder(Integer.toString(beginCol / 10 + 1));
        if (sb.length() > 5) {
            return "--" + sb.substring(0, 5) + "...";
        }
        int i = 10 - sb.length();
        while (i > 0) {
            sb.insert(0, i == 5 ? (char)'+' : '-');
            --i;
        }
        return sb.toString();
    }

    void setColumn(int column) {
        if (this.getParent() instanceof LpexWindow) {
            LpexWindow parent = (LpexWindow)this.getParent();
            LpexView view = parent.getLpexView();
            column = RealColumnNumbersParameter.getRealColumnNumber(view._view, column);
        }
        if (this._column != column) {
            if (this._formatValid && this.getSize().y != 0) {
                if (this._columnWidth != 0) {
                    this.redraw(this._columnX, 0, this._columnWidth, this.getSize().y, false);
                }
                if (column == 0 && this._firstCol == 0) {
                    this.redraw(this._displayTextX, 0, 2, this.getSize().y, false);
                } else {
                    int col = column - this._firstCol - 1;
                    if (col >= 0 && col < this._displayText.length()) {
                        GC g = new GC((Drawable)this);
                        this.redraw(this._displayTextX + g.stringExtent((String)this._displayText.substring((int)0, (int)col)).x, 0, g.stringExtent((String)this._displayText.substring((int)col, (int)(col + 1))).x, this.getSize().y, false);
                        g.dispose();
                    }
                }
            } else {
                this._formatValid = false;
            }
            this._column = column;
        }
    }

    boolean setFont(Font font, StyleAttributes styleAttributes) {
        boolean fontChanged = false;
        int oldTextHeight = this._textHeight;
        if (this._styleAttributes == null || !this._styleAttributes.equals(styleAttributes)) {
            if (this._styleAttributes == null || this._styleAttributes.bold() != styleAttributes.bold() || this._styleAttributes.italic() != styleAttributes.italic()) {
                fontChanged = true;
            }
            this._styleAttributes = styleAttributes;
            this._formatValid = false;
        }
        if (this._font == null || !this._font.equals(font)) {
            fontChanged = true;
            this._font = font;
            this.disposeFonts();
            this._formatValid = false;
        }
        if (fontChanged && this._font != null) {
            this.setFont(this.currentFont().getFont());
            GC g = new GC((Drawable)this);
            g.setFont(this.currentFont().getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            this._textHeight = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
            this._spaceWidth = g.stringExtent((String)" ").x;
            g.dispose();
        }
        return fontChanged && oldTextHeight != this._textHeight && this.isVisible();
    }

    void setMargin(int margin) {
        if (this._margin != margin) {
            this._margin = margin;
            this._formatValid = false;
        }
    }

    void showing(View view) {
        int scroll;
        Screen screen = view.screen();
        String text = screen.formatLineText();
        if (!(this._text == null && text == null || this._text != null && this._text.equals(text))) {
            this._text = text;
            this._formatValid = false;
        }
        if (this._boundsStartCol != view.getBoundsStartCol() || this._boundsEndCol != view.getBoundsEndCol()) {
            this._boundsStartCol = view.getBoundsStartCol();
            this._boundsEndCol = view.getBoundsEndCol();
            this._formatValid = false;
        }
        if (this._scroll != (scroll = screen.scroll())) {
            this._scroll = scroll;
            this._formatValid = false;
        }
        this._insertCursorWidth = view.cursorWidth();
    }

    void updateFormat() {
        if (!this._formatValid && this.getSize().y != 0) {
            this.redraw();
        }
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameFormatLine");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.descFormatLine");
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                e.result = String.valueOf(FormatLine.this._column);
            }
        });
    }
}

