/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.FontParameter;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexUtilities;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

final class Font {
    private static final String FONT_KEY_PREFIX = "defaultfont_";
    private org.eclipse.swt.graphics.Font _font;
    private org.eclipse.swt.graphics.Font _internalFont;
    private String _name;
    private int _style;
    private int _height;

    Font(Device device, String name, int style, int height) {
        this._name = name;
        this._style = style;
        this._height = height;
        this._font = this._internalFont = new org.eclipse.swt.graphics.Font(device, this._name, this._height, this._style);
    }

    Font(Device device, FontData fontData) {
        this._font = this._internalFont = new org.eclipse.swt.graphics.Font(device, fontData);
        this._name = fontData.getName();
        this._style = fontData.getStyle();
        this._height = fontData.getHeight();
    }

    Font(Device device, FontData[] fontDatas) {
        this._font = this._internalFont = new org.eclipse.swt.graphics.Font(device, fontDatas);
        this._name = fontDatas[0].getName();
        this._style = fontDatas[0].getStyle();
        this._height = fontDatas[0].getHeight();
    }

    Font(org.eclipse.swt.graphics.Font font) {
        this._font = font;
        this._internalFont = null;
        FontData[] fontData = this._font.getFontData();
        this._name = fontData[0].getName();
        this._style = fontData[0].getStyle();
        this._height = fontData[0].getHeight();
    }

    String getName() {
        return this._name;
    }

    int getSize() {
        return this._height;
    }

    int getStyle() {
        return this._style;
    }

    static Font decodeFont(Device device, String fontNameString) {
        block20: {
            try {
                if (fontNameString == null) {
                    fontNameString = Font.getDefaultFont();
                }
                if (fontNameString == null) {
                    if (device == null || device instanceof Display) {
                        return new Font(device, JFaceResources.getTextFont().getFontData());
                    }
                    break block20;
                }
                StringTokenizer st = new StringTokenizer(fontNameString, "-");
                StringBuilder name = new StringBuilder(st.nextToken().trim());
                int style = 0;
                int height = 10;
                boolean styleFound = false;
                while (st.hasMoreElements()) {
                    String token = st.nextToken().trim();
                    if (styleFound) {
                        try {
                            height = Integer.parseInt(token);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (token.equalsIgnoreCase("bolditalic") || token.equalsIgnoreCase("bold italic")) {
                        styleFound = true;
                        style = 3;
                        continue;
                    }
                    if (token.equalsIgnoreCase("bold")) {
                        styleFound = true;
                        style = 1;
                        continue;
                    }
                    if (token.equalsIgnoreCase("italic")) {
                        styleFound = true;
                        style = 2;
                        continue;
                    }
                    if (token.equalsIgnoreCase("regular")) {
                        styleFound = true;
                        continue;
                    }
                    try {
                        height = Integer.parseInt(token);
                        styleFound = true;
                    }
                    catch (NumberFormatException x) {
                        name.append('-');
                        name.append(token);
                    }
                }
                return new Font(device, name.toString(), style, height);
            }
            catch (Throwable st) {
                // empty catch block
            }
        }
        String platform = SWT.getPlatform();
        if ("win32".equalsIgnoreCase(platform)) {
            return new Font(device, "Courier New", 0, 10);
        }
        if ("linux".equalsIgnoreCase(platform) || "gtk".equalsIgnoreCase(platform)) {
            return new Font(device, "Monospace", 0, 10);
        }
        if ("carbon".equalsIgnoreCase(platform) || "macosx".equalsIgnoreCase(platform)) {
            return new Font(device, "Monaco", 0, 11);
        }
        if ("qnx".equalsIgnoreCase(platform)) {
            return new Font(device, "TextFont", 0, 9);
        }
        if ("hpux".equalsIgnoreCase(platform)) {
            return new Font(device, "adobe-courier", 0, 14);
        }
        return new Font(device, "adobe-courier", 0, 12);
    }

    private static String getDefaultFont() {
        String result = null;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = FontParameter.class.getResourceAsStream("defaultFont.properties");){
                String key = Font.getDefaultFontKey();
                Properties fontProperties = new Properties();
                fontProperties.load(inputStream);
                int i = 0;
                while (i < 3 && result == null) {
                    String fontName = fontProperties.getProperty(key + "." + i);
                    if (fontName != null && Font.decodeFont(fontName) != null) {
                        result = fontName;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
        return result;
    }

    private static String getDefaultFontKey() {
        String os = System.getProperty("os.name").trim();
        String nl = Platform.getNL();
        os = StringConverter.removeWhiteSpaces((String)os).toLowerCase();
        nl = StringConverter.removeWhiteSpaces((String)nl).toLowerCase();
        return FONT_KEY_PREFIX + os + "_" + nl;
    }

    static Font decodeFont(String fontNameString) {
        return Font.decodeFont(null, fontNameString);
    }

    static Font decodeFontData(Device device, String fontDataString) {
        FontData[] fontData = LpexUtilities.fontDataFromString(fontDataString);
        return fontData != null ? new Font(device, fontData) : null;
    }

    static Font decodeFontData(String fontDataString) {
        return Font.decodeFontData(null, fontDataString);
    }

    static String nameString(Font font) {
        if (font != null) {
            StringBuilder fontName = new StringBuilder(48);
            fontName.append(font.getName());
            int style = font.getStyle();
            if ((style & 3) == 3) {
                fontName.append("-bold italic");
            } else if ((style & 1) != 0) {
                fontName.append("-bold");
            } else if ((style & 2) != 0) {
                fontName.append("-italic");
            } else {
                fontName.append("-regular");
            }
            fontName.append('-');
            fontName.append(font.getSize());
            return fontName.toString();
        }
        return null;
    }

    static String fontDataString(Font font) {
        return font != null ? LpexUtilities.fontDataToString(font.getFont().getFontData()) : null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void dispose() {
        if (this._internalFont != null) {
            Runnable runDispose = new Runnable(){

                @Override
                public void run() {
                    if (Font.this._internalFont != null && !Font.this._internalFont.isDisposed()) {
                        Font.this._internalFont.dispose();
                    }
                }
            };
            Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(runDispose);
            } else {
                runDispose.run();
            }
        }
    }

    org.eclipse.swt.graphics.Font getFont() {
        return this._font;
    }

    public String toString() {
        return Font.nameString(this);
    }
}

